/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseRow;
import com.sap.sdb.minDB.common.ResultSetRowHandling;
import com.sap.sdb.minDB.common.Row;
import com.sap.sdb.minDB.common.StatementDummy;
import com.sap.sdb.minDB.dataAccess.Table;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseResultSet;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseTable;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;

public class ResultSetImpl
extends ResultSetRowHandling
implements DatabaseResultSet {
    private int m_resultSize = 0;
    private int m_currRowNo = 0;
    private int m_maxNumericColNo;
    private int m_maxObjectColNo;
    private Iterator m_iter = null;
    private LinkedList m_resultList = null;
    private StatementDummy m_stmt = null;

    public void beforeFirst() {
        if (this.m_resultSize <= 0) {
            return;
        }
        this.m_currRowNo = 0;
        this.m_iter = null;
        super.resetCurrentRow();
        this.resultCreated();
    }

    public void close() throws SQLException {
        if (this.m_stmt != null) {
            this.m_stmt.closeResultSet();
            return;
        }
        this.clearReferences();
    }

    public boolean first() {
        if (this.m_resultSize <= 0) {
            return false;
        }
        if (this.m_currRowNo != 0) {
            this.beforeFirst();
        }
        return this.next();
    }

    public int getRow() {
        return this.m_currRowNo;
    }

    public Statement getStatement() throws SQLException {
        if (this.m_stmt == null) {
            throw ErrorMsg.newSQLException("Statement is undefined", -3008);
        }
        return this.m_stmt;
    }

    public boolean isAfterLast() {
        return this.m_resultSize > 0 && this.m_currRowNo > this.m_resultSize;
    }

    public boolean isBeforeFirst() {
        return this.m_resultSize > 0 && this.m_currRowNo == 0;
    }

    public boolean isFirst() {
        return this.m_resultSize > 0 && this.m_currRowNo == 1;
    }

    public boolean isLast() {
        return this.m_resultSize > 0 && this.m_currRowNo == this.m_resultSize;
    }

    public boolean last() {
        if (this.m_resultSize <= 0) {
            return false;
        }
        this.m_currRowNo = this.m_resultSize;
        this.m_iter = null;
        super.setCurrentRow((Row)this.m_resultList.getLast());
        return true;
    }

    public boolean next() {
        if (this.m_resultSize <= 0 || this.m_currRowNo > this.m_resultSize) {
            return false;
        }
        ++this.m_currRowNo;
        if (this.m_currRowNo > this.m_resultSize) {
            super.resetCurrentRow();
            return false;
        }
        super.setCurrentRow((Row)this.m_iter.next());
        return true;
    }

    public ResultSetImpl(int maxNumericColNo, int maxObjectColNo, String[] schemaList, String[] tabIdentifierList, String[] colNameList, byte[] colTypeList) {
        this.m_maxNumericColNo = maxNumericColNo;
        this.m_maxObjectColNo = maxObjectColNo;
        super.initMetaData(schemaList, tabIdentifierList, colNameList, colTypeList);
    }

    public ResultSetImpl(DatabaseTable tab) {
        this.m_maxNumericColNo = tab.getMaxNumericColNo();
        this.m_maxObjectColNo = tab.getMaxObjectColNo();
        String[] colSchemaList = new String[1];
        String[] colTabNameList = new String[1];
        colSchemaList[0] = tab.getSchemaName();
        colTabNameList[0] = tab.getTableIdentifier();
        super.initMetaData(colSchemaList, colTabNameList, ((Table)tab).getColumnNameList(), ((Table)tab).getColumnTypeList());
    }

    public int addRow(DatabaseRow resultRow) {
        if (this.m_resultList == null) {
            this.m_resultList = new LinkedList();
        }
        this.m_resultList.add(resultRow);
        return this.m_resultList.size();
    }

    public void clearReferences() {
        super.clearReferences();
        this.m_resultSize = 0;
        this.m_currRowNo = 0;
        this.m_iter = null;
        this.m_resultList = null;
        this.m_stmt = null;
    }

    public Row getLastRow() {
        if (this.last()) {
            return super.getCurrentRow();
        }
        return null;
    }

    public DatabaseRow getNewResultRow() {
        return new Row(this.m_maxNumericColNo, this.m_maxObjectColNo);
    }

    public Row getNextRow() {
        if (this.next()) {
            return super.getCurrentRow();
        }
        return null;
    }

    public int getResultSize() {
        return this.m_resultSize;
    }

    public void resultCreated() {
        if (this.m_resultList == null) {
            return;
        }
        this.m_resultSize = this.m_resultList.size();
        this.m_iter = this.m_resultList.listIterator();
    }

    public void setIteratorAndResultSize(Iterator iter, int resultSize) {
        this.m_iter = iter;
        this.m_resultSize = resultSize;
    }

    void setLastRow(Row lastRow) {
        this.m_currRowNo = this.m_resultSize;
        this.m_iter = null;
        super.setCurrentRow(lastRow);
    }

    public void setStatement(StatementDummy stmt) {
        this.m_stmt = stmt;
    }

    public void triggerInitMetaData() {
    }
}

