/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.ColumnType;
import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.common.Row;
import com.sap.sdb.minDB.dataAccess.AnyKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import java.io.IOException;
import java.sql.SQLException;

public class MultiColKey
extends AnyKey {
    private int m_initializedCols = 0;
    private Row m_keyCols;

    MultiColKey() {
        this.m_keyCols = null;
    }

    public MultiColKey(int keyColums) {
        this.m_keyCols = new Row(keyColums, keyColums);
    }

    public void addCol(int colNo, long keyValue) {
        this.m_keyCols.setNumericCol(colNo, keyValue);
        if (this.m_initializedCols < colNo) {
            this.m_initializedCols = colNo;
        }
    }

    public void addCol(int colNo, String keyValue) {
        this.m_keyCols.setCharCol(colNo, keyValue);
        if (this.m_initializedCols < colNo) {
            this.m_initializedCols = colNo;
        }
    }

    public void addCol(int colNo, Object keyValue) {
        this.m_keyCols.setObjectCol(colNo, keyValue);
        if (this.m_initializedCols < colNo) {
            this.m_initializedCols = colNo;
        }
    }

    public int compareTo(Object o) {
        MultiColKey other = (MultiColKey)o;
        block7: for (int colNo = 1; colNo <= this.m_keyCols.getMaxColNo(); ++colNo) {
            if (colNo > this.m_initializedCols) {
                return this.m_initializedCols == other.m_initializedCols ? 0 : -1;
            }
            if (colNo > other.m_initializedCols) {
                return 1;
            }
            try {
                byte thisColState = this.m_keyCols.getColumnState(colNo);
                if (other.m_keyCols.isNull(colNo) && thisColState != 0) {
                    return 2;
                }
                switch (thisColState) {
                    case 0: {
                        return -2;
                    }
                    case 4: {
                        long thisNumber = this.m_keyCols.getNumericCol(colNo);
                        long otherNumber = other.m_keyCols.getNumericCol(colNo);
                        if (thisNumber < otherNumber) {
                            return -1;
                        }
                        if (thisNumber <= otherNumber) continue block7;
                        return 1;
                    }
                    case 2: {
                        int compareResult = this.m_keyCols.getCharCol(colNo).compareTo(other.m_keyCols.getCharCol(colNo));
                        if (compareResult == 0) continue block7;
                        return compareResult;
                    }
                    default: {
                        int compareResult = ColumnType.compareObject(this.m_keyCols.getObjectCol(colNo), other.m_keyCols.getObjectCol(colNo));
                        if (compareResult == 0) continue block7;
                        return compareResult;
                    }
                }
            }
            catch (SQLException ex) {
                return -1;
            }
        }
        return 0;
    }

    public boolean isGreaterStopKey(DatabaseKey stopKey) {
        MultiColKey other = (MultiColKey)stopKey;
        block6: for (int colNo = 1; colNo <= this.m_keyCols.getMaxColNo(); ++colNo) {
            if (colNo > this.m_initializedCols || colNo > other.m_initializedCols) {
                return false;
            }
            try {
                byte thisColState = this.m_keyCols.getColumnState(colNo);
                if (thisColState == 0 || other.m_keyCols.isNull(colNo)) {
                    return false;
                }
                switch (thisColState) {
                    case 4: {
                        long thisNumber = this.m_keyCols.getNumericCol(colNo);
                        long otherNumber = other.m_keyCols.getNumericCol(colNo);
                        if (thisNumber < otherNumber) {
                            return false;
                        }
                        if (thisNumber <= otherNumber) continue block6;
                        return true;
                    }
                    case 2: {
                        int compareResult = this.m_keyCols.getCharCol(colNo).compareTo(other.m_keyCols.getCharCol(colNo));
                        if (compareResult == 0) continue block6;
                        return compareResult > 0;
                    }
                    default: {
                        Object thisObj = this.m_keyCols.getObjectCol(colNo);
                        Object otherObj = other.m_keyCols.getObjectCol(colNo);
                        if (thisObj == null || otherObj == null) {
                            return false;
                        }
                        int compareResult = ColumnType.compareObject(thisObj, otherObj);
                        if (compareResult == 0) continue block6;
                        return compareResult > 0;
                    }
                }
            }
            catch (SQLException ex) {
                return false;
            }
        }
        return false;
    }

    void readFromStream(DatabaseInputStream inStream) throws IOException {
        this.m_initializedCols = inStream.readInt();
        this.m_keyCols = Row.createFromStream(inStream);
    }

    public String toString() {
        if (this.m_initializedCols == 0) {
            return "<empty>";
        }
        StringBuffer str = new StringBuffer(128);
        for (int colNo = 1; colNo <= this.m_initializedCols; ++colNo) {
            try {
                byte colState = this.m_keyCols.getColumnState(colNo);
                switch (colState) {
                    case 0: {
                        str.append("undef");
                        break;
                    }
                    case 4: {
                        str.append(this.m_keyCols.getNumericCol(colNo));
                        break;
                    }
                    case 2: {
                        str.append("'");
                        str.append(this.m_keyCols.getCharCol(colNo));
                        str.append("'");
                        break;
                    }
                    default: {
                        str.append("obj[");
                        str.append(this.m_keyCols.getObjectCol(colNo));
                        str.append("]");
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                str.append("[key column ");
                str.append(colNo);
                str.append(" not exists]");
            }
            if (colNo >= this.m_initializedCols) continue;
            str.append(" ");
        }
        return str.toString();
    }

    void writeToStream(DatabaseOutputStream outStream) throws IOException {
        outStream.writeByte(5);
        outStream.writeInt(this.m_initializedCols);
        this.m_keyCols.writeToStream(outStream);
    }
}

