/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.dataAccess.AnyKey;
import com.sap.sdb.minDB.dataAccess.IndexKey;
import com.sap.sdb.minDB.dataAccess.TableRow;
import com.sap.sdb.minDB.dataAccessInterface.ConnectionHandle;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseTable;
import com.sap.sdb.minDB.util.Console;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class IndexTable {
    private boolean m_isUnique;
    private int m_indexNo;
    private int[] m_indexColNoList;
    private boolean[] m_isColAscList;
    private String m_indexName;
    private TreeMap m_indexTree;

    IndexTable() {
        this.m_isUnique = false;
        this.m_indexNo = -1;
        this.m_indexColNoList = null;
        this.m_isColAscList = null;
        this.m_indexName = null;
        this.m_indexTree = new TreeMap();
    }

    IndexTable(DatabaseTable tab, String indexName, int indexNo, boolean isUnique, LinkedList indexColumnNames, LinkedList isColAscList) throws SQLException {
        this.m_isUnique = isUnique;
        this.m_indexName = indexName;
        this.m_indexNo = indexNo;
        this.m_indexTree = new TreeMap();
        int maxIndexCols = indexColumnNames.size();
        this.m_indexColNoList = new int[1 + maxIndexCols];
        this.m_isColAscList = new boolean[1 + maxIndexCols];
        this.m_indexColNoList[0] = -1;
        this.m_isColAscList[0] = false;
        Iterator colIter = indexColumnNames.iterator();
        Iterator ascIter = isColAscList.iterator();
        int indexCol = 0;
        while (colIter.hasNext()) {
            this.m_indexColNoList[++indexCol] = tab.getColumnNo((String)colIter.next());
            this.m_isColAscList[indexCol] = (Boolean)ascIter.next();
        }
    }

    IndexKey checkUniqueGetKey(TableRow row) throws SQLException {
        IndexKey indexKey = new IndexKey(this.m_isUnique, this.m_indexNo, row, this.m_indexColNoList, this.m_isColAscList);
        if (!this.m_isUnique) {
            return indexKey;
        }
        if (this.m_indexTree.containsKey(indexKey)) {
            throw this.newDuplIndexException(indexKey);
        }
        return indexKey;
    }

    IndexKey checkUniqueGetKey(ConnectionHandle connection, TableRow row) throws SQLException {
        IndexKey indexKey = new IndexKey(this.m_isUnique, this.m_indexNo, row, this.m_indexColNoList, this.m_isColAscList);
        if (!this.m_isUnique) {
            return indexKey;
        }
        TableRow existingRow = this.findIndexRow(indexKey);
        if (existingRow != null && (!existingRow.isDeleted() || existingRow.isLockCollision(connection))) {
            throw this.newDuplIndexException(indexKey);
        }
        return indexKey;
    }

    TableRow findIndexRow(DatabaseKey indexKey) {
        return (TableRow)this.m_indexTree.get(indexKey);
    }

    public int getIndexColumnNo(int rowColNo) {
        for (int indexCol = 1; indexCol < this.m_indexColNoList.length; ++indexCol) {
            if (this.m_indexColNoList[indexCol] != rowColNo) continue;
            return indexCol;
        }
        return -1;
    }

    public Iterator getIndexIterator() {
        return this.m_indexTree.values().iterator();
    }

    public Iterator getIndexIteratorGreaterEqual(DatabaseKey startKey) {
        if (startKey == null || ((IndexKey)startKey).isEmpty()) {
            return this.getIndexIterator();
        }
        SortedMap treeTail = this.m_indexTree.tailMap(startKey);
        return treeTail.values().iterator();
    }

    String getIndexName() {
        return this.m_indexName;
    }

    int getIndexNumber() {
        return this.m_indexNo;
    }

    public int getMaxIndexColumns() {
        return this.m_indexColNoList.length - 1;
    }

    public DatabaseKey getNewIndexKey() {
        return new IndexKey(this.m_isUnique, this.m_indexNo, this.m_indexColNoList, this.m_isColAscList);
    }

    public int getRowColumnNo(int indexColNo) {
        return indexColNo > 0 && indexColNo < this.m_indexColNoList.length ? this.m_indexColNoList[indexColNo] : -1;
    }

    public int getRowCount() {
        return this.m_indexTree.size();
    }

    void insertIndexRow(TableRow row) {
        IndexKey indexKey = (IndexKey)row.getKey(this.m_indexNo);
        if (indexKey == null) {
            indexKey = new IndexKey(this.m_isUnique, this.m_indexNo, row, this.m_indexColNoList, this.m_isColAscList);
            row.setIndexKey(this.m_indexNo, indexKey);
        }
        this.m_indexTree.put(indexKey, row);
    }

    public boolean isAscending(int indexColNo) {
        return indexColNo > 0 && indexColNo < this.m_indexColNoList.length ? this.m_isColAscList[indexColNo] : true;
    }

    public boolean isUnique() {
        return this.m_isUnique;
    }

    private SQLException newDuplIndexException(DatabaseKey indexKey) {
        return ErrorMsg.newSQLException("Duplicate unique index " + this.m_indexName.toString() + " (" + ((Object)indexKey).toString() + ")", 250);
    }

    public synchronized void printContents() {
        Console.println();
        Console.println("===== index " + this.m_indexName + " (entries: " + this.m_indexTree.size() + ") =====");
        int rowCount = 0;
        Iterator iter = this.m_indexTree.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry currEntry = iter.next();
            AnyKey key = (AnyKey)currEntry.getKey();
            TableRow row = (TableRow)currEntry.getValue();
            row.printContents(++rowCount);
            Console.println("      KEY: " + key.toString());
        }
        Console.println();
        Console.println("==== end of " + this.m_indexName + " =====");
        Console.println();
    }

    void readMetaDataFromStream(DatabaseInputStream inStream) throws IOException {
        this.m_isUnique = inStream.readBoolean();
        this.m_indexNo = inStream.readInt();
        this.m_indexColNoList = inStream.readIntArray();
        this.m_isColAscList = inStream.readBooleanArray();
        this.m_indexName = inStream.readString();
    }

    void removeAllIndexRows() {
        this.m_indexTree.clear();
    }

    void removeIndexRow(DatabaseKey indexKey) {
        this.m_indexTree.remove(indexKey);
    }

    void replaceIndexRow(TableRow row) {
        this.m_indexTree.put(row.getKey(this.m_indexNo), row);
    }

    void updateRowEntry(TableRow row) throws SQLException {
        IndexKey newIndexKey;
        DatabaseKey oldIndexKey = row.getKey(this.m_indexNo);
        if (oldIndexKey.compareTo(newIndexKey = new IndexKey(this.m_isUnique, this.m_indexNo, row, this.m_indexColNoList, this.m_isColAscList)) == 0) {
            return;
        }
        this.m_indexTree.remove(oldIndexKey);
        if (this.m_isUnique && this.m_indexTree.containsKey(newIndexKey)) {
            throw this.newDuplIndexException(newIndexKey);
        }
        row.setIndexKey(this.m_indexNo, newIndexKey);
        this.m_indexTree.put(newIndexKey, row);
    }

    void writeMetaDataToStream(DatabaseOutputStream outStream) throws IOException {
        outStream.writeBoolean(this.m_isUnique);
        outStream.writeInt(this.m_indexNo);
        outStream.writeIntArray(this.m_indexColNoList);
        outStream.writeBooleanArray(this.m_isColAscList);
        outStream.writeString(this.m_indexName);
    }
}

