/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import com.sap.sdb.minDB.common.AnyConnectionImpl;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public abstract class AnyDriverImpl
implements Driver {
    private SQLException m_registerException = null;
    private static final String CONNECT_USER_PROPERTY = "user";
    private static final String CONNECT_PASSWORD_PROPERTY = "password";
    public static final String DATABASE_VERSION = "1.1.04";
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 1;

    public boolean acceptsURL(String url) {
        String x = this.getURLPrefix();
        return url.startsWith(x);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (this.m_registerException != null) {
            throw this.m_registerException;
        }
        String username = info.getProperty(CONNECT_USER_PROPERTY);
        String password = info.getProperty(CONNECT_PASSWORD_PROPERTY);
        return this.getNewConnection(url, username, password);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        DriverPropertyInfo[] infoArray = new DriverPropertyInfo[2];
        DriverPropertyInfo currInfo = new DriverPropertyInfo("USER_PROPERTY_NAME", null);
        currInfo.value = info.getProperty("USER_PROPERTY_NAME");
        currInfo.required = true;
        infoArray[0] = currInfo;
        currInfo = new DriverPropertyInfo("PASSWORD_PROPERTY_NAME", null);
        currInfo.value = info.getProperty("PASSWORD_PROPERTY_NAME");
        currInfo.required = true;
        infoArray[1] = currInfo;
        return infoArray;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public abstract String getDriverClassName();

    public String getDriverName() {
        return this.getDriverProductName() + " JDBC Driver, " + this.getDriverClassName();
    }

    public abstract String getDriverProductName();

    public String getDriverVersion() {
        return DATABASE_VERSION;
    }

    public abstract AnyConnectionImpl getNewConnection(String var1, String var2, String var3) throws SQLException;

    public String getProductName() {
        return this.getDriverProductName();
    }

    public String getProductVersion() {
        return DATABASE_VERSION;
    }

    public abstract String getURLPrefix();

    public PreparedStatement newPreparedStatement(AnyConnectionImpl connection, String sql) throws SQLException {
        throw ErrorMsg.notSupported("PreparedStatement.newPreparedStatement (" + connection.getUsername() + ", " + sql + ")");
    }

    public void registerAtDriverManager() {
        if (this.m_registerException == null) {
            try {
                DriverManager.registerDriver(this);
            }
            catch (SQLException ex) {
                this.m_registerException = ex;
                System.out.println(ex.getMessage());
            }
        }
    }
}

