/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.starter.Host;
import com.sap.sapdb.benchmark.tp2.util.starter.HostDirNode;
import com.sap.sapdb.benchmark.tp2.util.starter.NewHostDirDialog;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

class HostNode
extends StarterNode
implements ActionListener {
    private Host host = null;

    public HostNode(Host host) {
        super(host.getHostName());
        this.host = host;
        this.popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("New dir ...");
        item.addActionListener(this);
        item.setActionCommand("addDir");
        this.popup.add(item);
        this.popup.add(new JSeparator());
        item = new JMenuItem("Remove");
        item.addActionListener(this);
        item.setActionCommand("remove");
        this.popup.add(item);
    }

    public Host getHost() {
        return this.host;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("remove")) {
            StarterEnv.getStarterTreeModel().removeHost(this);
        } else if (evt.getActionCommand().equals("addDir")) {
            NewHostDirDialog diag = new NewHostDirDialog(StarterEnv.getStarterGUI(), this);
            try {
                String dir = diag.getDir();
                this.host.addDir(dir);
            }
            catch (StarterException e) {
                StarterEnv.throwException(e);
            }
        }
    }

    public void addHostDirNode(String dir) {
        this.add(new HostDirNode(dir));
        StarterEnv.getStarterGUI().nodeStructureChanged(this);
    }
}

