/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util;

import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.util.PsProcess;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.TreeSet;

public class Tp2Ps {
    private TreeSet procList = null;
    private int simulatedUsersTime;
    private int javaTime;
    private int kernelTime;
    private int totalTime;
    private String executableName;
    private String header;

    public Tp2Ps(String executableName) {
        this.executableName = executableName;
    }

    public Tp2Ps executePs() throws Tp2Exception {
        try {
            this.procList = new TreeSet();
            this.simulatedUsersTime = 0;
            this.javaTime = 0;
            this.kernelTime = 0;
            this.totalTime = 0;
            Process proc = Runtime.getRuntime().exec("ps -ae");
            BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            this.header = in.readLine();
            while ((line = in.readLine()) != null) {
                PsProcess psProc = new PsProcess(line);
                this.procList.add(psProc);
                if (psProc.getName().toLowerCase().indexOf("java") >= 0) {
                    this.javaTime += psProc.getCpuTime();
                } else if (psProc.getName().toLowerCase().indexOf("kernel") >= 0) {
                    this.kernelTime += psProc.getCpuTime();
                } else if (psProc.getName().toLowerCase().indexOf(this.executableName.toLowerCase()) >= 0) {
                    this.simulatedUsersTime += psProc.getCpuTime();
                }
                this.totalTime += psProc.getCpuTime();
            }
            in.close();
            return this;
        }
        catch (Exception e) {
            throw new Tp2Exception("Unexpected exception in Tp2Ps.init()", 0, e);
        }
    }

    public int getJavaTime() {
        return this.javaTime;
    }

    public int getKernelTime() {
        return this.kernelTime;
    }

    public int getSimulatedUsersTime() {
        return this.simulatedUsersTime;
    }

    public int getTotalTime() {
        return this.totalTime;
    }
}

