/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util;

import com.sap.sapdb.benchmark.tp2.util.FTPConnection;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class FtpTransport {
    private String host = null;
    private FTPConnection ftpConn = null;
    private String user = null;
    private String password = null;
    private boolean connected = false;

    public FtpTransport(String host, String user, String password) throws IOException {
        this.host = host;
        this.ftpConn = new FTPConnection();
        this.ftpConn.connect(host);
        this.user = user;
        this.password = password;
        this.connected = this.ftpConn.login(user, password);
        if (!this.connected) {
            throw new IOException("Could not connect to " + host + " with user " + user);
        }
        FtpTransport.stdOut("@@@ FtpTransport connected to ftp://" + host);
    }

    public String getAsString(String path) throws IOException {
        StringBuffer result = new StringBuffer("");
        boolean ok = this.ftpConn.executeDataCommand("retr " + path, result);
        if (ok) {
            FtpTransport.stdOut("Get " + path + " from " + this.host);
            return result.toString();
        }
        throw new IOException("Could not get " + path + " from " + this.host);
    }

    public void put(String path, String toPut) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(toPut.getBytes());
        boolean ok = this.ftpConn.executeDataCommand("stor " + path, in);
        if (!ok) {
            throw new IOException("Could not put " + path + " on " + this.host);
        }
        FtpTransport.stdOut("Put " + path + " on " + this.host);
    }

    public String listFiles(String path) throws IOException {
        return this.ftpConn.listFiles(path);
    }

    public void cd(String dirPath) throws IOException {
        this.ftpConn.changeDirectory(dirPath);
    }

    public void close() throws IOException {
        this.ftpConn.logout();
        this.ftpConn.disconnect();
        this.connected = false;
        FtpTransport.stdOut("@@@ FtpTransport closed connection to ftp://" + this.host);
    }

    public boolean isClosed() {
        return !this.connected;
    }

    public static void stdOut(Object obj) {
        System.out.println("[FtpTransport] " + obj);
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }
}

