/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.OutputLevels;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.NonPersistentReport;
import com.sap.sapdb.benchmark.tp2.common.PropertyException;
import com.sap.sapdb.benchmark.tp2.common.Tp2Case;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.common.Tp2Result;
import com.sap.sapdb.benchmark.tp2.test.BadResultException;
import com.sap.sapdb.benchmark.tp2.test.CaseEnv;
import com.sap.sapdb.benchmark.tp2.test.CaseMonitor;
import com.sap.sapdb.benchmark.tp2.test.SingleTest;
import com.sap.sapdb.benchmark.tp2.test.SingleTestId;
import com.sap.sapdb.benchmark.tp2.test.TestDbInit;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public abstract class Tp2TestCase
extends TestCase
implements OutputLevels {
    private int defaultDuration;
    private TreeMap testsDone = new TreeMap();
    private TreeMap testsFailed = new TreeMap();
    private int tryCount = 2;
    private int scaleFactor = -1;
    private int noOfExecutions = -1;
    private CaseMonitor caseMonitor = null;

    protected Tp2TestCase() throws SQLException, TestDatabaseException {
        try {
            if (!Tp2Env.isInitialized()) {
                Tp2Env.initTp2Env();
            }
            this.caseMonitor = new CaseMonitor(this);
            this.tryCount = Integer.parseInt(this.getCaseEnv().getProp("tp2.ext.tryCount"));
            this.scaleFactor = Integer.parseInt(this.getCaseEnv().getProp("tp2.ext.scaleFactor"));
            this.defaultDuration = Integer.parseInt(this.getCaseEnv().getProp("tp2.test.duration"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Impossible to initialize the test because of " + e);
        }
    }

    protected abstract void runCase() throws Tp2Exception;

    public final void run() {
        String outString = "";
        try {
            this.stdOut("*******************************************************************");
            this.stdOut("Begin of Tp2Case " + this.caseMonitor.getCaseTypeWithId() + " (for user " + this.getTp2Case().getUser().getName() + ")");
            this.stdOut("*******************************************************************");
            this.stdOut("User: " + this.getTp2Case().getUser().getName() + " (desc: " + this.getTp2Case().getUser().getDescription() + ")", 10);
            if (Tp2Env.isMaxGlobalDurationSet()) {
                this.stdOut("Max global duration is: " + Tp2Env.getMaxGlobalDurationFormatted());
                this.stdOut("SingleTest will be interrupted around " + Tp2Env.getGlobalEndTimeFormatted());
            }
            this.stdOut("Usual duration of init: " + Tp2Env.getLocalUsualInitDuration() + "s (measured " + Tp2Env.getNbrOfInitDurationMeasures() + " times)", 10);
            this.stdOut("Usual duration of run utilities: " + Tp2Env.getLocalUsualRunUtilitiesDuration() + "s (measured " + Tp2Env.getNbrOfRunUtilitiesDurationMeasures() + " times)", 10);
            outString = "        *******************************************************************\n        Begin of Tp2Case " + this.caseMonitor.getCaseTypeWithId() + " (for user " + this.getTp2Case().getUser().getName() + ")\n" + "        *******************************************************************\n" + "        User: " + this.getTp2Case().getUser().getName() + " (desc: " + this.getTp2Case().getUser().getDescription() + ")\n";
            if (Tp2Env.isMaxGlobalDurationSet()) {
                outString = outString + "        Max global duration is: " + Tp2Env.getMaxGlobalDurationFormatted() + "\n" + "        SingleTest will be interrupted around " + Tp2Env.getGlobalEndTimeFormatted() + "\n";
            }
            this.setCaseRunning();
            if (this.getCaseEnv().getBooleanProp("tp2.init")) {
                this.initTestDatabase();
            }
            TestCase.addGlobalMessage((String)"TP2", (char)'I', (String)outString);
            this.runCase();
            if (!this.getTp2Case().isFinished()) {
                this.setCaseFinished();
            }
            this.caseMonitor.closeCaseRessources();
        }
        catch (Tp2Exception e) {
            e.printStackTrace(System.err);
            if (e.getAbortType() == 4) {
                this.caseMonitor.abortCase("Aborting global session because of Tp2Exception :" + e, e);
                TestCase.addGlobalMessage((String)"TP2", (char)'E', (String)("Aborting global session because of Tp2Exception :" + e));
                throw new RuntimeException("Aborting global session because of " + e);
            }
            TestCase.addGlobalMessage((String)"TP2", (char)'E', (String)("Aborting session " + this.caseMonitor.getCaseTypeWithId() + " because of Tp2Exception :" + e));
            this.caseMonitor.abortCase("Aborting session " + this.caseMonitor.getCaseTypeWithId() + " because of Tp2Exception :" + e, e);
        }
    }

    private final void initTestDatabase() throws Tp2Exception {
        String outString = "";
        long begin = System.currentTimeMillis();
        Tp2Env.testIfShouldAbort(Tp2Env.getLocalUsualInitDuration() * 1000L);
        TestDbInit tp2Init = this.caseMonitor.getBenchmark().getTestDbInit();
        this.caseMonitor.getCaseLog().openComponent("TestDbInit", null);
        try {
            tp2Init.initCaseRun();
        }
        catch (Tp2Exception e) {
            this.stdOut("### TestDbInit FAILED !!! - " + this.caseMonitor.getCaseTypeWithId() + " ###\n");
            outString = "        ### TestDbInit FAILED !!! - " + this.caseMonitor.getCaseTypeWithId() + " ###\n";
            TestCase.addGlobalMessage((String)"TP2", (char)'E', (String)outString);
            this.caseMonitor.getCaseLog().closeComponent();
            throw e;
        }
        this.caseMonitor.getCaseLog().closeComponent();
        Tp2Env.updateLocalUsualInitDuration(System.currentTimeMillis() - begin);
    }

    private void setCaseFinished() throws Tp2Exception {
        try {
            this.getTp2Case().finish();
        }
        catch (SQLException e) {
            throw new Tp2Exception("Set case FINISHED failed because of " + e, 3);
        }
    }

    private void setCaseRunning() throws Tp2Exception {
        try {
            this.getTp2Case().startRunning();
        }
        catch (SQLException e) {
            throw new Tp2Exception("Set case RUNNING failed because of " + e, 3);
        }
    }

    protected final Tp2Result runTest(int userCount, int duration) throws Tp2Exception, BadResultException {
        Tp2Env.testIfShouldAbort(((long)duration + Tp2Env.getLocalUsualRunUtilitiesDuration()) * 1000L);
        SingleTest tp2Test = null;
        if (this.getTp2Case().isFinished()) {
            throw new Tp2Exception("Case " + this.caseMonitor.getCaseTypeWithId() + " is finished: cannot run more tests with it", 3);
        }
        try {
            tp2Test = new SingleTest(userCount, duration, this.caseMonitor, this);
            Tp2Result result = null;
            long begin = System.currentTimeMillis();
            this.caseMonitor.getCaseLog().openSingleTestComponent(tp2Test);
            result = tp2Test.runTest();
            this.caseMonitor.getCaseLog().logResult(result, this.caseMonitor.getBooleanProp("tp2.results.logResults"));
            this.caseMonitor.getCaseLog().closeComponent();
            this.incrementTestsDone(tp2Test.getSingleTestId());
            Tp2Env.updateLocalUsualRunUtilitiesDuration(System.currentTimeMillis() - begin - (long)(duration * 1000));
            if (StorableObject.isNonPersistent()) {
                this.stdOut("Writing non persistent report ...", 20);
                new NonPersistentReport().writeReport();
            }
            return result;
        }
        catch (BadResultException e) {
            this.closeFailedTest("SingleTest gaves no result because of BadResultException", tp2Test.getSingleTestId(), e);
            throw e;
        }
        catch (Tp2Exception e) {
            if (e.getAbortType() == 2) {
                this.closeFailedTest("ABORT_TEST SingleTest was aborted because of an unexpected exception : " + e, tp2Test.getSingleTestId(), e);
                throw new BadResultException("Bad result because of TEST_ABORT : " + e, e, tp2Test.getSingleTestId());
            }
            this.closeFailedTest("SingleTest was aborted because of an unexpected exception : " + e, tp2Test.getSingleTestId(), e);
            throw e;
        }
    }

    protected final Tp2Result runTest(int userCount) throws Tp2Exception, BadResultException {
        return this.runTest(userCount, this.defaultDuration);
    }

    protected final Tp2Result runTest(int userCount, int duration, int scaleFactor) throws Tp2Exception, BadResultException {
        Tp2Env.testIfShouldAbort(((long)duration + Tp2Env.getLocalUsualRunUtilitiesDuration()) * 1000L);
        SingleTest tp2Test = null;
        if (this.getTp2Case().isFinished()) {
            throw new Tp2Exception("Case " + this.caseMonitor.getCaseTypeWithId() + " is finished: cannot run more tests with it", 3);
        }
        try {
            tp2Test = new SingleTest(userCount, duration, this.caseMonitor, this);
            Tp2Result result = null;
            long begin = System.currentTimeMillis();
            this.caseMonitor.getCaseLog().openSingleTestComponent(tp2Test);
            result = tp2Test.runTest(scaleFactor);
            this.caseMonitor.getCaseLog().logResult(result, this.caseMonitor.getBooleanProp("tp2.results.logResults"));
            this.caseMonitor.getCaseLog().closeComponent();
            this.incrementTestsDone(tp2Test.getSingleTestId());
            Tp2Env.updateLocalUsualRunUtilitiesDuration(System.currentTimeMillis() - begin - (long)(duration * 1000));
            if (StorableObject.isNonPersistent()) {
                this.stdOut("Writing non persistent report ...", 20);
                new NonPersistentReport().writeReport();
            }
            return result;
        }
        catch (BadResultException e) {
            this.closeFailedTest("SingleTest gaves no result because of BadResultException", tp2Test.getSingleTestId(), e);
            throw e;
        }
        catch (Tp2Exception e) {
            if (e.getAbortType() == 2) {
                this.closeFailedTest("ABORT_TEST SingleTest was aborted because of an unexpected exception : " + e, tp2Test.getSingleTestId(), e);
                throw new BadResultException("Bad result because of TEST_ABORT : " + e, e, tp2Test.getSingleTestId());
            }
            this.closeFailedTest("SingleTest was aborted because of an unexpected exception : " + e, tp2Test.getSingleTestId(), e);
            throw e;
        }
    }

    protected final boolean runTestSafe(int userCount, int duration) throws Tp2Exception {
        try {
            int scaleFactor = Integer.parseInt(this.getCaseEnv().getProp("tp2.ext.scaleFactor"));
            if (scaleFactor >= 0) {
                this.runTest(userCount, duration, scaleFactor);
                return true;
            }
            if (scaleFactor == -1) {
                this.runTest(userCount, duration);
                return true;
            }
            return false;
        }
        catch (BadResultException e1) {
            if (this.getCaseEnv().getBooleanProp("tp2.test.retry")) {
                SingleTestId stId = e1.getSingleTestId();
                if (stId != null) {
                    this.stdOut("Trying again test for " + stId, 10);
                    if (this.getTestsFailedFor(stId) <= this.getTryCount()) {
                        try {
                            if (this.scaleFactor >= 0) {
                                this.runTest(userCount, duration, this.scaleFactor);
                                return true;
                            }
                            if (this.scaleFactor == -1) {
                                this.runTest(userCount, duration);
                                return true;
                            }
                            return false;
                        }
                        catch (BadResultException e2) {
                            return false;
                        }
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
    }

    protected final boolean runTestSafe(int userCount) throws Tp2Exception {
        return this.runTestSafe(userCount, this.defaultDuration);
    }

    public static long getTimeout() {
        return 0L;
    }

    private void closeFailedTest(String messageToLog, SingleTestId stId, Exception e) throws Tp2Exception {
        try {
            SingleTest.abort();
        }
        catch (Tp2Exception abortEx) {
            abortEx.printStackTrace();
        }
        if (stId != null) {
            this.stdErr("### Test[" + stId.getUserCount() + " users] FAILED !!! - " + messageToLog + " - " + this.caseMonitor.getCaseTypeWithId() + " ###\n");
            this.incrementTestsFailed(stId);
        } else {
            this.stdErr("### Test[- users] FAILED !!! - " + messageToLog + " - " + this.caseMonitor.getCaseTypeWithId() + " ###\n");
        }
        if (e != null && BenchEnv.getOutputLevel() >= 10) {
            e.printStackTrace();
        }
        this.caseMonitor.logError("Tp2TestCase.closeFailedTest", messageToLog, e);
        this.caseMonitor.getCaseLog().closeComponent();
    }

    public void justBeforeTestDBOnline() throws Tp2Exception {
    }

    public void justBeforeUsersStart(Connection preTestDBConnection) throws Tp2Exception {
    }

    public void justAfterUsersStopped(Connection postTestDBConnection) throws Tp2Exception {
    }

    protected final void changeCurrentAccessType(String accessTypeCodeStr) throws Tp2Exception {
        this.changeCurrentAccessType(new AccessType(accessTypeCodeStr));
    }

    protected final void changeCurrentAccessType(AccessType accessType) throws Tp2Exception {
        this.caseMonitor.changeCurrentAccessType(accessType);
    }

    protected final int[] createUserCountProgramFromProperties() throws PropertyException {
        int[] defUcProg = new int[]{4, 12, 36, 72, 108, 180};
        return this.createUserCountProgramFromProperties(defUcProg);
    }

    protected final int[] createUserCountProgramFromProperties(int[] defaultUcProg) throws PropertyException {
        String outString = "";
        int[] userCountProgram = defaultUcProg;
        if (this.getCaseEnv().isPropSet("tp2.ext.userCountProgram")) {
            userCountProgram = this.createUserCountProgram(this.getCaseEnv().getProp("tp2.ext.userCountProgram"));
        } else if (this.getCaseEnv().isPropSet("tp2.ext.minUserCount") || this.getCaseEnv().isPropSet("tp2.ext.maxUserCount") || this.getCaseEnv().isPropSet("tp2.ext.step")) {
            int minUserCount = 10;
            int maxUserCount = 100;
            int step = 10;
            if (this.getCaseEnv().isPropSet("tp2.ext.minUserCount")) {
                minUserCount = Integer.parseInt(this.getCaseEnv().getProp("tp2.ext.minUserCount"));
                outString = "        tp2.ext.minUserCount: " + this.getCaseEnv().getProp("tp2.ext.minUserCount") + "\n";
            }
            if (this.getCaseEnv().isPropSet("tp2.ext.maxUserCount")) {
                maxUserCount = Integer.parseInt(this.getCaseEnv().getProp("tp2.ext.maxUserCount"));
                outString = outString + "        tp2.ext.maxUserCount: " + this.getCaseEnv().getProp("tp2.ext.maxUserCount") + "\n";
            }
            if (this.getCaseEnv().isPropSet("tp2.ext.step")) {
                step = Integer.parseInt(this.getCaseEnv().getProp("tp2.ext.step"));
                outString = outString + "        tp2.ext.step: " + this.getCaseEnv().getProp("tp2.ext.step") + "\n";
            }
            userCountProgram = this.createUserCountProgram(minUserCount, maxUserCount, step);
        }
        TestCase.addGlobalMessage((String)"TP2", (char)'I', (String)outString);
        return userCountProgram;
    }

    private int[] createUserCountProgram(String userCountProgramStr) {
        Vector<Integer> buf = new Vector<Integer>();
        StringTokenizer ST = new StringTokenizer(userCountProgramStr, ",");
        while (ST.hasMoreTokens()) {
            buf.add(new Integer(ST.nextToken()));
        }
        int[] userCountProgram = new int[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            userCountProgram[i] = (Integer)buf.get(i);
        }
        return userCountProgram;
    }

    private int[] createUserCountProgram(int minUserCount, int maxUserCount, int step) {
        int[] userCountProgram = new int[(maxUserCount - minUserCount) / step + 1];
        int i = 0;
        for (int userCount = minUserCount; userCount <= maxUserCount; userCount += step) {
            userCountProgram[i] = userCount;
            ++i;
        }
        return userCountProgram;
    }

    protected final void stdOut(Object obj) {
        BenchEnv.stdOut(this.getTp2Case().getCaseType(), obj);
    }

    protected final void stdErr(Object obj) {
        BenchEnv.stdErr(this.getTp2Case().getCaseType(), obj);
    }

    protected final void stdOut(Object obj, int debug) {
        BenchEnv.stdOut(this.getTp2Case().getCaseType(), obj, debug);
    }

    protected final String getTp2Home() {
        return Tp2Env.getTp2Home();
    }

    protected final CaseEnv getCaseEnv() {
        return this.caseMonitor;
    }

    protected final int getTryCount() {
        return this.tryCount;
    }

    protected final int getScaleFactor() {
        return this.scaleFactor;
    }

    public String getTestDBHostName() {
        return mTestDriverOptions.getProperty("DBHost");
    }

    protected final Tp2Case getTp2Case() {
        return this.caseMonitor.getTp2Case();
    }

    public String getLogFile() {
        try {
            return this.caseMonitor.getCaseLog().getCaseLogFile().getPath();
        }
        catch (Tp2Exception e) {
            return null;
        }
    }

    private void incrementTestsDone(SingleTestId stId) {
        this.incrementTestsMap(this.testsDone, stId);
        BenchEnv.stdOut("TRYCOUNT", "Incremented testsDone", 20);
        this.printTestsMaps();
    }

    private void incrementTestsFailed(SingleTestId stId) {
        this.incrementTestsMap(this.testsFailed, stId);
        BenchEnv.stdOut("TRYCOUNT", "Incremented testsFailed", 10);
        this.printTestsMaps();
    }

    private void incrementTestsMap(Map map, SingleTestId stId) {
        if (map.containsKey(stId)) {
            map.put(stId, new Integer((Integer)map.get(stId) + 1));
        } else {
            map.put(stId, new Integer(1));
        }
    }

    private void printTestsMaps() {
        Map.Entry entry;
        BenchEnv.stdOut("TRYCOUNT", "List testsDone :", 20);
        Iterator it = this.testsDone.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            BenchEnv.stdOut("TRYCOUNT", entry.getValue() + "\t" + entry.getKey(), 20);
        }
        BenchEnv.stdOut("TRYCOUNT", "List testsFailed :", 20);
        it = this.testsFailed.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            BenchEnv.stdOut("TRYCOUNT", entry.getValue() + "\t" + entry.getKey(), 20);
        }
    }

    private int getTestsDoneFor(SingleTestId stId) {
        if (this.testsDone.containsKey(stId)) {
            return (Integer)this.testsDone.get(stId);
        }
        return 0;
    }

    private int getTestsFailedFor(SingleTestId stId) {
        if (this.testsFailed.containsKey(stId)) {
            return (Integer)this.testsFailed.get(stId);
        }
        return 0;
    }
}

