/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.CompInt;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.MutableDBDescProperties;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.common.Tp2Result;
import com.sap.sapdb.benchmark.tp2.test.BadResultException;
import com.sap.sapdb.benchmark.tp2.test.CaseEnv;
import com.sap.sapdb.benchmark.tp2.test.SimulatedUser;
import com.sap.sapdb.benchmark.tp2.test.SingleTestId;
import com.sap.sapdb.benchmark.tp2.test.SystemUser;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.benchmark.tp2.test.Tp2ProcessFactory;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class TestMonitor
implements TestEnv {
    private int testState = 0;
    private SortedMap users = null;
    private int userCount;
    private int testDuration;
    private AccessType accessType;
    private DBDescription dbDesc = null;
    private CaseEnv caseEnv = null;
    private MutableDBDescProperties dbDescProp = null;
    private Connection preStoreConnection = null;

    public TestMonitor(int userCount, int testDuration, CaseEnv caseEnv) {
        this.userCount = userCount;
        this.testDuration = testDuration;
        this.caseEnv = caseEnv;
        this.accessType = caseEnv.getCurrentAccessType();
        this.users = new TreeMap();
        this.dbDescProp = new MutableDBDescProperties(MutableDBDescProperties.getCommonMutableDBDescProperties());
    }

    public void initTestRun() throws Tp2Exception {
        if (this.getAccessType().isSystemUser()) {
            SystemUser.initTestRun(this);
        }
        for (int i = 0; i < this.userCount; ++i) {
            this.users.put(new CompInt(i), this.newUser(i));
        }
        this.testState = 1;
    }

    public void launchAllUsers() throws Tp2Exception {
        int cnt;
        SimulatedUser.setWaitingForBegin(true);
        if (this.usersNotNull()) {
            Iterator usersIt = this.getUsers().iterator();
            cnt = 0;
            while (usersIt.hasNext()) {
                SimulatedUser user = (SimulatedUser)usersIt.next();
                user.runUser();
                ++cnt;
            }
        } else {
            throw new Tp2Exception("Users container is null in test monitor", 2);
        }
        this.getCaseEnv().logInfo("TestMonitor.launchAllUsers()", "No of users to launch: " + cnt);
        this.testState = 2;
        if (this.getAccessType().isSystemUser()) {
            SystemUser.deleteLockFromTable(this.getUserCount(), this);
        }
        SimulatedUser.setWaitingForBegin(false);
        this.testState = 3;
    }

    public void launchAllUsers(int scaleFactor) throws Tp2Exception {
        SimulatedUser.setWaitingForBegin(true);
        if (this.usersNotNull()) {
            Iterator usersIt = this.getUsers().iterator();
            int userPerSchema = this.getUsers().size() / scaleFactor;
            for (int i = 0; i < userPerSchema; ++i) {
                for (int j = 0; j < scaleFactor; ++j) {
                    SimulatedUser user = (SimulatedUser)usersIt.next();
                    user.runUser(j);
                }
            }
        } else {
            throw new Tp2Exception("Users container is null in test monitor", 2);
        }
        this.testState = 2;
        if (this.getAccessType().isSystemUser()) {
            SystemUser.deleteLockFromTable(this.getUserCount(), this);
        }
        SimulatedUser.setWaitingForBegin(false);
        this.testState = 3;
    }

    public void closeTestRun() throws Tp2Exception {
        if (this.users != null) {
            Iterator usersIt = this.users.values().iterator();
            while (usersIt.hasNext()) {
                SimulatedUser user = (SimulatedUser)usersIt.next();
                try {
                    user.getExitValue();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            this.users.clear();
            this.users = null;
        }
        try {
            if (this.preStoreConnection != null && !this.preStoreConnection.isClosed()) {
                this.preStoreConnection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this.getAccessType().isSystemUser() && this.caseEnv.isUsingTp2Processes()) {
            Tp2ProcessFactory.closeCurrent();
        }
    }

    public void abortAllUsers() throws Tp2Exception {
        try {
            if (this.getAccessType().isSystemUser() && this.caseEnv.isUsingTp2Processes()) {
                Tp2ProcessFactory.abortCurrent();
            } else if (this.usersNotNull()) {
                Iterator users = this.getUsers().iterator();
                while (users.hasNext()) {
                    SimulatedUser user = (SimulatedUser)users.next();
                    user.abort();
                }
            }
            this.testState = 5;
        }
        catch (Tp2Exception e) {
            this.testState = 5;
            throw e;
        }
    }

    public String stateReport() throws Tp2Exception {
        StringBuffer result = new StringBuffer("");
        TreeMap<String, Integer> userStates = new TreeMap<String, Integer>();
        if (this.usersNotNull()) {
            Iterator it = this.getUsers().iterator();
            while (it.hasNext()) {
                int state;
                String stateStr;
                SimulatedUser user = (SimulatedUser)it.next();
                String rcStr = "";
                if (user.isFinished()) {
                    try {
                        int exitCode = user.getExitValue();
                        rcStr = " (rc=" + exitCode + ")";
                    }
                    catch (IllegalThreadStateException e) {
                        throw new Tp2Exception("User " + user.getId() + " is not finished but isFinished() told it was", 2, e);
                    }
                }
                if (userStates.containsKey(stateStr = SimulatedUser.convertState(state = user.getCurrentState()) + rcStr)) {
                    Integer usCount = (Integer)userStates.get(stateStr);
                    usCount = new Integer(usCount + 1);
                    userStates.put(stateStr, usCount);
                    continue;
                }
                userStates.put(stateStr, new Integer(1));
            }
            Iterator stateVals = userStates.keySet().iterator();
            while (stateVals.hasNext()) {
                String stateStr = (String)stateVals.next();
                result.append("\t" + stateStr + "\t: " + userStates.get(stateStr) + " users \n");
            }
        } else {
            result.append("Users are null !");
        }
        return result.toString();
    }

    public boolean areAllFinished() throws Tp2Exception {
        boolean allFinished = true;
        boolean allOk = true;
        if (this.usersNotNull()) {
            Iterator users = this.getUsers().iterator();
            while (users.hasNext()) {
                SimulatedUser user = (SimulatedUser)users.next();
                if (!user.isFinished()) {
                    allFinished = false;
                    break;
                }
                if (user.getCurrentState() != 5) continue;
                allOk = false;
            }
        } else {
            boolean bl = allOk = this.testState == 4;
        }
        if (allFinished) {
            this.testState = allOk ? 4 : 5;
        }
        return allFinished;
    }

    public boolean areSomeFinished() throws Tp2Exception {
        if (this.usersNotNull()) {
            boolean result = false;
            Iterator users = this.getUsers().iterator();
            while (users.hasNext()) {
                SimulatedUser user = (SimulatedUser)users.next();
                if (!user.isFinished()) continue;
                result = true;
                break;
            }
            return result;
        }
        return true;
    }

    public String badFinishedReport() throws Tp2Exception {
        StringBuffer reportBuf = new StringBuffer();
        int badCount = 0;
        if (this.usersNotNull()) {
            Iterator users = this.getUsers().iterator();
            while (users.hasNext()) {
                SimulatedUser user = (SimulatedUser)users.next();
                int state = user.getCurrentState();
                if (state == 4) continue;
                ++badCount;
                String exitValue = null;
                try {
                    exitValue = Integer.toString(user.getExitValue());
                }
                catch (IllegalThreadStateException e) {
                    exitValue = "[NO EXIT CODE]";
                }
                reportBuf.append("<User id=\"" + user.getId() + "\" state=\"" + SimulatedUser.convertState(state) + "\" exitValue=\"" + exitValue + "\"/>\n");
            }
        }
        StringBuffer result = new StringBuffer("<BadFinishedUsers count=\"" + badCount + "\">\n");
        result.append(reportBuf.toString());
        result.append("</BadFinishedUsers>\n");
        return result.toString();
    }

    private Collection getUsers() throws Tp2Exception {
        if (this.users == null) {
            throw new Tp2Exception("SimulatedUser container 'users' is null in TestMonitor", 2);
        }
        return this.users.values();
    }

    private boolean usersNotNull() {
        return this.users != null;
    }

    private SimulatedUser newUser(int id) throws Tp2Exception {
        return this.caseEnv.getBenchmark().newUser(id, this);
    }

    public int getTestState() {
        return this.testState;
    }

    public void initDBDescription(Connection testDBConn) throws Tp2Exception {
        try {
            Tp2Env.stdOut("Getting DBDescription ...", 20);
            this.dbDesc = DBDescription.getDBDescription(testDBConn, this.caseEnv.getTestDB().getKernelBuild(), this.caseEnv.getTestDB().getKernelVersion(), this.dbDescProp);
        }
        catch (SQLException e) {
            throw new Tp2Exception("SQL Problem with the DBDescription determination", 2, e);
        }
        catch (TestDatabaseException e) {
            throw new Tp2Exception("Problem with the TestDatabase", 2, (Exception)((Object)e));
        }
    }

    public void setBooleanDBDescProperty(String name, boolean value) throws Tp2Exception {
        try {
            this.dbDescProp.setBooleanProperty(name, value);
        }
        catch (SQLException e) {
            throw new Tp2Exception("Problem when setting the BooleanDBDescProperty " + name + " (for value " + value + ")", 2, e);
        }
    }

    public Tp2Result retrieveAndStoreTestResult(long ioReads, long ioWrites, Connection testDBConn) throws Tp2Exception, BadResultException {
        int errors;
        int tCount;
        float tpsPuDev;
        float tpsPuAvg;
        float tps;
        int storedDuration;
        int storedUserCount;
        Tp2Result result = null;
        try {
            Statement selectTestResult = testDBConn.createStatement();
            ResultSet localRS = selectTestResult.executeQuery("SELECT SUM(tcountpu)/MAX(duration) AS tps,AVG(tpspu) AS tpspu_avg,STDDEV(tpspu) AS tpspu_dev,SUM(tcountpu) AS tcount,MAX(duration) AS duration,COUNT(DISTINCT process) AS usercount,SUM(errors) AS errors FROM results ");
            if (!localRS.next()) {
                localRS.close();
                selectTestResult.close();
                throw new Tp2Exception("There was no results in test database", 2);
            }
            this.validityCheck(localRS);
            storedUserCount = localRS.getInt("usercount");
            storedDuration = localRS.getInt("duration");
            tps = localRS.getFloat("tps");
            tpsPuAvg = localRS.getFloat("tpspu_avg");
            tpsPuDev = tpsPuAvg != 0.0f ? 100.0f * localRS.getFloat("tpspu_dev") / tpsPuAvg : 0.0f;
            tCount = localRS.getInt("tcount");
            errors = localRS.getInt("errors");
            localRS.close();
            selectTestResult.close();
            testDBConn.commit();
            if (this.caseEnv.getProp("tp2.outputLevel").equalsIgnoreCase("DEBUG")) {
                StringBuffer lOutString = new StringBuffer();
                lOutString.append("\n\n");
                lOutString.append("\t--------------------------------------------------------------- \n");
                lOutString.append("\tContent of table MONITOR after users are finished: \n");
                lOutString.append("\t--------------------------------------------------------------- \n");
                lOutString.append("\tTYPE        DESCRIPTION                                 VALUE  \n");
                lOutString.append("\t--------------------------------------------------------------- \n");
                Statement selectData = testDBConn.createStatement();
                ResultSet RS = selectData.executeQuery("SELECT * FROM monitor");
                while (RS.next()) {
                    StringBuffer stringBuffer = new StringBuffer().append("\t").append(this.paddTo(RS.getString("TYPE"), 11)).append("   ").append(this.paddTo(RS.getString("DESCRIPTION"), 39));
                    this.toString();
                    lOutString.append(stringBuffer.append(this.paddToRightJustified(String.valueOf(RS.getLong("VALUE")), 10)).append("\n").toString());
                }
                this.getCaseEnv().logInfo("TestMonitor.retrieveAndStoreTestResult()", lOutString.toString());
                System.out.println("outMonitorString : \n" + lOutString.toString());
                lOutString = new StringBuffer();
                lOutString.append("\n\n");
                lOutString.append("\t----------------------------------------------------------------------------------------- \n");
                lOutString.append("\tResults from 'diagnose analyze on: \n");
                lOutString.append("\t----------------------------------------------------------------------------------------- \n");
                lOutString.append("\tCOMMAND                          VWAITS  RUNTIME ROWS_READ ROWS_QUAL VSUSPENDS CALL_COUNT PHYS_IO \n");
                lOutString.append("\t----------------------------------------------------------------------------------------- \n");
                RS = selectData.executeQuery("select max( substr(c.sql_statement,1,60) ) command, sum(d.vwaits ) vwaits, sum(runtime) runtime, sum(rows_read) rows_read, sum(rows_qual) rows_qual, sum(vsuspends) vsuspends, sum(call_count) call_count, sum(physical_io) physical_io from syscmd_analyze c, sysdata_analyze d  where  c.cmdid = d.cmdid group by c.cmdid");
                while (RS.next()) {
                    String command = RS.getString("command");
                    command.trim();
                    if (command.length() < 30) {
                        String newcommand;
                        command = newcommand = this.addSpace(command, 30 - command.length());
                    }
                    StringBuffer stringBuffer = new StringBuffer().append(this.paddTo(command, 30));
                    this.toString();
                    StringBuffer stringBuffer2 = stringBuffer.append(this.paddToRightJustified(String.valueOf(RS.getInt("vwaits")), 9));
                    this.toString();
                    StringBuffer stringBuffer3 = stringBuffer2.append(this.paddToRightJustified(String.valueOf(RS.getFloat("runtime")), 12));
                    this.toString();
                    StringBuffer stringBuffer4 = stringBuffer3.append(this.paddToRightJustified(String.valueOf(RS.getInt("rows_read")), 10));
                    this.toString();
                    StringBuffer stringBuffer5 = stringBuffer4.append(this.paddToRightJustified(String.valueOf(RS.getInt("rows_qual")), 10));
                    this.toString();
                    StringBuffer stringBuffer6 = stringBuffer5.append(this.paddToRightJustified(String.valueOf(RS.getInt("vsuspends")), 10));
                    this.toString();
                    StringBuffer stringBuffer7 = stringBuffer6.append(this.paddToRightJustified(String.valueOf(RS.getInt("call_count")), 11));
                    this.toString();
                    String out = stringBuffer7.append(this.paddToRightJustified(String.valueOf(RS.getInt("physical_io")), 8)).append("\n").toString();
                    out = out.replaceAll("\t", "");
                    lOutString.append("\t" + out);
                }
                this.getCaseEnv().logInfo("TestMonitor.retrieveAndStoreTestResult()", lOutString.toString());
                System.out.println("\n" + lOutString.toString());
                if (!TestDriver.compareRelease((String)this.dbDesc.getVersion(), (String)"<=", (String)"7.5.0")) {
                    lOutString = new StringBuffer();
                    lOutString.append("\n\n");
                    lOutString.append("\t---------------------------------------------------------------------------------- \n");
                    lOutString.append("\tContent of table LOGQUEUESTATISTICS after users are finished: \n");
                    lOutString.append("\t---------------------------------------------------------------------------------- \n");
                    lOutString.append("\tQUEUEID  QUEUE-   QUEUE-     QUEUEOVER-  GROUP-     WAITCNT  MAXWAIT-    PHYSICAL- \n");
                    lOutString.append("\t         MAXUSED  INSERTCNT  FLOWCNT     COMMITCNT           CNTPERPAGE  WRITECNT \n");
                    lOutString.append("\t---------------------------------------------------------------------------------- \n");
                    RS = selectData.executeQuery("SELECT * FROM logqueuestatistics");
                    while (RS.next()) {
                        StringBuffer stringBuffer = new StringBuffer().append("\t");
                        this.toString();
                        StringBuffer stringBuffer8 = stringBuffer.append(this.paddToRightJustified(String.valueOf(RS.getInt("QUEUEID")), 7));
                        this.toString();
                        StringBuffer stringBuffer9 = stringBuffer8.append(this.paddToRightJustified(String.valueOf(RS.getInt("QUEUEMAXUSED")), 7));
                        this.toString();
                        StringBuffer stringBuffer10 = stringBuffer9.append(this.paddToRightJustified(String.valueOf(RS.getInt("QUEUEINSERTCOUNT")), 12));
                        this.toString();
                        StringBuffer stringBuffer11 = stringBuffer10.append(this.paddToRightJustified(String.valueOf(RS.getInt("QUEUEOVERFLOWCOUNT")), 9));
                        this.toString();
                        StringBuffer stringBuffer12 = stringBuffer11.append(this.paddToRightJustified(String.valueOf(RS.getInt("GROUPCOMMITCOUNT")), 13));
                        this.toString();
                        StringBuffer stringBuffer13 = stringBuffer12.append(this.paddToRightJustified(String.valueOf(RS.getInt("WAITCOUNT")), 10));
                        this.toString();
                        StringBuffer stringBuffer14 = stringBuffer13.append(this.paddToRightJustified(String.valueOf(RS.getInt("MAXWAITCOUNTPERPAGE")), 12));
                        this.toString();
                        lOutString.append(stringBuffer14.append(this.paddToRightJustified(String.valueOf(RS.getInt("PHYSICALWRITECOUNT")), 10)).append("\n").toString());
                    }
                    this.getCaseEnv().logInfo("TestMonitor.retrieveAndStoreTestResult()", lOutString.toString());
                    System.out.println("\n" + lOutString.toString());
                    lOutString = new StringBuffer();
                    lOutString.append("\n\n");
                    lOutString.append("\t------------------------------------------------------------- \n");
                    lOutString.append("\tContent of table LOGQUEUESTATISTICS after users are finished: \n");
                    lOutString.append("\t------------------------------------------------------------- \n");
                    RS = selectData.executeQuery("SELECT * FROM logstatistics");
                    while (RS.next()) {
                        StringBuffer stringBuffer = new StringBuffer().append("\tUSABLESIZE");
                        this.toString();
                        StringBuffer stringBuffer15 = stringBuffer.append(this.paddToRightJustified(String.valueOf(RS.getInt("USABLESIZE")), 25)).append("\n").append("\t").append("USEDSIZE");
                        this.toString();
                        StringBuffer stringBuffer16 = stringBuffer15.append(this.paddToRightJustified(String.valueOf(RS.getInt("USEDSIZE")), 27)).append("\n").append("\t").append("USEDSIZE (%)");
                        this.toString();
                        StringBuffer stringBuffer17 = stringBuffer16.append(this.paddToRightJustified(String.valueOf(RS.getInt("USEDSIZEPERCENTAGE")), 23)).append("\n").append("\t").append("NOTSAVEDSIZE");
                        this.toString();
                        StringBuffer stringBuffer18 = stringBuffer17.append(this.paddToRightJustified(String.valueOf(RS.getInt("NOTSAVEDSIZE")), 23)).append("\n").append("\t").append("NOTSAVEDSIZE (%)");
                        this.toString();
                        StringBuffer stringBuffer19 = stringBuffer18.append(this.paddToRightJustified(String.valueOf(RS.getInt("NOTSAVEDPERCENTAGE")), 19)).append("\n").append("\t").append("SAVEPOINTCOUNT");
                        this.toString();
                        StringBuffer stringBuffer20 = stringBuffer19.append(this.paddToRightJustified(String.valueOf(RS.getInt("SAVEPOINTCOUNT")), 21)).append("\n").append("\t").append("TRANSACTIONCOUNT");
                        this.toString();
                        StringBuffer stringBuffer21 = stringBuffer20.append(this.paddToRightJustified(String.valueOf(RS.getInt("TRANSACTIONCOUNT")), 19)).append("\n").append("\t").append("WRITETRANSACTIONCOUNT");
                        this.toString();
                        StringBuffer stringBuffer22 = stringBuffer21.append(this.paddToRightJustified(String.valueOf(RS.getInt("WRITETRANSACTIONCOUNT")), 14)).append("\n").append("\t").append("MAXUSEDSESSIONID");
                        this.toString();
                        StringBuffer stringBuffer23 = stringBuffer22.append(this.paddToRightJustified(String.valueOf(RS.getInt("MAXUSEDSESSIONID")), 19)).append("\n").append("\t").append("MAXUSEDTRANSACTIONNUMBER");
                        this.toString();
                        StringBuffer stringBuffer24 = stringBuffer23.append(this.paddToRightJustified(String.valueOf(RS.getInt("MAXUSEDTRANSACTIONNUMBER")), 10)).append("\n").append("\t").append("QUEUECOUNT");
                        this.toString();
                        StringBuffer stringBuffer25 = stringBuffer24.append(this.paddToRightJustified(String.valueOf(RS.getInt("QUEUECOUNT")), 25)).append("\n").append("\t").append("QUEUESIZE");
                        this.toString();
                        lOutString.append(stringBuffer25.append(this.paddToRightJustified(String.valueOf(RS.getInt("QUEUESIZE")), 26)).append("\n").toString());
                    }
                    this.getCaseEnv().logInfo("TestMonitor.retrieveAndStoreTestResult()", lOutString.toString());
                    System.out.println("\n" + lOutString.toString());
                }
                StringBuffer outResultString = new StringBuffer();
                outResultString.append("\t--------------------------------------------------------------- \n");
                outResultString.append("\tContent of table RESULTS after users are finished: \n");
                outResultString.append("\t--------------------------------------------------------------- \n");
                outResultString.append("\tUSERID  DURATION  TCOUNTPU  ERRORS  TPSPU  \n");
                outResultString.append("\t--------------------------------------------------------------- \n");
                ResultSet resultRS = selectData.executeQuery("SELECT * FROM results");
                while (resultRS.next()) {
                    StringBuffer stringBuffer = new StringBuffer().append("\t");
                    this.toString();
                    StringBuffer stringBuffer26 = stringBuffer.append(this.paddToRightJustified(String.valueOf(resultRS.getInt("PROCESS")), 6));
                    this.toString();
                    StringBuffer stringBuffer27 = stringBuffer26.append(this.paddToRightJustified(String.valueOf(resultRS.getInt("DURATION")), 10));
                    this.toString();
                    StringBuffer stringBuffer28 = stringBuffer27.append(this.paddToRightJustified(String.valueOf(resultRS.getInt("TCOUNTPU")), 10));
                    this.toString();
                    StringBuffer stringBuffer29 = stringBuffer28.append(this.paddToRightJustified(String.valueOf(resultRS.getInt("ERRORS")), 8));
                    this.toString();
                    outResultString.append(stringBuffer29.append(this.paddToRightJustified(String.valueOf(resultRS.getInt("TPSPU")), 7)).append("\n").toString());
                }
                this.getCaseEnv().logInfo("TestMonitor.retrieveAndStoreTestResult()", outResultString.toString());
                System.out.println("\n" + outResultString.toString());
                testDBConn.commit();
            }
        }
        catch (SQLException e) {
            throw new Tp2Exception("SQL Problem when retrieving the result from the test database", 2, e);
        }
        try {
            String userType = this.accessType.getCodeStr();
            ServerNode serverNode = this.caseEnv.getServerNode();
            result = Tp2Result.createTp2Result(serverNode, this.dbDesc, storedUserCount, storedDuration, userType, tps, tpsPuAvg, tpsPuDev, tCount, errors, ioReads, ioWrites, this.caseEnv.getSessionId());
        }
        catch (SQLException e) {
            throw new Tp2Exception("SQL Problem when creating the result", 2, e);
        }
        try {
            Tp2Env.stdOut("Storing xConsShowAll ...", 20);
            if (!StorableObject.isNonPersistent()) {
                File xConsAllTemp = new File(Tp2Env.getTp2Home() + "lastXConsShowAll.zip");
                ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(xConsAllTemp));
                zipOut.putNextEntry(new ZipEntry("xConsShowAll"));
                int xConsAllLength = this.xConsShowAllInStream(zipOut, false);
                zipOut.closeEntry();
                zipOut.close();
                PreparedStatement insertShowAll = StorableObject.getConnection().prepareStatement("INSERT INTO tp2_xcons_all SET def_id=?, xcons_all=?");
                insertShowAll.setInt(1, result.getId());
                FileInputStream in = new FileInputStream(xConsAllTemp);
                insertShowAll.setBinaryStream(2, (InputStream)in, xConsAllLength);
                insertShowAll.execute();
                insertShowAll.close();
                in.close();
                StorableObject.getConnection().commit();
            } else {
                String xConsShowAllDir = NonPersistent.getResultsDir() + "xConsShowAll" + File.separator;
                new File(xConsShowAllDir).mkdirs();
                FileOutputStream out = new FileOutputStream(xConsShowAllDir + "xConsShowAll_" + result.getId() + ".html");
                out.write(("<HTML><HEADER><TITLE>x_cons show all #" + result.getId() + "</TITLE></HEADER><BODY><PRE>\n").getBytes());
                this.xConsShowAllInStream(out, false);
                out.write("</PRE></BODY></HTML>".getBytes());
                out.close();
            }
        }
        catch (Exception e) {
            this.caseEnv.logError("TestMonitor.retrieveAndStoreTestResult", "Problem with x_cons show all, could not save it", e);
        }
        return result;
    }

    private void validityCheck(ResultSet localRS) throws SQLException, Tp2Exception, BadResultException {
        boolean ok = true;
        String message = "";
        if (localRS.getInt("usercount") != this.getUserCount()) {
            message = message + "UserCount stored in testDB is " + localRS.getInt("usercount") + ", but wished userCount was " + this.getUserCount() + "\n";
            ok = false;
        }
        if (localRS.getFloat("tps") == 0.0f) {
            message = message + "No transaction count was stored in test database: TPS=0.0\n";
            ok = false;
        }
        if (!ok) {
            throw new BadResultException(message, this.getSingleTestId());
        }
    }

    private int xConsShowAllInStream(OutputStream out, boolean dbCons) throws Tp2Exception {
        try {
            int charCount = 0;
            BufferedReader in = null;
            in = dbCons ? new BufferedReader(new StringReader(this.caseEnv.getTestDB().executeDBMcmd("db_cons show all"))) : new BufferedReader(new StringReader(this.caseEnv.getTestDB().executeDBMcmd("show all")));
            String line = null;
            boolean goOn = false;
            int count = 0;
            do {
                goOn = false;
                line = null;
                while ((line = in.readLine()) != null) {
                    if (line.indexOf("CONTINUE") != -1) {
                        goOn = true;
                    }
                    line = line + "\n";
                    out.write(line.getBytes());
                    charCount += line.length();
                }
                if (goOn) {
                    in.close();
                    in = new BufferedReader(new StringReader(this.caseEnv.getTestDB().executeDBMcmd("show_next")));
                }
                out.flush();
            } while (goOn && ++count < 1000);
            in.close();
            return charCount;
        }
        catch (IOException e) {
            throw new Tp2Exception("Problem when calling \"show all\"", 2, e);
        }
        catch (TestDatabaseException e) {
            throw new Tp2Exception("Problem when calling \"show all\"", 2, (Exception)((Object)e));
        }
    }

    private String paddToRightJustified(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return new String(ca) + str;
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    private String paddTo(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return str + new String(ca);
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    private String addSpace(String inString, int length) {
        String outString = inString;
        String addString = "";
        for (int i = 0; i < length; ++i) {
            addString = addString + " ";
        }
        return outString + addString;
    }

    public void preStoreResults(int userId, int duration, int transactionCount, int errorCount) throws Tp2Exception {
        try {
            float tpsPu = (float)transactionCount / (float)duration;
            if (this.preStoreConnection == null) {
                this.preStoreConnection = this.caseEnv.createTestDBConnection();
            }
            Statement preStoreStmt = this.preStoreConnection.createStatement();
            preStoreStmt.executeUpdate("INSERT INTO results VALUES(" + userId + "," + duration + "," + transactionCount + "," + errorCount + "," + Float.toString(tpsPu) + ")");
            preStoreStmt.close();
        }
        catch (SQLException e) {
            throw new Tp2Exception("Pre-storing of results failed for user " + userId, 2, e);
        }
    }

    public int getUserCount() {
        return this.userCount;
    }

    public int getTestDuration() {
        return this.testDuration;
    }

    public CaseEnv getCaseEnv() {
        return this.caseEnv;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public SingleTestId getSingleTestId() {
        if (this.dbDesc == null) {
            return null;
        }
        return new SingleTestId(this.userCount, this.dbDesc, this.accessType);
    }

    public void logUserOutput(String path) {
        try {
            FileOutputStream userOutput = new FileOutputStream(new File(path, "tp2useroutput.txt"));
            Iterator usersIt = this.getUsers().iterator();
            while (usersIt.hasNext()) {
                SimulatedUser user = (SimulatedUser)usersIt.next();
                user.logUserOutput(userOutput);
            }
        }
        catch (IOException ioEx) {
        }
        catch (Tp2Exception e) {
            e.printStackTrace();
        }
    }
}

