/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.CaseEnv;
import com.sap.sapdb.benchmark.tp2.test.JavaUser;
import com.sap.sapdb.benchmark.tp2.test.SimulatedUser;
import com.sap.sapdb.benchmark.tp2.test.SystemUser;
import com.sap.sapdb.benchmark.tp2.test.TestDbInit;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.benchmark.tp2.test.TpBenchmark;
import com.sap.sapdb.benchmark.tp2.util.SimpleXMLHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EasyTpBenchmark
extends TpBenchmark {
    private String name = null;
    private String initClassName = null;
    private TestDbInit testDbInit = null;
    private String cpcExecutableName = null;
    private String cpcExecutablePrefix = null;
    private String odbcExecutableName = null;
    private String sqldbcExecutableName = null;
    private String sqldbcExecutablePrefix = null;
    private String javaUserClassName = null;
    private Constructor javaUserConstructor = null;
    private Vector dbProcInitStmts = null;
    static /* synthetic */ Class class$com$sap$sapdb$benchmark$tp2$test$CaseEnv;
    static /* synthetic */ Class class$com$sap$sapdb$benchmark$tp2$test$EasyTpBenchmark;
    static /* synthetic */ Class class$com$sap$sapdb$benchmark$tp2$test$TestEnv;

    public EasyTpBenchmark(CaseEnv caseEnv, String confFile) throws Tp2Exception {
        super(caseEnv);
        try {
            InputStream in = ClassLoader.getSystemResourceAsStream(confFile);
            this.loadBenchmark(new InputSource(in));
            in.close();
        }
        catch (IOException e) {
            throw new Tp2Exception("Problem when loading benchmark config file " + confFile, 3, e);
        }
    }

    public EasyTpBenchmark(CaseEnv caseEnv, File confFile) throws Tp2Exception {
        super(caseEnv);
        try {
            FileInputStream in = new FileInputStream(confFile);
            this.loadBenchmark(new InputSource(in));
            ((InputStream)in).close();
        }
        catch (FileNotFoundException e) {
            throw new Tp2Exception("Config file " + confFile + " was not found", 3, e);
        }
        catch (IOException e) {
            throw new Tp2Exception("Problem when loading benchmark config file " + confFile, 3, e);
        }
    }

    private void loadBenchmark(InputSource source) throws Tp2Exception, IOException {
        try {
            this.dbProcInitStmts = new Vector();
            InitHandler handler = new InitHandler();
            handler.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new Tp2Exception("Problem when loading benchmark config file ", 3, e);
        }
        catch (SAXException e) {
            throw new Tp2Exception("Problem when loading benchmark config file ", 3, e);
        }
        this.initCaseRun();
    }

    private void initCaseRun() throws Tp2Exception {
        try {
            if (this.cpcExecutablePrefix != null) {
                this.cpcExecutableName = this.getCaseEnv().getBestCpcExecutable(this.cpcExecutablePrefix);
            }
            if (this.sqldbcExecutablePrefix != null) {
                this.sqldbcExecutableName = this.getCaseEnv().getBestSqldbcExecutable(this.sqldbcExecutablePrefix);
            }
            Class<?> initClass = Class.forName(this.initClassName);
            Class[] paramCl = new Class[]{class$com$sap$sapdb$benchmark$tp2$test$CaseEnv == null ? (class$com$sap$sapdb$benchmark$tp2$test$CaseEnv = EasyTpBenchmark.class$("com.sap.sapdb.benchmark.tp2.test.CaseEnv")) : class$com$sap$sapdb$benchmark$tp2$test$CaseEnv, class$com$sap$sapdb$benchmark$tp2$test$EasyTpBenchmark == null ? (class$com$sap$sapdb$benchmark$tp2$test$EasyTpBenchmark = EasyTpBenchmark.class$("com.sap.sapdb.benchmark.tp2.test.EasyTpBenchmark")) : class$com$sap$sapdb$benchmark$tp2$test$EasyTpBenchmark};
            Constructor<?> construct = initClass.getConstructor(paramCl);
            Object[] param = new Object[]{this.getCaseEnv(), this};
            this.testDbInit = (TestDbInit)construct.newInstance(param);
        }
        catch (ClassNotFoundException e) {
            throw new Tp2Exception("Loaded TestDbInit " + this.initClassName + " was not found", 3, e);
        }
        catch (NoSuchMethodException e) {
            throw new Tp2Exception(this.initClassName + " does not have a compatible constructor <init>(CaseEnv, EasyTpBenchmark)", 3, e);
        }
        catch (InstantiationException e) {
            throw new Tp2Exception("Could not instantiate " + this.initClassName, 3, e);
        }
        catch (IllegalAccessException e) {
            throw new Tp2Exception("Constructor of " + this.initClassName + " is not accessible", 3, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Tp2Exception) {
                throw (Tp2Exception)e.getTargetException();
            }
            throw new Tp2Exception("Constructor of " + this.initClassName + " threw an exception" + e.getTargetException(), 3, e);
        }
    }

    public void createDbProcedures(Connection testDBConnection) throws Tp2Exception {
        try {
            String dbRelease = testDBConnection.getMetaData().getDatabaseProductVersion().toUpperCase();
            int start = dbRelease.indexOf("KERNEL") + 6;
            int end = dbRelease.indexOf("BUILD") - 1;
            String dbKernelVersion = dbRelease.substring(start, end).trim();
            dbKernelVersion = this.convertToSimpleRel(dbKernelVersion);
            Statement stmt = testDBConnection.createStatement();
            for (int i = 0; i < this.dbProcInitStmts.size(); ++i) {
                String stmtStr = (String)this.dbProcInitStmts.get(i);
                if (stmtStr.indexOf("//") != -1) {
                    if (stmtStr.indexOf(dbKernelVersion) == -1) continue;
                    stmtStr = stmtStr.substring(stmtStr.lastIndexOf("//") + 2);
                }
                try {
                    stmt.executeUpdate(stmtStr);
                    testDBConnection.commit();
                    continue;
                }
                catch (SQLException e) {
                    Tp2Env.stdErr("Problem when creating DB Procedure :\n\t" + stmtStr + "\n\t" + e);
                    this.getCaseEnv().logError("EasyTpBenchmark.createDbProcedures", "Problem when creating DB Procedure :\n" + stmtStr, e);
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            throw new Tp2Exception("SQL Problem when creating the DB procedures", 3, e);
        }
    }

    public String convertToSimpleRel(String inRelease) {
        String outRelease = "";
        StringTokenizer help = new StringTokenizer(inRelease, ".");
        while (help.hasMoreTokens()) {
            String help2 = help.nextToken();
            if (help2.length() > 1 && help2.startsWith("0")) {
                help2 = help2.substring(1);
            }
            outRelease = outRelease + help2 + ".";
        }
        outRelease = outRelease.substring(0, outRelease.length() - 1);
        return outRelease;
    }

    public String getName() {
        return this.name;
    }

    public TestDbInit getTestDbInit() throws Tp2Exception {
        return this.testDbInit;
    }

    public String getExecutableName(AccessType accessType) throws Tp2Exception {
        if (accessType.getInterface() == 0 || accessType.getInterface() == 256) {
            if (this.cpcExecutableName != null) {
                return this.cpcExecutableName;
            }
            throw new Tp2Exception("No CPC executable was defined for this TPBenchmark", 3);
        }
        if (accessType.getInterface() == 1024) {
            if (this.odbcExecutableName != null) {
                return this.odbcExecutableName;
            }
            throw new Tp2Exception("No ODBC executable was defined for this TPBenchmark", 3);
        }
        if (accessType.getInterface() == 1280) {
            if (this.sqldbcExecutableName != null) {
                return this.sqldbcExecutableName;
            }
            throw new Tp2Exception("No SQLDBC executable was defined for this TPBenchmark", 3);
        }
        throw new Tp2Exception("No executable available for this AccessType (" + accessType + ")", 2);
    }

    public SimulatedUser newUser(int id, TestEnv testEnv) throws Tp2Exception {
        AccessType accessType = testEnv.getAccessType();
        if (accessType.getUserImpl() == 0) {
            return new SystemUser(id, testEnv);
        }
        if (accessType.getUserImpl() == 1) {
            try {
                if (this.javaUserConstructor == null) {
                    Class<?> juClass = Class.forName(this.javaUserClassName);
                    Class[] paramCl = new Class[]{Integer.TYPE, class$com$sap$sapdb$benchmark$tp2$test$TestEnv == null ? (class$com$sap$sapdb$benchmark$tp2$test$TestEnv = EasyTpBenchmark.class$("com.sap.sapdb.benchmark.tp2.test.TestEnv")) : class$com$sap$sapdb$benchmark$tp2$test$TestEnv};
                    this.javaUserConstructor = juClass.getConstructor(paramCl);
                }
                Object[] param = new Object[]{new Integer(id), testEnv};
                return (JavaUser)this.javaUserConstructor.newInstance(param);
            }
            catch (ClassNotFoundException e) {
                throw new Tp2Exception("Loaded JavaUser" + this.javaUserClassName + " was not found", 2, e);
            }
            catch (NoSuchMethodException e) {
                throw new Tp2Exception(this.javaUserClassName + " does not have a compatible constructor <init>(int, TestEnv)", 2, e);
            }
            catch (InstantiationException e) {
                throw new Tp2Exception("Could not instantiate " + this.javaUserClassName, 2, e);
            }
            catch (IllegalAccessException e) {
                throw new Tp2Exception("Constructor of " + this.javaUserClassName + " is not accessible", 2, e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Tp2Exception) {
                    throw (Tp2Exception)e.getTargetException();
                }
                throw new Tp2Exception("Constructor of " + this.javaUserClassName + " threw an exception" + e.getTargetException(), 2, e);
            }
        }
        throw new Tp2Exception("Cannot create a user for this test environment", 2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InitHandler
    extends SimpleXMLHandler {
        private InitHandler() {
        }

        protected void startTag(String tagName, Attributes attr) throws SAXException {
            if (tagName.equals("TpBenchmark")) {
                EasyTpBenchmark.this.name = attr.getValue("name");
            } else if (tagName.equals("TestDbInit")) {
                EasyTpBenchmark.this.initClassName = attr.getValue("class");
            } else if (tagName.equals("SystemUser")) {
                if (attr.getValue("interface").equals("CPC")) {
                    EasyTpBenchmark.this.cpcExecutablePrefix = attr.getValue("executableName");
                } else if (attr.getValue("interface").equals("ODBC")) {
                    EasyTpBenchmark.this.odbcExecutableName = attr.getValue("executableName");
                } else if (attr.getValue("interface").equals("SQLDBC")) {
                    EasyTpBenchmark.this.sqldbcExecutablePrefix = attr.getValue("executableName");
                }
            } else if (tagName.equals("JavaUser")) {
                EasyTpBenchmark.this.javaUserClassName = attr.getValue("class");
            }
        }

        protected void endTag(String tagName) throws SAXException {
            if (tagName.equals("DBProcedure")) {
                EasyTpBenchmark.this.dbProcInitStmts.add(this.getTagText());
            }
        }
    }
}

