/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.common;

import com.sap.sapdb.benchmark.common.Build;
import com.sap.sapdb.benchmark.common.CompInt;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.MaxcpuWp;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.ShortBuild;
import com.sap.sapdb.benchmark.common.Version;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.AverageResult;
import com.sap.sapdb.benchmark.tp2.common.AverageSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class StructuredResults {
    public static final int DBDESC_VIEW = 0;
    public static final int SHORTBUILD_VIEW = 1;
    private int viewType;
    private ServerNode serverNode = null;
    private int testCount = 0;
    private SortedMap dbDescsView = null;
    private SortedMap shortBuildsView = null;
    private SortedSet userCountList = null;
    private SortedSet accessTypes = null;
    private SortedMap versionsSpans = null;
    private SortedMap buildsSpans = null;
    private SortedMap shortBuildsSpans = null;

    public StructuredResults(ServerNode serverNode, int viewType) {
        this.serverNode = serverNode;
        this.viewType = viewType;
        this.testCount = 0;
        this.userCountList = new TreeSet();
        this.accessTypes = new TreeSet();
        if (viewType == 0) {
            this.dbDescsView = new TreeMap();
        } else if (viewType == 1) {
            this.shortBuildsView = new TreeMap();
        }
    }

    public void handleNextForDbDescView(DBDescription currDd, AccessType currAt, AverageResult ar) {
        SortedMap atForDd;
        if (!this.accessTypes.contains(currAt)) {
            this.accessTypes.add(currAt);
        }
        if (!this.dbDescsView.containsKey(currDd)) {
            this.dbDescsView.put(currDd, new TreeMap());
        }
        if (!(atForDd = (SortedMap)this.dbDescsView.get(currDd)).containsKey(currAt)) {
            atForDd.put(currAt, new AverageSet(this.serverNode, currDd, currAt));
        }
        AverageSet currAs = (AverageSet)atForDd.get(currAt);
        currAs.add(ar);
        this.testCount += ar.getTestCount();
        CompInt uc = new CompInt(ar.getUserCount());
        if (!this.userCountList.contains(uc)) {
            this.userCountList.add(uc);
        }
    }

    public void handleNextForShortBuildView(ShortBuild sb, MaxcpuWp maxcpu, AccessType currAt, AverageResult ar) {
        SortedMap sbMap;
        SBViewId id = new SBViewId(sb, maxcpu);
        if (!this.accessTypes.contains(currAt)) {
            this.accessTypes.add(currAt);
        }
        if (!this.shortBuildsView.containsKey(id)) {
            this.shortBuildsView.put(id, new TreeMap());
        }
        if (!(sbMap = (SortedMap)this.shortBuildsView.get(id)).containsKey(currAt)) {
            sbMap.put(currAt, new AverageSet(this.serverNode, id.getShortBuild(), id.getMaxcpu(), currAt));
        }
        AverageSet currAs = (AverageSet)sbMap.get(currAt);
        currAs.add(ar);
        this.testCount += ar.getTestCount();
        CompInt uc = new CompInt(ar.getUserCount());
        if (!this.userCountList.contains(uc)) {
            this.userCountList.add(uc);
        }
    }

    public void initSpansForDbDescView() {
        this.versionsSpans = new TreeMap();
        this.buildsSpans = new TreeMap();
        Build currBuild = null;
        int spanForBuild = 0;
        int spanForVers = 0;
        Version currVers = null;
        Iterator ddIt = this.dbDescsView.keySet().iterator();
        while (ddIt.hasNext()) {
            DBDescription dd = (DBDescription)ddIt.next();
            Build build = dd.getBuildObject();
            Version vers = build.getVersion();
            if (currBuild == null) {
                currBuild = build;
                currVers = vers;
            } else if (!build.equals(currBuild)) {
                this.buildsSpans.put(currBuild, new Integer(spanForBuild));
                spanForBuild = 0;
                currBuild = build;
                if (!vers.equals(currVers)) {
                    this.versionsSpans.put(currVers, new Integer(spanForVers));
                    spanForVers = 0;
                    currVers = vers;
                }
            }
            spanForBuild += ((SortedMap)this.dbDescsView.get(dd)).size();
            spanForVers += ((SortedMap)this.dbDescsView.get(dd)).size();
        }
        this.buildsSpans.put(currBuild, new Integer(spanForBuild));
        this.versionsSpans.put(currVers, new Integer(spanForVers));
    }

    public void initSpansForShortBuildView() {
        this.versionsSpans = new TreeMap();
        this.shortBuildsSpans = new TreeMap();
        ShortBuild currShortBuild = null;
        int spanForBuild = 0;
        int spanForVers = 0;
        Version currVers = null;
        Iterator mIt = this.shortBuildsView.keySet().iterator();
        while (mIt.hasNext()) {
            SBViewId id = (SBViewId)mIt.next();
            Version vers = id.getShortBuild().getVersion();
            if (currShortBuild == null) {
                currShortBuild = id.getShortBuild();
                currVers = vers;
            } else if (!id.getShortBuild().equals(currShortBuild)) {
                this.shortBuildsSpans.put(currShortBuild, new Integer(spanForBuild));
                spanForBuild = 0;
                currShortBuild = id.getShortBuild();
                if (!vers.equals(currVers)) {
                    this.versionsSpans.put(currVers, new Integer(spanForVers));
                    spanForVers = 0;
                    currVers = vers;
                }
            }
            spanForBuild += ((SortedMap)this.shortBuildsView.get(id)).size();
            spanForVers += ((SortedMap)this.shortBuildsView.get(id)).size();
        }
        this.shortBuildsSpans.put(currShortBuild, new Integer(spanForBuild));
        this.versionsSpans.put(currVers, new Integer(spanForVers));
    }

    public int getViewType() {
        return this.viewType;
    }

    public ServerNode getServerNode() {
        return this.serverNode;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public SortedMap getDbDescsView() {
        return this.dbDescsView;
    }

    public SortedMap getShortBuildsView() {
        return this.shortBuildsView;
    }

    public SortedMap getVersionsSpans() {
        return this.versionsSpans;
    }

    public SortedMap getBuildsSpans() {
        return this.buildsSpans;
    }

    public SortedMap getShortBuildsSpans() {
        return this.shortBuildsSpans;
    }

    public SortedSet getAccessTypes() {
        return this.accessTypes;
    }

    public SortedSet getUserCountList() {
        return this.userCountList;
    }

    public boolean isDBDescView() {
        return this.viewType == 0;
    }

    public boolean isShortBuildView() {
        return this.viewType == 1;
    }

    public class SBViewId
    implements Comparable {
        private ShortBuild shortBuild = null;
        private MaxcpuWp maxcpu = null;

        public SBViewId(ShortBuild shortBuild, MaxcpuWp maxcpu) {
            this.shortBuild = shortBuild;
            this.maxcpu = maxcpu;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SBViewId) {
                return this.shortBuild.equals(((SBViewId)obj).getShortBuild()) && this.maxcpu.equals(((SBViewId)obj).getMaxcpu());
            }
            return false;
        }

        public int compareTo(Object obj) {
            if (obj instanceof SBViewId) {
                SBViewId sbwi = (SBViewId)obj;
                int sbC = this.getShortBuild().compareTo(sbwi.getShortBuild());
                if (sbC == 0) {
                    return this.getMaxcpu().compareTo(sbwi.getMaxcpu());
                }
                return sbC;
            }
            return 0;
        }

        public MaxcpuWp getMaxcpu() {
            return this.maxcpu;
        }

        public ShortBuild getShortBuild() {
            return this.shortBuild;
        }

        public String toString() {
            return this.maxcpu + "," + this.shortBuild;
        }
    }
}

