/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.cases;

import com.sap.sapdb.benchmark.tp2.cases.Fitness;
import com.sap.sapdb.benchmark.tp2.cases.ParameterSet;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.common.Tp2Result;
import com.sap.sapdb.benchmark.tp2.test.BadResultException;
import com.sap.sapdb.benchmark.tp2.test.Tp2TestCase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class ParamOptim
extends Tp2TestCase {
    private ParameterSet firstSet = null;
    private Vector toDo = null;
    private TreeMap alreadyDone = null;
    private int initialCfgCount = 0;
    private int[] userCountProg = null;
    private File xlsReport = null;

    protected void runCase() throws Tp2Exception {
        this.prepareOptim();
        this.stdOut(this.initialCfgCount + " different configurations will be tested");
        ParameterSet currentSet = this.findNearest(this.firstSet);
        int count = 0;
        while (!this.toDo.isEmpty()) {
            try {
                currentSet.putParameters(ParamOptim.getDatabase());
                float newFitness = 0.0f;
                Tp2Result[][] results = new Tp2Result[this.getTryCount()][this.userCountProg.length];
                int testsDone = 0;
                for (int j = 0; j < this.getTryCount(); ++j) {
                    for (int i = 0; i < this.userCountProg.length; ++i) {
                        try {
                            results[j][i] = this.runTest(this.userCountProg[i]);
                            newFitness += results[j][i].getTpsAsFloat();
                            ++testsDone;
                            continue;
                        }
                        catch (BadResultException e) {
                            this.stdErr(e);
                        }
                    }
                }
                this.alreadyDone.put(new Fitness(newFitness /= (float)testsDone), currentSet);
                this.toDo.remove(currentSet);
                try {
                    int[] paramVal = currentSet.getParameters();
                    PrintWriter out = new PrintWriter((Writer)new FileWriter(this.xlsReport.getPath(), true), true);
                    StringBuffer resultLine = new StringBuffer("");
                    resultLine.append(count);
                    for (int k = 0; k < ParameterSet.getParameterCount(); ++k) {
                        resultLine.append("\t").append(paramVal[k]);
                    }
                    resultLine.append("\t" + newFitness);
                    for (int i = 0; i < this.userCountProg.length; ++i) {
                        int cnt = 0;
                        float sum = 0.0f;
                        for (int j = 0; j < this.getTryCount(); ++j) {
                            if (results[j][i] == null) continue;
                            sum += results[j][i].getTpsAsFloat();
                            ++cnt;
                        }
                        if (cnt == 0) {
                            resultLine.append("\tFAILED");
                            continue;
                        }
                        resultLine.append("\t" + sum / (float)cnt);
                    }
                    resultLine.append("\n");
                    out.print(resultLine.toString());
                    this.stdOut("# Computation done:\n " + resultLine.toString());
                    out.close();
                }
                catch (IOException e) {
                    this.getCaseEnv().logError("ParamOptim", "Problem when writing results", e);
                }
            }
            catch (TestDatabaseException e) {
                e.printStackTrace(System.err);
                this.toDo.remove(currentSet);
            }
            currentSet = this.findNextParameterSet();
            ++count;
        }
    }

    private void prepareOptim() throws Tp2Exception {
        String[] paramNames = new String[]{"_PRIO_BASE_COM", "_PRIO_BASE_U2U", "_PRIO_FACTOR"};
        Object paramProgs = null;
        if (this.getCaseEnv().isPropSet("tp2.ext.paramProgram")) {
            Vector cfgValVect;
            StringTokenizer ST1 = new StringTokenizer(this.getCaseEnv().getProp("tp2.ext.paramProgram"), ";");
            TreeMap<String, Vector> paramProgsMap = new TreeMap<String, Vector>();
            while (ST1.hasMoreTokens()) {
                StringTokenizer ST2 = new StringTokenizer(ST1.nextToken(), "=");
                String paramName = ST2.nextToken();
                StringTokenizer ST3 = new StringTokenizer(ST2.nextToken(), ",");
                cfgValVect = new Vector();
                while (ST3.hasMoreTokens()) {
                    cfgValVect.add(ST3.nextToken());
                }
                paramProgsMap.put(paramName, cfgValVect);
            }
            paramNames = new String[paramProgsMap.size()];
            paramProgs = new int[paramProgsMap.size()][];
            Iterator names = paramProgsMap.keySet().iterator();
            int index = 0;
            while (names.hasNext()) {
                String name;
                paramNames[index] = name = (String)names.next();
                cfgValVect = (Vector)paramProgsMap.get(name);
                paramProgs[index] = new int[cfgValVect.size()];
                for (int i = 0; i < cfgValVect.size(); ++i) {
                    paramProgs[index][i] = Integer.parseInt((String)cfgValVect.get(i));
                }
                ++index;
            }
        }
        ParameterSet.setParameterNames(paramNames);
        this.toDo = new Vector();
        this.alreadyDone = new TreeMap();
        this.stdOut("\n*****\n* TP2 - DB parameters optimization (" + ParameterSet.getParameterNamesAsOutput() + ")\n*****");
        int[] current = new int[ParameterSet.getParameterCount()];
        for (int i = 0; i < paramProgs[0].length; ++i) {
            this.fillToDo(current, 0, (int[][])paramProgs, i);
        }
        int[] firstGen = new int[ParameterSet.getParameterCount()];
        for (int i = 0; i < firstGen.length; ++i) {
            firstGen[i] = paramProgs[i][0];
        }
        this.firstSet = new ParameterSet(firstGen);
        int[] def = new int[]{30};
        this.userCountProg = this.createUserCountProgramFromProperties(def);
        this.xlsReport = new File(this.getTp2Home() + "parametersOptimizer-" + this.getCaseEnv().getSessionId() + ".xls");
        if (!this.xlsReport.exists()) {
            try {
                int i;
                PrintWriter out = new PrintWriter((Writer)new FileWriter(this.xlsReport), true);
                out.write("Optimizer report\n");
                out.write("\n");
                out.write("Session\t" + this.getTp2Case().getSession().getId() + "\n");
                out.write("Desc.\t" + this.getTp2Case().getSession().getDescription() + "\n");
                out.write("Host\t" + this.getTp2Case().getServerNode().getShortHostName() + "\n");
                out.write("Date\t" + this.getTp2Case().getBeginDate() + "\n");
                out.write("\n");
                StringBuffer resultLine = new StringBuffer("");
                resultLine.append("Count");
                for (i = 0; i < ParameterSet.getParameterCount(); ++i) {
                    resultLine.append("\t").append(paramNames[i]);
                }
                resultLine.append("\tFitness");
                for (i = 0; i < this.userCountProg.length; ++i) {
                    resultLine.append("\t" + this.userCountProg[i]);
                }
                resultLine.append("\n");
                out.print(resultLine.toString());
                out.close();
            }
            catch (IOException e) {
                this.getCaseEnv().logError("ParamOptim", "Problem when writing report header", e);
            }
        }
    }

    private void fillToDo(int[] current, int paramIndex, int[][] cfgVal, int cfgIndex) {
        if (paramIndex == ParameterSet.getParameterCount() - 1) {
            current[paramIndex] = cfgVal[paramIndex][cfgIndex];
            int[] paramVal = new int[ParameterSet.getParameterCount()];
            String values = "";
            for (int i = 0; i < ParameterSet.getParameterCount(); ++i) {
                paramVal[i] = current[i];
                values = values + current[i] + ",";
            }
            this.toDo.add(new ParameterSet(paramVal));
            this.stdOut("Added " + values, 20);
            ++this.initialCfgCount;
            return;
        }
        current[paramIndex] = cfgVal[paramIndex][cfgIndex];
        for (int j = 0; j < cfgVal[paramIndex + 1].length; ++j) {
            this.fillToDo(current, paramIndex + 1, cfgVal, j);
        }
    }

    private ParameterSet findNextParameterSet() {
        if (this.alreadyDone.isEmpty()) {
            return (ParameterSet)this.toDo.get(0);
        }
        return this.findNearest((ParameterSet)this.alreadyDone.get(this.alreadyDone.lastKey()));
    }

    private ParameterSet findNearest(ParameterSet paramSet) {
        double currDist = -1.0;
        ParameterSet result = null;
        for (int i = 0; i < this.toDo.size(); ++i) {
            double dist = paramSet.distance((ParameterSet)this.toDo.get(i));
            if (i != 0 && !(dist < currDist)) continue;
            currDist = dist;
            result = (ParameterSet)this.toDo.get(i);
        }
        return result;
    }
}

