/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common.where;

import com.sap.sapdb.benchmark.common.where.AtomicFilter;
import com.sap.sapdb.benchmark.common.where.CompositeFilter;
import com.sap.sapdb.benchmark.common.where.FilterInstance;
import com.sap.sapdb.benchmark.common.where.WhereProducer;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CartesianProductFilter
implements CompositeFilter {
    private Vector seq = null;
    private int cursor = 0;
    private String[] tableNames = null;

    public void init(List atomicFilters) {
        this.seq = new Vector();
        this.tableNames = new String[atomicFilters.size()];
        for (int i = 0; i < atomicFilters.size(); ++i) {
            this.tableNames[i] = ((AtomicFilter)atomicFilters.get(i)).getTableName();
        }
        this.buildFilterInstance(new WhereProducer[atomicFilters.size()], 0, atomicFilters);
        this.cursor = 0;
    }

    private void buildFilterInstance(WhereProducer[] fi, int depth, List atomicFilters) {
        int atomicFilterCount = atomicFilters.size();
        AtomicFilter af = (AtomicFilter)atomicFilters.get(depth);
        Iterator wps = af.getWhereProducers().iterator();
        while (wps.hasNext()) {
            fi[depth] = (WhereProducer)wps.next();
            if (depth + 1 == atomicFilterCount) {
                this.seq.add(new FilterInstance(fi, this.tableNames));
                continue;
            }
            this.buildFilterInstance(fi, depth + 1, atomicFilters);
        }
    }

    public FilterInstance nextFilterInstance() {
        FilterInstance result = (FilterInstance)this.seq.get(this.cursor);
        ++this.cursor;
        return result;
    }

    public boolean hasNext() {
        return this.cursor < this.seq.size();
    }
}

