/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.BenchmarkException;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.PropertyContainer;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.User;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class Session
extends StorableObject {
    public static final String WISCONSIN = "Wisconsin";
    private String description = null;
    private boolean npClosed = false;
    private Date beginDate = null;
    private Date endDate = null;
    private User user = null;
    private String benchmarkType = null;
    private int relatedTestsCount = -1;
    static /* synthetic */ Class class$com$sap$sapdb$benchmark$common$Session;

    public static Session createSession(String description, User relatedUser, String benchmarkType) throws SQLException {
        if (!Session.isNonPersistent()) {
            User user = relatedUser;
            Statement stmt = Session.getConnection().createStatement();
            stmt.executeUpdate("INSERT INTO sessions SET id=sessions_seq.NEXTVAL,description='" + description + "'," + "benchmark_type='" + benchmarkType + "'," + "user_id='" + user.getId() + "'");
            ResultSet RS = stmt.executeQuery("SELECT id, begin_date FROM sessions WHERE id=sessions_seq.CURRVAL");
            RS.next();
            int id = RS.getInt("id");
            Timestamp beginDate = RS.getTimestamp("begin_date");
            RS.close();
            stmt.close();
            Session.getConnection().commit();
            return new Session(id, description, user, benchmarkType, beginDate, null);
        }
        Session sess = new Session(NonPersistent.getNextId(class$com$sap$sapdb$benchmark$common$Session == null ? (class$com$sap$sapdb$benchmark$common$Session = Session.class$("com.sap.sapdb.benchmark.common.Session")) : class$com$sap$sapdb$benchmark$common$Session), description, relatedUser, benchmarkType, new Date(), null);
        NonPersistent.insert(sess);
        return sess;
    }

    public static Session loadSession(int id) throws SQLException {
        if (!Session.isNonPersistent()) {
            Statement stmt = Session.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT id,description,user_id,benchmark_type,begin_date,end_date FROM sessions WHERE id=" + id);
            if (RS.next()) {
                String description = RS.getString("description");
                String benchmarkType = RS.getString("benchmark_type");
                int userId = RS.getInt("user_id");
                User user = User.loadUser(userId);
                Timestamp beginDate = RS.getTimestamp("begin_date");
                Timestamp endDate = null;
                if (RS.getString("end_date") != null) {
                    endDate = RS.getTimestamp("end_date");
                }
                RS.close();
                stmt.close();
                Session.getConnection().commit();
                return new Session(id, description, user, benchmarkType, beginDate, endDate);
            }
            RS.close();
            stmt.close();
            return null;
        }
        return (Session)NonPersistent.select(class$com$sap$sapdb$benchmark$common$Session == null ? (class$com$sap$sapdb$benchmark$common$Session = Session.class$("com.sap.sapdb.benchmark.common.Session")) : class$com$sap$sapdb$benchmark$common$Session, id);
    }

    public static Session findOrCreateSession(User user, String benchmarkType, PropertyContainer propCont) throws BenchmarkException {
        try {
            if (!Session.isNonPersistent()) {
                if (propCont.getPropertyWithDefault("benchmark.case.globalSession", "DEF_MARK").equals("true")) {
                    return user.getGlobalSession(benchmarkType);
                }
                if (!propCont.getPropertyWithDefault("benchmark.case.loadSession", "DEF_MARK").equals("DEF_MARK")) {
                    int sessionId = Integer.parseInt(propCont.getPropertyWithDefault("benchmark.case.loadSession", "DEF_MARK"));
                    try {
                        return Session.loadSession(sessionId);
                    }
                    catch (SQLException e) {
                        System.err.println("Error when looking for Session with id=" + sessionId + ": " + e);
                    }
                }
                if (!propCont.getPropertyWithDefault("benchmark.case.createSession", "DEF_MARK").equals("DEF_MARK")) {
                    return Session.createSession(propCont.getPropertyWithDefault("benchmark.case.createSession", "DEF_MARK"), user, benchmarkType);
                }
                Session defaultResult = Session.findLastNonGlobalOpenSession(user, benchmarkType);
                if (defaultResult == null) {
                    defaultResult = Session.createSession("New session for user " + user.getName() + "[" + user.getId() + "] - " + new Date(), user, benchmarkType);
                }
                return defaultResult;
            }
            return Session.createSession("Non persistent session started at ", user, benchmarkType);
        }
        catch (SQLException e) {
            throw new BenchmarkException("Problem when looking for a session for User " + user.getName() + "[" + user.getId() + "] and benchmark " + benchmarkType);
        }
    }

    private static Session findLastNonGlobalOpenSession(User user, String benchmarkType) throws SQLException {
        Statement stmt = StorableObject.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("SELECT id FROM sessions WHERE user_id=" + user.getId() + " AND benchmark_type='" + benchmarkType + "'" + " AND is_closed=FALSE" + " AND id NOT IN (" + "SELECT global.session_id " + " FROM global_sessions global, sessions sess" + " WHERE global.session_id=sess.id " + " AND sess.benchmark_type='" + benchmarkType + "'" + " AND global.user_id=" + user.getId() + ")" + " ORDER BY id DESC");
        Session result = null;
        if (RS.next()) {
            result = Session.loadSession(RS.getInt("id"));
        }
        RS.close();
        return result;
    }

    public Session(int id, String description, User user, String benchmarkType, Date beginDate, Date endDate) {
        super(id);
        this.description = description;
        this.user = user;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.benchmarkType = benchmarkType;
    }

    public void close() throws SQLException {
        if (!Session.isNonPersistent()) {
            Statement stmt = Session.getConnection().createStatement();
            stmt.executeUpdate("UPDATE sessions SET is_closed=TRUE,end_date=TIMESTAMP WHERE id=" + this.getId());
            Session.getConnection().commit();
            stmt.close();
        } else {
            this.npClosed = true;
        }
    }

    public void open() throws SQLException {
        if (!Session.isNonPersistent()) {
            Statement stmt = Session.getConnection().createStatement();
            stmt.executeUpdate("UPDATE sessions SET is_closed=FALSE,end_date=NULL WHERE id=" + this.getId());
            Session.getConnection().commit();
            stmt.close();
        } else {
            this.npClosed = false;
        }
    }

    public boolean isGlobalSession() throws SQLException {
        Session globalSession = this.user.getGlobalSession(this.getBenchmarkType());
        if (globalSession == null) {
            return false;
        }
        return globalSession.equals(this);
    }

    public boolean isClosed() throws SQLException {
        if (!Session.isNonPersistent()) {
            Statement stmt = Session.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT is_closed, end_date FROM sessions WHERE id=" + this.getId());
            RS.next();
            boolean result = RS.getBoolean("is_closed");
            if (result) {
                this.endDate = RS.getTimestamp("end_date");
            }
            RS.close();
            stmt.close();
            Session.getConnection().commit();
            return result;
        }
        return this.npClosed;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() throws SQLException {
        if (this.isClosed()) {
            return this.endDate;
        }
        return null;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User userArg) throws SQLException {
        if (!Session.isNonPersistent()) {
            if (this.isGlobalSession()) {
                this.user.setGlobalSession(null);
            }
            Statement stmt = Session.getConnection().createStatement();
            stmt.executeUpdate("UPDATE sessions SET user_id=" + userArg.getId() + " WHERE id=" + this.getId());
            stmt.close();
            Session.getConnection().commit();
        }
        this.user = userArg;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws SQLException {
        if (!Session.isNonPersistent()) {
            Statement stmt = Session.getConnection().createStatement();
            stmt.executeUpdate("UPDATE sessions SET description='" + description + "' WHERE id=" + this.getId());
            stmt.close();
            Session.getConnection().commit();
        }
        this.description = description;
    }

    public String getBenchmarkType() {
        return this.benchmarkType;
    }

    public int getRelatedTestsCount() {
        return this.relatedTestsCount;
    }

    public void setRelatedTestsCount(int relatedTestCount) {
        this.relatedTestsCount = relatedTestCount;
    }

    public String toString() {
        return "#" + this.getId();
    }

    public int compareTo(Object obj) {
        if (obj instanceof StorableObject) {
            return ((StorableObject)obj).getId() - this.getId();
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

