/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.util.testdriver;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtechtest.util.ConnectionWrapper;
import com.sap.dbtechtest.xlog.LogWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class TestEnvironment {
    Dictionary values = new Hashtable();
    String actualKernelVersion = "06.02.10.000";
    boolean testRunsWithMaxDB;
    public static final String AsciiDB = "AsciiDB";
    public static final String UnicodeDB = "UnicodeDB";
    public static final String picky = "picky";
    public static final String minKernel = "minKernel";

    public TestEnvironment(Connection connection, LogWriter logWriter) {
        Connection connection2 = connection instanceof ConnectionWrapper ? ((ConnectionWrapper)connection).getInnerClass() : connection;
        if (connection2 instanceof ConnectionSapDB || connection2 instanceof com.sap.dbtech.jdbc.trace.Connection) {
            this.testRunsWithMaxDB = true;
        }
        this.fillStdFeatures(connection, logWriter);
    }

    public TestEnvironment() {
    }

    protected void fillStdFeatures(Connection connection, LogWriter logWriter) {
        int n;
        String string = System.getProperty("java.vm.version");
        String[] stringArray = new String[]{"1.1", "1.2", "1.3", "1.4"};
        String string2 = string.substring(0, 3);
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (string2.equals(stringArray[n])) {
                bl = true;
            }
            if (!bl) continue;
            this.addFeature("java" + stringArray[n]);
        }
        logWriter.addParameter("java.vm.version", string);
        if (this.testRunsWithMaxDB) {
            try {
                n = 0;
                boolean bl2 = false;
                Object var9_10 = null;
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("select description,value from dbparameters where description = '_UNICODE'                               or description = 'DEFAULT_CODE'                               or description = 'KERNELVERSION' ");
                while (resultSet.next()) {
                    if (resultSet.getString(1).equalsIgnoreCase("_UNICODE") && resultSet.getString(2).equalsIgnoreCase("YES")) {
                        n = 1;
                        continue;
                    }
                    if (resultSet.getString(1).equalsIgnoreCase("DEFAULT_CODE") && resultSet.getString(2).equalsIgnoreCase("UNICODE")) {
                        bl2 = true;
                        continue;
                    }
                    if (!resultSet.getString(1).equalsIgnoreCase("KERNELVERSION")) continue;
                    this.actualKernelVersion = this.parseKernelVersion(resultSet.getString(2));
                    logWriter.addParameter("Kernel Version", this.actualKernelVersion);
                }
                if (n != 0) {
                    this.addFeature(UnicodeDB);
                    logWriter.addParameter(UnicodeDB, "true");
                } else {
                    this.addFeature(AsciiDB);
                    logWriter.addParameter(AsciiDB, "true");
                }
                resultSet.close();
            }
            catch (Exception exception) {
                logWriter.addInfo("init Environment error: ", exception.toString());
            }
        }
    }

    public void addFeature(String string) {
        this.values.put(string, Boolean.TRUE);
    }

    public boolean hasFeature(String string) {
        return this.values.get(string) != null;
    }

    public boolean fullfillsRequirements(TestEnvironment testEnvironment) {
        return this.getMissingFeature(testEnvironment) == null;
    }

    public String getMissingFeature(TestEnvironment testEnvironment) {
        if (testEnvironment == null) {
            return null;
        }
        Enumeration enumeration = testEnvironment.values.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.hasFeature(string)) continue;
            return string;
        }
        if (testEnvironment.actualKernelVersion.compareTo(this.actualKernelVersion) >= 0) {
            return "minimal kernel version " + testEnvironment.actualKernelVersion + " needed";
        }
        return null;
    }

    public String parseKernelVersion(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        MessageFormat messageFormat = new MessageFormat("{0,number,00}.{1,number,00}.{2,number,00}.{3,number,000}");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (!Character.isSpaceChar(string.charAt(n3))) {
            ++n3;
        }
        while (Character.isSpaceChar(string.charAt(n3))) {
            ++n3;
        }
        n = n3;
        while (string.charAt(n3) != '.') {
            ++n3;
        }
        n2 = n3++;
        arrayList.add(new Integer(Integer.parseInt(string.substring(n, n2))));
        n = n3;
        while (string.charAt(n3) != '.') {
            ++n3;
        }
        n2 = n3++;
        arrayList.add(new Integer(Integer.parseInt(string.substring(n, n2))));
        n = n3;
        while (!Character.isSpaceChar(string.charAt(n3))) {
            ++n3;
        }
        n2 = n3;
        arrayList.add(new Integer(Integer.parseInt(string.substring(n, n2))));
        while (Character.isSpaceChar(string.charAt(n3))) {
            ++n3;
        }
        while (!Character.isSpaceChar(string.charAt(n3))) {
            ++n3;
        }
        while (Character.isSpaceChar(string.charAt(n3))) {
            ++n3;
        }
        n = n3;
        while (string.charAt(n3) != '-') {
            ++n3;
        }
        n2 = n3;
        arrayList.add(new Integer(Integer.parseInt(string.substring(n, n2))));
        String string2 = messageFormat.format(arrayList.toArray());
        return string2;
    }

    public boolean testRunsWithMaxDB() {
        return this.testRunsWithMaxDB;
    }
}

