/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.util.options;

import com.sap.dbtechtest.util.options.Options;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Runner {
    public static final String runSuffixC = "Run";
    public static final String optionsSuffixC = "Options";
    protected static final Options DefaultOptionsC = new Options(null, null);

    public void run(String[] stringArray) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Options options = this.getMainOptions();
        options.parse(stringArray);
        String[] stringArray2 = options.getArgs();
        if (stringArray2.length == 0) {
            this.runAll();
            return;
        }
        String string = stringArray2[0];
        stringArray2 = Runner.subArray(stringArray2, 1);
        if (string.equals("help")) {
            if (stringArray2.length > 1) {
                this.helpOn(stringArray2[0]);
            } else {
                this.helpAll();
            }
        } else if (string.equals("all")) {
            this.runAll();
        } else {
            Method method = this.findMethod(string);
            this.runMethod(method, stringArray2);
        }
    }

    public Method findMethod(String string) {
        String string2 = string + runSuffixC;
        Method[] methodArray = this.getClass().getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string2)) continue;
            return methodArray[i];
        }
        return null;
    }

    public Method[] getRunMethods() {
        Method[] methodArray = this.getClass().getMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().endsWith(runSuffixC)) continue;
            methodArray2[n] = method;
            ++n;
        }
        Method[] methodArray3 = new Method[n];
        System.arraycopy(methodArray2, 0, methodArray3, 0, n);
        return methodArray3;
    }

    public Options findOptions(String string) {
        Options options;
        String string2 = string + optionsSuffixC;
        Field field = null;
        try {
            field = this.getClass().getDeclaredField(string2);
            options = (Options)field.get(this);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            options = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            options = null;
        }
        return options;
    }

    public void runAll() throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Method[] methodArray = this.getRunMethods();
        String[] stringArray = new String[]{};
        for (int i = 0; i < methodArray.length; ++i) {
            this.runMethod(methodArray[i], stringArray);
        }
    }

    public void runMethod(Method method, String[] stringArray) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray;
        String string = this.methodBase(method);
        Options options = this.findOptions(string);
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            objectArray = new Object[]{};
        } else if (classArray.length == 1 && classArray[0].getName().equals("[Ljava.lang.String;")) {
            objectArray = new Object[]{stringArray};
        } else if (options != null) {
            options.parse(stringArray);
            objectArray = new Object[]{options};
        } else {
            objectArray = new Object[]{};
        }
        method.invoke((Object)this, objectArray);
    }

    public void helpAll() {
        Method[] methodArray = this.getRunMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = this.methodBase(methodArray[i]);
            this.helpOn(string);
        }
    }

    public void helpOn(String string) {
        System.out.println(string);
    }

    public Options getMainOptions() {
        return DefaultOptionsC;
    }

    public static String[] subArray(String[] stringArray, int n) {
        String[] stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray.length - n);
        return stringArray2;
    }

    public String methodBase(Method method) {
        String string = method.getName();
        String string2 = string.substring(0, string.length() - runSuffixC.length());
        return string2;
    }
}

