/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.TestDifference;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class VarcharTrimTest
extends Test {
    private static final String help = "Test that only the necessary trim is applied.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public VarcharTrimTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public VarcharTrimTest(Test test) throws SQLException {
        super(test);
    }

    private String[] makeStrings() {
        String[] stringArray = new String[34];
        for (char c = '\u0001'; c < '\"'; c = (char)(c + '\u0001')) {
            StringBuffer stringBuffer = new StringBuffer(10);
            for (int i = 0; i < 10; ++i) {
                stringBuffer.append(c);
            }
            stringArray[c] = stringBuffer.toString();
        }
        return stringArray;
    }

    public void testRun() throws SQLException {
        String[] stringArray = this.makeStrings();
        String string = this.getUnicodeIdentifier("TEST_VCTRIM");
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + "(I INTEGER, VC VARCHAR(10))");
        PreparedStatement preparedStatement = this.prepare("INSERT INTO " + string + " (I, VC) VALUES (?, ?)");
        for (int i = 1; i < stringArray.length; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, stringArray[i]);
            preparedStatement.executeUpdate();
        }
        ResultSet resultSet = this.stmt.executeQuery("SELECT I, VC FROM " + string + " ORDER BY I");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            String string2 = resultSet.getString(2);
            if (string2.equals(stringArray[n]) || n == 32) continue;
            this.log.addFailure(new TestDifference("VarcharTrim", "Varchar is trimmed", "10 chars with byte " + Integer.toHexString(n), string2.length() + " chars with byte " + (string2.length() == 0 ? "(none)" : Integer.toHexString(string2.charAt(0)))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        VarcharTrimTest varcharTrimTest = new VarcharTrimTest(stringArray);
        try {
            varcharTrimTest.runInner();
        }
        finally {
            varcharTrimTest.connection.close();
        }
        if (varcharTrimTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

