/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class NullValuesInOracleMode
extends Test {
    private static final String help = "help for NullValuesInOracleMode";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public NullValuesInOracleMode(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public NullValuesInOracleMode(Test test) throws SQLException {
        super(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRun() throws SQLException {
        PreparedStatement preparedStatement;
        String string = "NullValuesInOracleMode";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.executeUpdate("CREATE TABLE " + string2 + " (a int, b varchar(5), c timestamp)");
        this.connection.commit();
        if (!this.environment.testRunsWithMaxDB()) {
            return;
        }
        Connection connection = this.getConnection("internal");
        Statement statement = connection.createStatement();
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO " + string2 + " VALUES (?,?,?)");
            preparedStatement.setString(1, "");
            preparedStatement.setString(2, "");
            preparedStatement.setString(2, "");
            preparedStatement.executeUpdate();
            connection.commit();
            this.log.addFailure(new Failure("INSERT NULL VALUE: excepted ConversionExceptionSapDB is not occured"));
        }
        catch (Exception exception) {
        }
        finally {
            connection.close();
        }
        connection = this.getConnection("oracle");
        preparedStatement = connection.prepareStatement("INSERT INTO " + string2 + " VALUES (?,?,?)");
        preparedStatement.setString(1, "");
        preparedStatement.setString(2, "");
        preparedStatement.setString(3, "");
        preparedStatement.executeUpdate();
        connection.commit();
        Statement statement2 = connection.createStatement();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + string2);
        resultSet.next();
        this.log.addDifference(string, "Expect Nullvalue from int column", new Integer(0), new Integer(resultSet.getInt(1)));
        this.log.addDifference(string, "Expect Nullvalue from varchar column", null, resultSet.getString(2));
        this.log.addDifference(string, "Expect Nullvalue from timestamp column", null, resultSet.getTimestamp(3));
        this.log.addDifference(string, "Expected Resultcount of 1", Boolean.FALSE, new Boolean(resultSet.next()));
    }

    private Connection getConnection(String string) throws SQLException {
        String string2 = this.getUsername();
        String string3 = this.options.getPassword();
        String string4 = this.options.getHostname();
        String string5 = this.options.getDBName();
        String string6 = "jdbc:sapdb://" + string4 + "/" + string5 + "?sqlmode=" + string;
        return DriverManager.getConnection(string6, "" + string2 + "", "" + string3 + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        NullValuesInOracleMode nullValuesInOracleMode = new NullValuesInOracleMode(stringArray);
        try {
            nullValuesInOracleMode.runInner();
        }
        finally {
            nullValuesInOracleMode.connection.close();
        }
        if (nullValuesInOracleMode.log.hasErrors()) {
            System.exit(5);
        }
    }
}

