/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.translators.ConversionExceptionSapDB;
import com.sap.dbtechtest.jdbc.types.Constants;
import com.sap.dbtechtest.jdbc.types.Reflector;
import com.sap.dbtechtest.jdbc.types.TypeEnums;
import com.sap.dbtechtest.util.options.ListOption;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.ExceptionOccurred;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class NullTest
extends Test {
    private String[] sqlCols;
    private String[] jdbcTypes;
    private static final String help = "tests getXXX/setXXX for NULL values";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new ListOption("sqlcol", "SQL column definition", null), new ListOption("jdbcType", "JDBC type string", null), new StringOption("subtest", "[both | insert | fetch]", "both", null)};

    public NullTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
        this.sqlCols = TypeEnums.getSQLTypes(this.environment.hasFeature("UnicodeDB"));
        this.jdbcTypes = TypeEnums.JDBCTypesC;
        boolean bl = this.environment.hasFeature("UnicodeDB");
        this.sqlCols = this.getListOption("sqlcol", TypeEnums.getSQLTypes(bl));
        this.jdbcTypes = this.getListOption("jdbcType", TypeEnums.JDBCTypesC);
    }

    protected String[] getListOption(String string, String[] stringArray) {
        int n;
        String[] stringArray2 = stringArray;
        Vector vector = this.options.getVector(string);
        if (vector != null && (n = vector.size()) > 0) {
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.get(i);
                try {
                    int n2 = Integer.parseInt(string2);
                    string2 = stringArray[n2];
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                stringArray2[i] = string2;
            }
        }
        return stringArray2;
    }

    public NullTest(Test test) throws SQLException {
        super(test);
        this.sqlCols = TypeEnums.getSQLTypes(this.environment.hasFeature("UnicodeDB"));
        this.jdbcTypes = TypeEnums.JDBCTypesC;
        this.options.addExtraOptions(optdesc);
    }

    public void testRun() throws SQLException {
        String string = this.options.getString("subtest");
        String string2 = "NullTest";
        String string3 = "NullTest";
        this.createTable(string3);
        if (string.equals("both") || string.equals("insert")) {
            this.runInsertTest(string3);
        }
        if (string.equals("both") || string.equals("fetch")) {
            this.runFetchTest(string3);
        }
    }

    protected void createTable(String string) throws SQLException {
        this.dropTable(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(string);
        stringBuffer.append(" (context varchar (50)");
        String string2 = ", ";
        for (int i = 0; i < this.sqlCols.length; ++i) {
            stringBuffer.append(string2 + "col" + i + " " + this.sqlCols[i]);
        }
        stringBuffer.append(")");
        this.stmt.execute(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInsertTest(String string) throws SQLException {
        this.log.push("insert Nulls");
        try {
            for (int i = 0; i < this.sqlCols.length; ++i) {
                this.sql("delete from " + string);
                PreparedStatement preparedStatement = this.prepare("insert into " + string + " (context, col" + i + ") values (?, ?)");
                String string2 = this.sqlCols[i] + "|setNull";
                try {
                    preparedStatement.setString(1, string2);
                    preparedStatement.setNull(2, -1);
                    preparedStatement.execute();
                    this.log.addInfo(string2, "inserted");
                }
                catch (SQLException sQLException) {
                    this.log.addFailure(new ExceptionOccurred(string2, sQLException));
                }
                Object[] objectArray = new Object[]{Constants.secondColC, null, Constants.undefC};
                for (int j = 0; j < this.jdbcTypes.length; ++j) {
                    String string3 = this.jdbcTypes[j];
                    string2 = this.sqlCols[i] + ":" + string3;
                    try {
                        if (TypeEnums.isPrimitiveType(string3)) continue;
                        preparedStatement.setString(1, string2);
                        Reflector.apply(preparedStatement, "set" + string3, objectArray);
                        preparedStatement.execute();
                        this.log.addInfo(string2, "inserted");
                        continue;
                    }
                    catch (JDBCDriverException jDBCDriverException) {
                        this.handleDriverException(string2, string3, jDBCDriverException);
                        continue;
                    }
                    catch (ConversionExceptionSapDB conversionExceptionSapDB) {
                        this.log.addInfo(string2, conversionExceptionSapDB.toString());
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.log.addFailure(new ExceptionOccurred(string2, sQLException));
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        this.log.addFailure(new ExceptionOccurred(string2, runtimeException));
                    }
                }
                this.checkAllNull(string, i);
            }
        }
        finally {
            this.log.pop();
        }
    }

    protected void handleDriverException(String string, String string2, JDBCDriverException jDBCDriverException) {
        if (TypeEnums.isNotSupportedType(string2)) {
            this.log.addInfo(string, jDBCDriverException.toString());
        } else {
            this.log.addFailure(new ExceptionOccurred(string, jDBCDriverException));
        }
    }

    protected void checkAllNull(String string, int n) throws SQLException {
        ResultSet resultSet = this.select("select context, col" + n + " from " + string);
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            try {
                String string3 = resultSet.getString(2);
                this.log.addDifference(string2, "fetch", null, string3);
            }
            catch (ConversionExceptionSapDB conversionExceptionSapDB) {
                String string4 = conversionExceptionSapDB.getMessage();
                if (string4.endsWith("from this LONG column.")) {
                    this.log.addInfo(string2, string4);
                    continue;
                }
                this.log.addFailure(new ExceptionOccurred(string2, conversionExceptionSapDB));
            }
            catch (SQLException sQLException) {
                this.log.addFailure(new ExceptionOccurred(string2, sQLException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runFetchTest(String string) throws SQLException {
        Object[] objectArray = new Object[]{Constants.firstColC};
        this.log.push("fetch Nulls");
        try {
            this.sql("delete from " + string);
            this.insertNullRow(string);
            for (int i = 0; i < this.sqlCols.length; ++i) {
                for (int j = 0; j < this.jdbcTypes.length; ++j) {
                    String string2 = this.jdbcTypes[j];
                    String string3 = this.sqlCols[i] + "|" + string2;
                    ResultSet resultSet = this.select("select col" + i + " from " + string);
                    try {
                        if (resultSet.next()) {
                            Object object = Reflector.apply(resultSet, "get" + string2, objectArray);
                            this.log.addDifference(string3, "wasNull ()", Boolean.TRUE, new Boolean(resultSet.wasNull()));
                            if (TypeEnums.isPrimitiveType(string2) || string2.equals("BigDecimal")) continue;
                            this.log.addDifference(string3, "value", null, object);
                            continue;
                        }
                        this.log.addDifference(string3, "cursor.next ()", Boolean.TRUE, Boolean.FALSE);
                        continue;
                    }
                    catch (JDBCDriverException jDBCDriverException) {
                        this.handleDriverException(string3, string2, jDBCDriverException);
                        continue;
                    }
                    catch (ConversionExceptionSapDB conversionExceptionSapDB) {
                        this.log.addInfo(string3, conversionExceptionSapDB.toString());
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.log.addInfo(string3, sQLException.toString());
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        this.log.addFailure(new ExceptionOccurred(string3, runtimeException));
                        continue;
                    }
                    finally {
                        resultSet.close();
                    }
                }
            }
        }
        finally {
            this.log.pop();
        }
    }

    protected void insertNullRow(String string) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into " + string + " (context");
        for (n = 0; n < this.sqlCols.length; ++n) {
            stringBuffer.append(", col" + n);
        }
        stringBuffer.append(") values ('all nulls'");
        for (n = 0; n < this.sqlCols.length; ++n) {
            stringBuffer.append(", NULL");
        }
        stringBuffer.append(")");
        this.sql(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        NullTest nullTest = new NullTest(stringArray);
        try {
            nullTest.runInner();
        }
        finally {
            nullTest.connection.close();
        }
        if (nullTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

