/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.jdbc.types.ConversionTest;
import com.sap.dbtechtest.jdbc.types.ConversionTestCase;
import com.sap.dbtechtest.jdbc.types.EqualityTestCase;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IntegerTest
extends ConversionTest {
    private static final String help = "help for IntegerTest";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new StringOption("sqlcol", "SQL column definition", "INTEGER", null)};
    private final ConversionTestCase[] insertTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setInsertException(JDBCDriverExceptionClass), new EqualityTestCase("BigDecimal", new BigDecimal("-999"), new Integer(-999)), new EqualityTestCase("Double", new Double("-999"), new Integer(-999)), new EqualityTestCase("Float", new Float("-999"), new Integer(-999)), new EqualityTestCase("Int", new Integer("-999"), new Integer(-999)), new EqualityTestCase("Int", new Integer(Integer.MAX_VALUE), new Integer(Integer.MAX_VALUE)), new EqualityTestCase("Int", new Integer(Integer.MIN_VALUE), new Integer(Integer.MIN_VALUE)), new EqualityTestCase("Long", new Long("-999"), new Integer(-999)), new EqualityTestCase("Object", new Integer("-999"), new Integer(-999)), new EqualityTestCase("Object", new Integer(Integer.MAX_VALUE), new Integer(Integer.MAX_VALUE)), new EqualityTestCase("Object", new Integer(Integer.MIN_VALUE), new Integer(Integer.MIN_VALUE)), new EqualityTestCase("Ref", null).setInsertException(JDBCDriverExceptionClass), new EqualityTestCase("Short", new Short("-999"), new Integer(-999)), new EqualityTestCase("Short", new Short(Short.MAX_VALUE), new Integer(Short.MAX_VALUE)), new EqualityTestCase("Short", new Short(Short.MIN_VALUE), new Integer(Short.MIN_VALUE)), new EqualityTestCase("String", "-999", new Integer(-999)), new EqualityTestCase("String", " -999", new Integer(-999))};
    private final ConversionTestCase[] fetchTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setFetchException(JDBCDriverExceptionClass), new EqualityTestCase("BigDecimal", new BigDecimal("-999"), new Integer(-999)), new EqualityTestCase("Double", new Double("-999"), new Integer(-999)), new EqualityTestCase("Float", new Float("-999"), new Integer(-999)), new EqualityTestCase("Int", new Integer("-999"), new Integer(-999)), new EqualityTestCase("Int", new Integer(Integer.MAX_VALUE), new Integer(Integer.MAX_VALUE)), new EqualityTestCase("Int", new Integer(Integer.MIN_VALUE), new Integer(Integer.MIN_VALUE)), new EqualityTestCase("Long", new Long("-999"), new Integer(-999)), new EqualityTestCase("Object", new Integer("-999"), new Integer(-999)), new EqualityTestCase("Object", new Integer(Integer.MAX_VALUE), new Integer(Integer.MAX_VALUE)), new EqualityTestCase("Object", new Integer(Integer.MIN_VALUE), new Integer(Integer.MIN_VALUE)), new EqualityTestCase("Ref", null).setFetchException(JDBCDriverExceptionClass), new EqualityTestCase("Short", new Short("-999"), new Integer(-999)), new EqualityTestCase("Short", new Short(Short.MAX_VALUE), new Integer(Short.MAX_VALUE)), new EqualityTestCase("Short", new Short(Short.MIN_VALUE), new Integer(Short.MIN_VALUE)), new EqualityTestCase("String", "-999", new String("-999"))};

    public IntegerTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public IntegerTest(Test test) throws SQLException {
        super(test);
        this.options.addExtraOptions(optdesc);
    }

    protected ConversionTestCase[] getInputTestCases() {
        return this.insertTests;
    }

    protected ConversionTestCase[] getFetchTestCases() {
        return this.fetchTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        IntegerTest integerTest = new IntegerTest(stringArray);
        try {
            integerTest.runInner();
        }
        finally {
            integerTest.connection.close();
        }
        if (integerTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

