/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobLengthTest
extends Test {
    private static final String help = "Test for stream handling.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BlobLengthTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BlobLengthTest(Test test) throws SQLException {
        super(test);
    }

    private byte[] makeBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(i % 10 + 48);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRun() throws SQLException {
        try {
            String string = this.getUnicodeIdentifier("TEST_BLOBLENGTH");
            this.connection.setAutoCommit(true);
            this.dropTable(string);
            this.stmt.execute("CREATE TABLE " + string + " (K INTEGER, V LONG BYTE)");
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string + " VALUES (?, ?)");
            preparedStatement.setInt(1, 1);
            preparedStatement.setBytes(2, this.makeBytes(1000));
            preparedStatement.execute();
            PreparedStatement preparedStatement2 = this.connection.prepareStatement("SELECT V FROM " + string + " WHERE K=?");
            preparedStatement2.setInt(1, 1);
            ResultSet resultSet = preparedStatement2.executeQuery();
            resultSet.next();
            Blob blob = resultSet.getBlob(1);
            try {
                byte[] byArray = new byte[127];
                InputStream inputStream = blob.getBinaryStream();
                while (inputStream.read(byArray) == 127) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            blob.length();
        }
        finally {
            this.connection.setAutoCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BlobLengthTest blobLengthTest = new BlobLengthTest(stringArray);
        try {
            blobLengthTest.runInner();
        }
        finally {
            blobLengthTest.connection.close();
        }
        if (blobLengthTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

