/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobFromCharByte
extends Test {
    private static final String help = "help for BlobFromCharByte";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private String context = "BlobFromCharByte";

    public BlobFromCharByte(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BlobFromCharByte(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = this.getUnicodeIdentifier(this.context);
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + " (a varchar(100) byte, b varchar(100))");
        String string2 = this.makeRandomString(50);
        byte[] byArray = string2.getBytes();
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into " + string + " values (?,?)");
        preparedStatement.setBytes(1, byArray);
        preparedStatement.setString(2, string2);
        preparedStatement.execute();
        ResultSet resultSet = this.stmt.executeQuery("select * from " + string);
        this.log.addDifference(this.context, "Check Fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        byte[] byArray2 = resultSet.getBytes(1);
        int n = byArray2.length - 1;
        while (byArray2[n] == 0) {
            --n;
        }
        byte[] byArray3 = new byte[++n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        this.log.addDifference(this.context, "check array size", new Long(byArray.length), new Long(byArray3.length));
        this.log.addDifference(this.context, "check array", byArray, byArray3);
        Blob blob = resultSet.getBlob(1);
        this.checkResult(byArray, blob.getBytes(1L, (int)blob.length()), 0);
        this.checkResult(byArray, blob.getBytes(10L, (int)blob.length() - 9), 9);
        this.checkResult(byArray, blob.getBytes(50L, 1), 49);
        InputStream inputStream = blob.getBinaryStream();
        byte[] byArray4 = new byte[(int)blob.length()];
        try {
            while (inputStream.read(byArray4) > -1) {
            }
        }
        catch (IOException iOException) {
            this.log.addFailure(new Failure(iOException.toString()));
        }
        this.checkResult(byArray, byArray4, 0);
        Clob clob = resultSet.getClob(2);
        inputStream = clob.getAsciiStream();
        byArray4 = new byte[(int)clob.length()];
        try {
            while (inputStream.read(byArray4) > -1) {
            }
        }
        catch (IOException iOException) {
            this.log.addFailure(new Failure(iOException.toString()));
        }
        this.checkResult(string2.getBytes(), byArray4, 0);
        Reader reader = clob.getCharacterStream();
        char[] cArray = new char[(int)clob.length()];
        try {
            while (reader.read(cArray) > -1) {
            }
        }
        catch (IOException iOException) {
            this.log.addFailure(new Failure(iOException.toString()));
        }
        this.checkResult(string2.getBytes(), new String(cArray).getBytes(), 0);
        this.checkResult(byArray, clob.getSubString(1L, (int)clob.length()).getBytes(), 0);
        this.checkResult(byArray, clob.getSubString(50L, 1).getBytes(), 49);
        this.checkResult(byArray, clob.getSubString(40L, 11).getBytes(), 39);
    }

    private void checkResult(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray2.length - 1;
        while (byArray2[n2] == 0) {
            --n2;
        }
        byte[] byArray3 = new byte[++n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        byte[] byArray4 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray4, 0, byArray.length - n);
        this.log.addDifference(this.context, "check size", new Long(byArray4.length), new Long(byArray3.length));
        this.log.addDifference(this.context, "check binary result value", byArray4, byArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BlobFromCharByte blobFromCharByte = new BlobFromCharByte(stringArray);
        try {
            blobFromCharByte.runInner();
        }
        finally {
            blobFromCharByte.connection.close();
        }
        if (blobFromCharByte.log.hasErrors()) {
            System.exit(5);
        }
    }
}

