/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.generators.AsciiStream;
import com.sap.dbtechtest.jdbc.types.TypeDefinition;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class BasicTypeHandling
extends Test {
    private final TypeDefinition[] types = new TypeDefinition[]{new TypeDefinition("AsciiStream", "LONG ASCII", new AsciiStream(100L)), new TypeDefinition("BigDecimal", "FLOAT", new BigDecimal("1.1")), new TypeDefinition("BinaryStream", "LONG BYTE", new AsciiStream(100L)), new TypeDefinition("Boolean", "BOOLEAN", new Object[]{Boolean.TRUE, Boolean.FALSE}), new TypeDefinition("Byte", "INT", new Byte(1)), new TypeDefinition("Bytes", "CHAR (20) BYTE", (Object)new byte[]{1, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), new TypeDefinition("Date", "DATE", new Date(100, 0, 1)), new TypeDefinition("Double", "FLOAT", new Double(1.1)), new TypeDefinition("Float", "FLOAT", new Float(1.1)), new TypeDefinition("Int", "INT", new Integer(20)), new TypeDefinition("Long", "FIXED", new Long(1L)), new TypeDefinition("Short", "INT", new Short(1)), new TypeDefinition("String", "VARCHAR (20)", "hello"), new TypeDefinition("Time", "TIME", new Time(0, 0, 0)), new TypeDefinition("Timestamp", "TIMESTAMP", new Timestamp(100, 0, 1, 0, 0, 0, 0))};
    private static final String help = "help for BasicTypeHandling";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BasicTypeHandling(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BasicTypeHandling(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "BasicTypeHandling";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute(TypeDefinition.createTableString(string2, this.types));
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i].runSimpleTest(this.connection, string2, this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BasicTypeHandling basicTypeHandling = new BasicTypeHandling(stringArray);
        try {
            basicTypeHandling.runInner();
        }
        finally {
            basicTypeHandling.connection.close();
        }
        if (basicTypeHandling.log.hasErrors()) {
            System.exit(5);
        }
    }
}

