/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.savepoint;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class SavepointSequence
extends Test {
    private static final String help = "help for SavepointSequence";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public SavepointSequence(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SavepointSequence(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        Statement statement;
        block3: {
            this.connection.setAutoCommit(false);
            statement = this.connection.createStatement();
            try {
                statement.execute("RELEASE SAVEPOINT UNKNOWN");
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != -3005) break block3;
                System.out.println("NOT SUPPORTED BY KERNEL");
                return;
            }
        }
        for (int i = 0; i < 150; ++i) {
            System.out.println("SAVEPOINT " + i);
            Savepoint savepoint = this.connection.setSavepoint();
            statement.execute("SELECT 1 FROM DUAL");
            this.connection.releaseSavepoint(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SavepointSequence savepointSequence = new SavepointSequence(stringArray);
        try {
            savepointSequence.runInner();
        }
        finally {
            savepointSequence.connection.close();
        }
        if (savepointSequence.log.hasErrors()) {
            System.exit(5);
        }
    }
}

