/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class FetchTypes
extends Test {
    private static final String help = "help for FetchTypes";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private String tableName = "";

    public FetchTypes(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public FetchTypes(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = "FetchTypes";
        this.tableName = this.getUnicodeIdentifier(string);
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + " (a int)");
        int[] nArray = new int[]{100, 100, 100};
        for (int i = 0; i < nArray.length; ++i) {
            this.insertRows(nArray[i]);
            this.beforeFirst(nArray[i]);
            this.afterLast(nArray[i]);
            this.fetchforward(nArray[i]);
            this.fetchbackward(nArray[i]);
            this.fetchAbsolute(nArray[i], true);
            this.fetchAbsolute(nArray[i], false);
            this.fetchRelative(nArray[i]);
        }
    }

    private void insertRows(int n) throws SQLException {
        this.stmt.executeUpdate("delete from " + this.tableName);
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + this.tableName + " values (?)");
        for (int i = 1; i <= n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
    }

    private void beforeFirst(int n) throws SQLException {
        String string = "beforeFirst " + n;
        Statement statement = this.connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("Select A from " + this.tableName + " order by a");
        resultSet.last();
        resultSet.beforeFirst();
        this.log.addDifference(string, "check getRow", new Integer(0), new Integer(resultSet.getRow()));
        boolean bl = resultSet.next();
        if (n != 0) {
            this.log.addDifference(string, "check rs2.next()", Boolean.TRUE, new Boolean(bl));
            this.log.addDifference(string, "check result value", new Integer(1), new Integer(resultSet.getRow()));
        } else {
            this.log.addDifference(string, "check rs2.next()", Boolean.FALSE, new Boolean(bl));
            this.log.addDifference(string, "check result value", new Integer(0), new Integer(resultSet.getRow()));
        }
        resultSet.close();
    }

    private void afterLast(int n) throws SQLException {
        String string = "afterLast " + n;
        Statement statement = this.connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("Select A from " + this.tableName + " order by a");
        resultSet.next();
        resultSet.afterLast();
        this.log.addDifference(string, "check getRow", new Integer(0), new Integer(resultSet.getRow()));
        boolean bl = resultSet.previous();
        if (n != 0) {
            this.log.addDifference(string, "check rs2.next()", Boolean.TRUE, new Boolean(bl));
            this.log.addDifference(string, "check result value", new Integer(n), new Integer(resultSet.getRow()));
        } else {
            this.log.addDifference(string, "check rs2.previous()", Boolean.FALSE, new Boolean(bl));
            this.log.addDifference(string, "check result value", new Integer(0), new Integer(resultSet.getRow()));
        }
        resultSet.close();
    }

    private void fetchforward(int n) throws SQLException {
        Statement statement = this.connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("Select A from " + this.tableName + " order by a");
        int n2 = 0;
        while (resultSet.next()) {
            this.log.addDifference("fetchforward Rows: " + n, "check forward", new Integer(++n2), new Integer(resultSet.getInt(1)));
        }
        this.log.addDifference("fetchforward Rows: " + n, "check RowCount", new Integer(n), new Integer(n2));
        this.log.addDifference("fetchforward Rows: " + n, "check getRow", new Integer(0), new Integer(resultSet.getRow()));
        resultSet.close();
    }

    private void fetchbackward(int n) throws SQLException {
        Statement statement = this.connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("Select A from " + this.tableName + " order by a");
        int n2 = 0;
        if (resultSet.last()) {
            ++n2;
        }
        while (resultSet.previous()) {
            this.log.addDifference("fetchbackward Rows: " + n, "check backward", new Integer(n - n2++), new Integer(resultSet.getInt(1)));
        }
        this.log.addDifference("fetchbackward Rows: " + n, "check RowCount", new Integer(n), new Integer(n2));
        this.log.addDifference("fetchbackward Rows: " + n, "check getRow", new Integer(0), new Integer(resultSet.getRow()));
        resultSet.close();
    }

    private void fetchAbsolute(int n, boolean bl) throws SQLException {
        int n2;
        String string = "fetchAbsolute" + (bl ? " forward " : " backward ") + " " + n;
        int n3 = bl ? 1 : -1;
        int n4 = bl ? 0 : n + 1;
        Statement statement = this.connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("Select A from " + this.tableName + " order by a");
        int[] nArray = new int[5];
        int n5 = n / 6;
        for (n2 = 1; n2 <= 5; ++n2) {
            nArray[n2 - 1] = n3 * n2 * n5;
        }
        if (n != 0) {
            resultSet.absolute(n);
            this.log.addDifference(string, "check absolute(insertedRows)", new Integer(n), new Integer(resultSet.getInt(1)));
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == 0) {
                try {
                    resultSet.absolute(nArray[n2]);
                    this.log.addFailure(new Failure(string, "SQLException \"row number is null not occured\""));
                }
                catch (SQLException sQLException) {}
                continue;
            }
            resultSet.absolute(nArray[n2]);
            this.log.addDifference(string, "check result value", new Integer(n4 + nArray[n2]), new Integer(resultSet.getInt(1)));
        }
        n2 = nArray[nArray.length - 1] == 0 ? 0 : n4 + nArray[nArray.length - 1];
        this.log.addDifference(string, "check getRow", new Integer(n2), new Integer(resultSet.getRow()));
        if (n != 0) {
            resultSet.absolute(2 * n + 1);
            if (!resultSet.isAfterLast()) {
                System.err.println("NOT AFTER LAST");
                this.log.addFailure(new Failure(string, "cursor is not before first"));
            }
            this.log.addDifference(string, "check out of range getRow", new Integer(0), new Integer(resultSet.getRow()));
            resultSet.previous();
            this.log.addDifference(string, "check out of range result value", new Integer(n), new Integer(resultSet.getInt(1)));
            this.log.addDifference(string, "check out of range result value", new Integer(n), new Integer(resultSet.getRow()));
            resultSet.absolute(-2 * n + 1);
            if (!resultSet.isBeforeFirst()) {
                System.err.println("NOT BEFORE FIRST");
                this.log.addFailure(new Failure(string, "cursor is not before first!"));
            }
            this.log.addDifference(string, "check out of range getRow", new Integer(0), new Integer(resultSet.getRow()));
            resultSet.next();
            this.log.addDifference(string, "check out of range result value", new Integer(1), new Integer(resultSet.getInt(1)));
            this.log.addDifference(string, "check out of range result value", new Integer(1), new Integer(resultSet.getRow()));
        }
        resultSet.close();
    }

    private void fetchRelative(int n) throws SQLException {
        int n2;
        String string = "fetchRelative " + n;
        int n3 = n / 6;
        int n4 = 0;
        Statement statement = this.connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("Select A from " + this.tableName + " order by a");
        if (n == 0) {
            resultSet.relative(0);
            return;
        }
        try {
            resultSet.relative(1);
            this.log.addFailure(new Failure(string, "SQLException \"no current row\""));
        }
        catch (SQLException sQLException) {
            resultSet.next();
            ++n4;
        }
        for (n2 = 1; n2 <= 5; ++n2) {
            resultSet.relative(n3);
            this.log.addDifference(string, "forward check result value", new Integer(n4 += n3), new Integer(resultSet.getInt(1)));
            this.log.addDifference(string, "forward check getRow", new Integer(n4), new Integer(resultSet.getRow()));
        }
        for (n2 = 1; n2 <= 5; ++n2) {
            resultSet.relative(-n3);
            this.log.addDifference(string, "backward check result value", new Integer(n4 -= n3), new Integer(resultSet.getInt(1)));
            this.log.addDifference(string, "backward check getRow", new Integer(n4), new Integer(resultSet.getRow()));
        }
        if (n != 0) {
            resultSet.first();
            resultSet.relative(2 * n + 1);
            this.log.addDifference(string, "check out of range getRow", new Integer(0), new Integer(resultSet.getRow()));
            resultSet.previous();
            this.log.addDifference(string, "check out of range result value", new Integer(n), new Integer(resultSet.getInt(1)));
            this.log.addDifference(string, "check out of range result value", new Integer(n), new Integer(resultSet.getRow()));
            resultSet.relative(-2 * n + 1);
            this.log.addDifference(string, "check out of range getRow", new Integer(0), new Integer(resultSet.getRow()));
        }
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        FetchTypes fetchTypes = new FetchTypes(stringArray);
        try {
            fetchTypes.runInner();
        }
        finally {
            fetchTypes.connection.close();
        }
        if (fetchTypes.log.hasErrors()) {
            System.exit(5);
        }
    }
}

