/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CloseOnCloseStatement
extends Test {
    private static final String help = "help for CloseOnCloseStatement";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public CloseOnCloseStatement(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public CloseOnCloseStatement(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "CloseOnCloseStatement";
        this.log.addInfo(string, "Testing the access of a closed resultset");
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from dual");
        statement.close();
        try {
            resultSet.next();
            this.log.addFailure(new Failure("rs.next", "expected com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException not occured"));
        }
        catch (ObjectIsClosedException objectIsClosedException) {
            // empty catch block
        }
        try {
            resultSet.getString(1);
            this.log.addFailure(new Failure("rs.getString", "expected com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException not occured"));
        }
        catch (ObjectIsClosedException objectIsClosedException) {
            // empty catch block
        }
        resultSet.close();
        PreparedStatement preparedStatement = this.connection.prepareStatement("select * from dual", 1003, 1008);
        resultSet = preparedStatement.executeQuery();
        preparedStatement.close();
        try {
            resultSet.next();
            this.log.addFailure(new Failure("rs.next", "expected com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException not occured"));
        }
        catch (ObjectIsClosedException objectIsClosedException) {
            // empty catch block
        }
        try {
            resultSet.getString(1);
            this.log.addFailure(new Failure("rs.getString", "expected com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException not occured"));
        }
        catch (ObjectIsClosedException objectIsClosedException) {
            // empty catch block
        }
        try {
            resultSet.updateString(1, "Hallo");
            this.log.addFailure(new Failure("rs.updateString", "expected com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException not occured"));
        }
        catch (ObjectIsClosedException objectIsClosedException) {
            // empty catch block
        }
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        CloseOnCloseStatement closeOnCloseStatement = new CloseOnCloseStatement(stringArray);
        try {
            closeOnCloseStatement.runInner();
        }
        finally {
            closeOnCloseStatement.connection.close();
        }
        if (closeOnCloseStatement.log.hasErrors()) {
            System.exit(5);
        }
    }
}

