/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class VariableInputBatchTest
extends Test {
    private static final String help = "help for VariableInputBatchTest";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public VariableInputBatchTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public VariableInputBatchTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        String string = "VariableInputBatchTest";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a varchar(100), b varchar(100), c long)");
        int n2 = 0;
        try {
            n2 = this.getDBParameterAsInt("PACKET_SIZE") + 1;
        }
        catch (SQLException sQLException) {
            n2 = this.getDBParameterAsInt("_PACKET_SIZE") + 1;
        }
        int n3 = n2 / 200;
        String string3 = this.makeRandomString(100);
        String string4 = this.makeRandomString(n2);
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + string2 + " values (?,?, NULL)");
        for (int i = 0; i < n3; ++i) {
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string3);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        ResultSet resultSet = this.stmt.executeQuery("Select a,b from " + string2);
        for (n = 0; n < n3; ++n) {
            if (!resultSet.next()) {
                this.log.addFailure(new Failure(string, "Fetch next failed"));
                break;
            }
            this.log.addDifference(string, "Check result row " + n3 + " col " + 1, string3, resultSet.getString(1));
            this.log.addDifference(string, "Check result row " + n3 + " col " + 2, string3, resultSet.getString(2));
        }
        this.log.addDifference(string, "Check rowcnt", Boolean.FALSE, new Boolean(resultSet.next()));
        this.stmt.execute("Delete from " + string2);
        n3 = 10;
        preparedStatement = this.connection.prepareStatement("insert into " + string2 + " values (?,?,?)");
        for (n = 0; n < n3; ++n) {
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string3);
            preparedStatement.setString(3, string4);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        resultSet = this.stmt.executeQuery("Select a,b,c from " + string2);
        for (n = 0; n < n3; ++n) {
            if (!resultSet.next()) {
                this.log.addFailure(new Failure(string, "Fetch next failed"));
                break;
            }
            this.log.addDifference(string, "Check result row " + n3 + " col " + 1, string3, resultSet.getString(1));
            this.log.addDifference(string, "Check result row " + n3 + " col " + 2, string3, resultSet.getString(2));
            this.log.addDifference(string, "Check result row " + n3 + " col " + 3, string4, resultSet.getString(3));
        }
        this.log.addDifference(string, "Check rowcnt", Boolean.FALSE, new Boolean(resultSet.next()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        VariableInputBatchTest variableInputBatchTest = new VariableInputBatchTest(stringArray);
        try {
            variableInputBatchTest.runInner();
        }
        finally {
            variableInputBatchTest.connection.close();
        }
        if (variableInputBatchTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

