/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;

public class StatementMetaData
extends Test {
    private static final String help = "This test tests whether metadata is available after prepare.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private static final boolean debug = true;

    public StatementMetaData(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public StatementMetaData(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        try {
            Wrapper wrapper;
            Wrapper wrapper2;
            Wrapper wrapper3;
            PreparedStatement preparedStatement;
            String string = this.getUnicodeIdentifier("StatementMetaData");
            this.dropTable(string);
            this.stmt.execute("CREATE TABLE " + string + " (A INTEGER, B VARCHAR(20), C FIXED(5,2))");
            this.stmt.execute("INSERT INTO " + string + " VALUES (1, 'hello', 42.42)");
            if (this.isVersion("7.3.0") || this.checkVersion("7.4.3")) {
                try {
                    this.stmt.execute("DROP DBPROC " + string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.stmt.execute("CREATE DBPROC " + string + "(IN NUMVAL INTEGER) RETURNS CURSOR " + "AS " + "BEGIN " + "  IF NUMVAL=1 THEN " + "    DECLARE :$CURSOR CURSOR FOR SELECT A, B, C FROM " + this.getUsername() + "." + string + " " + "  ELSE " + "    DECLARE :$CURSOR CURSOR FOR SELECT 42 FROM SYSDBA.DUAL; " + "END;");
                preparedStatement = this.connection.prepareCall("CALL " + string + "(?)");
                wrapper3 = preparedStatement.getMetaData();
                if (wrapper3 != null) {
                    this.log.addFailure(new Failure("StatementMetaData.dbproc", "metadata shall not be there after prepare"));
                }
                preparedStatement.setInt(1, 1);
                wrapper2 = preparedStatement.executeQuery();
                wrapper = preparedStatement.getMetaData();
                this.checkMetaData("dbproc", (ResultSetMetaData)wrapper);
                preparedStatement.close();
            }
            this.log.addInfo("StatementMetaData check preparation of PING");
            preparedStatement = this.prepare("PING");
            preparedStatement.execute();
            wrapper3 = this.prepare("SELECT A,B,C FROM " + string);
            wrapper2 = wrapper3.getMetaData();
            if (wrapper2 != null) {
                this.log.addInfo("StatementMetaData.prepare", "all metadata available after prepare");
                this.checkMetaData("prepare", (ResultSetMetaData)wrapper2);
            } else {
                this.log.addInfo("StatementMetaData.prepare", "no metadata available after prepare");
            }
            wrapper = wrapper3.executeQuery();
            ResultSetMetaData resultSetMetaData = wrapper3.getMetaData();
            this.checkMetaData("execute", resultSetMetaData);
            this.dropTable(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    private void checkMetaData(String string, ResultSetMetaData resultSetMetaData) throws SQLException {
        if (resultSetMetaData.getColumnCount() != 3) {
            this.log.addFailure(new Failure(string, "column count != 3"));
        }
        if (!resultSetMetaData.getColumnName(1).equals("A")) {
            this.log.addFailure(new Failure(string, "column name (1) != A"));
        }
        if (!resultSetMetaData.getColumnName(2).equals("B")) {
            this.log.addFailure(new Failure(string, "column name (2) != B"));
        }
        if (!resultSetMetaData.getColumnName(3).equals("C")) {
            this.log.addFailure(new Failure(string, "column name (3) != C"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        StatementMetaData statementMetaData = new StatementMetaData(stringArray);
        try {
            statementMetaData.runInner();
        }
        finally {
            statementMetaData.connection.close();
        }
        if (statementMetaData.log.hasErrors()) {
            System.exit(5);
        }
    }
}

