/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.ecperf;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimePerformance
extends Test {
    private static final String help = "help for TimePerformance";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public TimePerformance(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public TimePerformance(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        Date date;
        Time time;
        int n = 100000;
        Calendar calendar = Calendar.getInstance();
        String string = "TimePerformance";
        this.dropTable("TimePerformance");
        this.stmt.execute("CREATE TABLE TimePerformance (  o_id\t\tinteger key ,o_entry_date\ttimestamp ,o_ship_date\t        timestamp ,o_entry_date1\ttime ,o_ship_date1\ttime ,o_entry_date2\tdate ,o_ship_date2\tdate )");
        this.connection.commit();
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into TimePerformance values (?,?,?,?,?,?,?)");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        long l = System.currentTimeMillis();
        for (int i = 1; i <= n; ++i) {
            time = new Time(i * 10000);
            date = new Date(i * 100000000);
            preparedStatement.setInt(1, i);
            preparedStatement.setTimestamp(2, timestamp);
            preparedStatement.setTimestamp(3, timestamp);
            preparedStatement.setTime(4, time);
            preparedStatement.setTime(5, time);
            preparedStatement.setDate(6, date);
            preparedStatement.setDate(7, date);
            preparedStatement.addBatch();
        }
        System.out.println("INSERT of " + n + " rows needs " + (System.currentTimeMillis() - l) + " milli sec.");
        preparedStatement.executeBatch();
        ResultSet resultSet = this.stmt.executeQuery("Select * from TimePerformance");
        l = System.currentTimeMillis();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            Timestamp timestamp2 = resultSet.getTimestamp(2);
            Timestamp timestamp3 = resultSet.getTimestamp(3);
        }
        System.out.println("SELECT of " + n + " rows needs " + (System.currentTimeMillis() - l) + " milli sec.");
        resultSet.close();
        ResultSet resultSet2 = this.stmt.executeQuery("Select * from TimePerformance");
        int n3 = 1;
        int n4 = 1;
        while (resultSet2.next()) {
            this.log.addDifference(string, "Check result", timestamp, resultSet2.getTimestamp(2, calendar));
            this.log.addDifference(string, "Check result", timestamp, resultSet2.getTimestamp(3, calendar));
            time = new Time(n3++ * 10000);
            this.log.addDifference(string, "Check result", time, resultSet2.getTime(4));
            this.log.addDifference(string, "Check result", time, resultSet2.getTime(5));
            date = new Date(n4++ * 100000000);
            this.log.addDifference(string, "Check result", date.toString(), resultSet2.getString(6));
            this.log.addDifference(string, "Check result", date.toString(), resultSet2.getString(7));
        }
        resultSet2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        TimePerformance timePerformance = new TimePerformance(stringArray);
        try {
            timePerformance.runInner();
        }
        finally {
            timePerformance.connection.close();
        }
        if (timePerformance.log.hasErrors()) {
            System.exit(5);
        }
    }
}

