/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.connection;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.trace.Connection;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CacheStats
extends Test {
    private static final String help = "help for CacheStats";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public CacheStats(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public CacheStats(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "CacheStats";
        this.dropTable("CacheStats");
        this.stmt.execute("CREATE TABLE CacheStats (a int)");
        String string2 = "Insert into CacheStats values (?)";
        for (int i = 0; i < 100; ++i) {
            PreparedStatement preparedStatement = this.prepare(string2);
        }
        String string3 = this.statsToString();
        this.log.addInfo(string, string3);
    }

    protected String statsToString() {
        ConnectionSapDB connectionSapDB;
        try {
            connectionSapDB = (ConnectionSapDB)this.connection;
        }
        catch (ClassCastException classCastException) {
            try {
                connectionSapDB = (ConnectionSapDB)((Connection)this.connection).getInner();
            }
            catch (ClassCastException classCastException2) {
                return "";
            }
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        connectionSapDB.printCacheStats(printWriter);
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        stringArray = Test.addOptions(stringArray, new String[]{"-P:cache=all?"});
        CacheStats cacheStats = new CacheStats(stringArray);
        try {
            cacheStats.runInner();
        }
        finally {
            cacheStats.connection.close();
        }
        if (cacheStats.log.hasErrors()) {
            System.exit(5);
        }
    }
}

