/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.objects.Comparator;
import org.apache.xpath.objects.EqualComparator;
import org.apache.xpath.objects.GreaterThanComparator;
import org.apache.xpath.objects.GreaterThanOrEqualComparator;
import org.apache.xpath.objects.LessThanComparator;
import org.apache.xpath.objects.LessThanOrEqualComparator;
import org.apache.xpath.objects.NotEqualComparator;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public class XNodeSet
extends XObject {
    static LessThanComparator S_LT = new LessThanComparator();
    static LessThanOrEqualComparator S_LTE = new LessThanOrEqualComparator();
    static GreaterThanComparator S_GT = new GreaterThanComparator();
    static GreaterThanOrEqualComparator S_GTE = new GreaterThanOrEqualComparator();
    static EqualComparator S_EQ = new EqualComparator();
    static NotEqualComparator S_NEQ = new NotEqualComparator();

    public XNodeSet() {
        super(new NodeSet());
    }

    public XNodeSet(Node n2) {
        super(new NodeSet());
        if (n2 != null) {
            ((NodeSet)this.m_obj).addNode(n2);
        }
    }

    public XNodeSet(NodeIterator val) {
        super(val);
    }

    public boolean bool() {
        return this.nodeset().nextNode() != null;
    }

    public boolean compare(XObject obj2, Comparator comparator) throws TransformerException {
        boolean result = false;
        int type = obj2.getType();
        if (type == 4) {
            Node node1;
            NodeIterator list1 = this.nodeset();
            NodeIterator list2 = ((XNodeSet)obj2).nodeset();
            StringVector node2Strings = null;
            block0: while ((node1 = list1.nextNode()) != null) {
                String s1 = XNodeSet.getStringFromNode(node1);
                if (node2Strings == null) {
                    Node node2;
                    while ((node2 = list2.nextNode()) != null) {
                        String s2 = XNodeSet.getStringFromNode(node2);
                        if (comparator.compareStrings(s1, s2)) {
                            result = true;
                            continue block0;
                        }
                        if (node2Strings == null) {
                            node2Strings = new StringVector();
                        }
                        node2Strings.addElement(s2);
                    }
                    continue;
                }
                int n2 = node2Strings.size();
                int i2 = 0;
                while (i2 < n2) {
                    if (comparator.compareStrings(s1, node2Strings.elementAt(i2))) {
                        result = true;
                        continue block0;
                    }
                    ++i2;
                }
            }
        } else if (type == 1) {
            double num1 = this.bool() ? 1.0 : 0.0;
            double num2 = obj2.num();
            result = comparator.compareNumbers(num1, num2);
        } else if (type == 2) {
            Node node;
            NodeIterator list1 = this.nodeset();
            double num2 = obj2.num();
            while ((node = list1.nextNode()) != null) {
                double num1 = XNodeSet.getNumberFromNode(node);
                if (!comparator.compareNumbers(num1, num2)) continue;
                result = true;
                break;
            }
        } else if (type == 5) {
            double num2 = obj2.num();
            if (!Double.isNaN(num2)) {
                Node node;
                NodeIterator list1 = this.nodeset();
                while ((node = list1.nextNode()) != null) {
                    double num1 = XNodeSet.getNumberFromNode(node);
                    if (!comparator.compareNumbers(num1, num2)) continue;
                    result = true;
                    break;
                }
            } else {
                Node node;
                String s2 = obj2.str();
                NodeIterator list1 = this.nodeset();
                while ((node = list1.nextNode()) != null) {
                    String s1 = XNodeSet.getStringFromNode(node);
                    if (!comparator.compareStrings(s1, s2)) continue;
                    result = true;
                    break;
                }
            }
        } else if (type == 3) {
            Node node;
            String s2 = obj2.str();
            NodeIterator list1 = this.nodeset();
            while ((node = list1.nextNode()) != null) {
                String s1 = XNodeSet.getStringFromNode(node);
                if (!comparator.compareStrings(s1, s2)) continue;
                result = true;
                break;
            }
        } else {
            result = comparator.compareNumbers(this.num(), obj2.num());
        }
        return result;
    }

    public boolean equals(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_EQ);
    }

    public static double getNumberFromNode(Node n2) {
        return XString.castToNum(XNodeSet.getStringFromNode(n2));
    }

    public static String getStringFromNode(Node n2) {
        switch (n2.getNodeType()) {
            case 1: 
            case 9: {
                return DOMHelper.getNodeData(n2);
            }
            case 3: 
            case 4: {
                return ((Text)n2).getData();
            }
            case 2: 
            case 7: 
            case 8: {
                return n2.getNodeValue();
            }
        }
        return DOMHelper.getNodeData(n2);
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "#NODESET";
    }

    public boolean greaterThan(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_GT);
    }

    public boolean greaterThanOrEqual(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_GTE);
    }

    public boolean lessThan(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_LT);
    }

    public boolean lessThanOrEqual(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_LTE);
    }

    public NodeSet mutableNodeset() {
        NodeSet mnl;
        if (this.m_obj instanceof NodeSet) {
            mnl = (NodeSet)this.m_obj;
        } else {
            mnl = new NodeSet(this.nodeset());
            this.m_obj = mnl;
        }
        return mnl;
    }

    public NodeIterator nodeset() {
        NodeIterator ns = (NodeIterator)this.m_obj;
        if (ns instanceof ContextNodeList) {
            if (((ContextNodeList)((Object)ns)).isFresh()) {
                return ns;
            }
            try {
                return ((ContextNodeList)((Object)ns)).cloneWithReset();
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.getMessage());
            }
        }
        return ns;
    }

    public boolean notEquals(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_NEQ);
    }

    public double num() {
        NodeIterator nl = this.nodeset();
        Node node = nl.nextNode();
        return node != null ? XNodeSet.getNumberFromNode(node) : Double.NaN;
    }

    public DocumentFragment rtree(XPathContext support) {
        Node node;
        DocumentFragment frag = support.getDOMHelper().getDOMFactory().createDocumentFragment();
        NodeIterator nl = this.nodeset();
        while ((node = nl.nextNode()) != null) {
            frag.appendChild(node.cloneNode(true));
        }
        return frag;
    }

    public String str() {
        NodeIterator nl = this.nodeset();
        Node node = nl.nextNode();
        return node != null ? XNodeSet.getStringFromNode(node) : "";
    }
}

