/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;

public class FuncSubstring
extends Function3Args {
    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
        if (argNum < 2) {
            throw new WrongNumberArgsException("2 or 3");
        }
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        String substr;
        int startIndex;
        String s1 = this.m_arg0.execute(xctxt).str();
        double start = this.m_arg1.execute(xctxt).num();
        int lenOfS1 = s1.length();
        if (lenOfS1 <= 0) {
            return XString.EMPTYSTRING;
        }
        if (Double.isNaN(start)) {
            start = -1000000.0;
            startIndex = 0;
        } else {
            int n2 = startIndex = (start = (double)Math.round(start)) > 0.0 ? (int)start - 1 : 0;
        }
        if (this.m_arg2 != null) {
            double len = this.m_arg2.execute(xctxt).num();
            int end = (int)((double)Math.round(len) + start) - 1;
            if (end < 0) {
                end = 0;
            } else if (end > lenOfS1) {
                end = lenOfS1;
            }
            if (startIndex > lenOfS1) {
                startIndex = lenOfS1;
            }
            substr = s1.substring(startIndex, end);
        } else {
            if (startIndex > lenOfS1) {
                startIndex = lenOfS1;
            }
            substr = s1.substring(startIndex);
        }
        return new XString(substr);
    }
}

