/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xalan.stree.Child;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.w3c.dom.Node;

public abstract class PredicatedNodeTest
extends NodeTest
implements SubContextList {
    protected LocPathIterator m_lpi;
    transient int m_predicateIndex = -1;
    private Expression[] m_predicates;
    protected transient int[] m_proximityPositions;
    static final boolean DEBUG_PREDICATECOUNTING = false;

    public PredicatedNodeTest() {
    }

    public PredicatedNodeTest(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short acceptNode(Node n2) {
        XPathContext xctxt;
        block6: {
            short s2;
            xctxt = this.m_lpi.getXPathContext();
            try {
                try {
                    xctxt.pushCurrentNode(n2);
                    XObject score = this.execute(xctxt, n2);
                    if (score == NodeTest.SCORE_NONE) break block6;
                    if (this.getPredicateCount() > 0) {
                        this.countProximityPosition(0);
                        if (!this.executePredicates(n2, xctxt)) {
                            short s3 = 3;
                            Object var5_7 = null;
                            xctxt.popCurrentNode();
                            return s3;
                        }
                    }
                    s2 = 1;
                }
                catch (TransformerException se) {
                    throw new RuntimeException(se.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
            Object var5_8 = null;
            xctxt.popCurrentNode();
            return s2;
        }
        Object var5_9 = null;
        xctxt.popCurrentNode();
        return 3;
    }

    public boolean canTraverseOutsideSubtree() {
        int n2 = this.getPredicateCount();
        int i2 = 0;
        while (i2 < n2) {
            if (this.getPredicate(i2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PredicatedNodeTest clone = (PredicatedNodeTest)super.clone();
        if (this.m_proximityPositions != null && this.m_proximityPositions == clone.m_proximityPositions) {
            clone.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, clone.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        if (clone.m_lpi == this) {
            clone.m_lpi = (LocPathIterator)clone;
        }
        return clone;
    }

    protected void countProximityPosition(int i2) {
        if (i2 < this.m_proximityPositions.length) {
            int n2 = i2;
            this.m_proximityPositions[n2] = this.m_proximityPositions[n2] + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean executePredicates(Node context, XPathContext xctxt) throws TransformerException {
        PrefixResolver savedResolver;
        block13: {
            boolean bl2;
            block12: {
                this.m_predicateIndex = 0;
                int nPredicates = this.getPredicateCount();
                if (nPredicates == 0) {
                    return true;
                }
                savedResolver = xctxt.getNamespaceContext();
                try {
                    xctxt.pushSubContextList(this);
                    xctxt.setNamespaceContext(this.m_lpi.getPrefixResolver());
                    xctxt.pushCurrentNode(context);
                    int i2 = 0;
                    while (i2 < nPredicates) {
                        XObject pred;
                        int savedWaitingBottom = this.m_lpi.m_waitingBottom;
                        this.m_lpi.m_waitingBottom = this.m_lpi.getWaitingCount();
                        try {
                            pred = this.m_predicates[i2].execute(xctxt);
                        }
                        finally {
                            Object var12_10 = null;
                            this.m_lpi.m_waitingBottom = savedWaitingBottom;
                        }
                        if (pred.getType() == 2) {
                            int proxPos = this.getProximityPosition(this.m_predicateIndex);
                            if (proxPos != (int)pred.num()) {
                                boolean bl3 = false;
                                Object var7_13 = null;
                                xctxt.popCurrentNode();
                                xctxt.setNamespaceContext(savedResolver);
                                xctxt.popSubContextList();
                                return bl3;
                            }
                        } else if (!pred.bool()) {
                            bl2 = false;
                            break block12;
                        }
                        this.countProximityPosition(++this.m_predicateIndex);
                        ++i2;
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var7_16 = null;
                    xctxt.popCurrentNode();
                    xctxt.setNamespaceContext(savedResolver);
                    xctxt.popSubContextList();
                    throw throwable;
                }
            }
            Object var7_14 = null;
            xctxt.popCurrentNode();
            xctxt.setNamespaceContext(savedResolver);
            xctxt.popSubContextList();
            return bl2;
        }
        Object var7_15 = null;
        xctxt.popCurrentNode();
        xctxt.setNamespaceContext(savedResolver);
        xctxt.popSubContextList();
        this.m_predicateIndex = -1;
        return true;
    }

    public abstract int getLastPos(XPathContext var1);

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    Expression getPredicate(int index) {
        return this.m_predicates[index];
    }

    public int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    protected int getProximityPosition(int predicateIndex) {
        return predicateIndex >= 0 ? this.m_proximityPositions[predicateIndex] : 0;
    }

    public int getProximityPosition(XPathContext xctxt) {
        return this.getProximityPosition();
    }

    protected void initPredicateInfo(Compiler compiler, int opPos) throws TransformerException {
        int pos = compiler.getFirstPredicateOpPos(opPos);
        this.m_predicates = compiler.getCompiledPredicates(pos);
    }

    public void initProximityPosition(int i2) throws TransformerException {
        this.m_proximityPositions[i2] = 0;
    }

    public boolean isReverseAxes() {
        return false;
    }

    protected String nodeToString(Node n2) {
        try {
            return n2 != null ? String.valueOf(n2.getNodeName()) + "{" + ((Child)n2).getUid() + "}" : "null";
        }
        catch (ClassCastException classCastException) {
            return n2 != null ? n2.getNodeName() : "null";
        }
    }

    public void resetProximityPositions() {
        int nPredicates = this.getPredicateCount();
        if (nPredicates > 0) {
            if (this.m_proximityPositions == null) {
                this.m_proximityPositions = new int[nPredicates];
            }
            int i2 = 0;
            while (i2 < nPredicates) {
                try {
                    this.initProximityPosition(i2);
                }
                catch (Exception e10) {
                    throw new WrappedRuntimeException(e10);
                }
                ++i2;
            }
        }
    }

    public void setLocPathIterator(LocPathIterator li) {
        this.m_lpi = li;
    }

    public void setPredicateCount(int count) {
        if (count > 0) {
            Expression[] newPredicates = new Expression[count];
            int i2 = 0;
            while (i2 < count) {
                newPredicates[i2] = this.m_predicates[i2];
                ++i2;
            }
            this.m_predicates = newPredicates;
        } else {
            this.m_predicates = null;
        }
    }
}

