/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.ReverseAxesWalker;
import org.w3c.dom.Node;

public class PrecedingWalker
extends ReverseAxesWalker {
    transient Node m_doc;

    public PrecedingWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Node firstChild() {
        if (this.m_root.equals(this.m_currentNode)) {
            return null;
        }
        Node nextNode = this.m_currentNode;
        while (nextNode != null) {
            Node n2 = nextNode.getFirstChild();
            if (n2 != null) {
                nextNode = n2;
            } else if ((nextNode = nextNode.getNextSibling()) != null) {
                if (!this.m_root.equals(nextNode) && this.isAncestorOfRootContext(nextNode)) continue;
                return null;
            }
            if (nextNode == null) continue;
            if (this.m_root.equals(nextNode)) {
                return null;
            }
            if (!this.isAncestorOfRootContext(nextNode)) break;
        }
        this.m_nextLevelAmount = nextNode == null ? 0 : (nextNode.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(nextNode);
    }

    protected int getLevelMax() {
        return Short.MAX_VALUE;
    }

    public Node nextSibling() {
        if (this.m_root.equals(this.m_currentNode)) {
            return null;
        }
        Node next = this.m_currentNode.getNextSibling();
        if (next == null || this.m_root.equals(next)) {
            return null;
        }
        if (this.isAncestorOfRootContext(next) && ((next = next.getFirstChild()) == null || this.m_root.equals(next))) {
            return null;
        }
        this.m_nextLevelAmount = next == null ? 0 : (next.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(next);
    }

    public Node parentNode() {
        Node next = this.m_currentNode.getParentNode();
        if (next == null || this.m_doc.equals(next)) {
            return null;
        }
        if (this.isAncestorOfRootContext(next)) {
            return null;
        }
        this.m_nextLevelAmount = 0;
        return this.setCurrentIfNotNull(next);
    }

    public void resetProximityPositions() {
    }

    public void setRoot(Node root) {
        if (root.getNodeType() == 2) {
            root = this.m_lpi.getDOMHelper().getParentOfNode(root);
        }
        super.setRoot(root);
        this.m_currentNode = this.m_doc = this.m_lpi.getDOMHelper().getRootNode(root);
        this.m_nextLevelAmount = root.hasChildNodes() ? 1 : 0;
        super.resetProximityPositions();
    }
}

