/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xpath.SourceTree;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceTreeManager {
    private Vector m_sourceTree = new Vector();
    URIResolver m_uriResolver;

    public String findURIFromDoc(Document owner) {
        Document root = owner.getOwnerDocument();
        if (root == null) {
            root = owner;
        }
        String url = null;
        int n2 = this.m_sourceTree.size();
        int i2 = 0;
        while (i2 < n2) {
            SourceTree sTree = (SourceTree)this.m_sourceTree.elementAt(i2);
            if (root == sTree.m_root) {
                url = sTree.m_url;
                break;
            }
            ++i2;
        }
        return url;
    }

    public Node getDOMNode(Source source, SourceLocator locator) throws TransformerException {
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        Node doc = null;
        try {
            XMLReader reader = this.getXMLReader(source, locator);
            SourceTreeHandler handler = new SourceTreeHandler();
            if (handler instanceof SourceTreeHandler) {
                handler.setUseMultiThreading(false);
            }
            reader.setContentHandler(handler);
            if (handler instanceof DTDHandler) {
                reader.setDTDHandler(handler);
            }
            try {
                if (handler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                }
                if (handler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
                }
            }
            catch (SAXException sAXException) {}
            try {
                if (handler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", handler);
                }
                if (handler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/DeclHandler", handler);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            InputSource isource = SAXSource.sourceToInputSource(source);
            reader.parse(isource);
            if (handler instanceof SourceTreeHandler) {
                doc = handler.getRoot();
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), locator, ioe);
        }
        catch (SAXException se) {
            throw new TransformerException(se.getMessage(), locator, se);
        }
        return doc;
    }

    public Node getNode(Source source) {
        String url = source.getSystemId();
        if (url == null) {
            return null;
        }
        Node node = null;
        int n2 = this.m_sourceTree.size();
        int i2 = 0;
        while (i2 < n2) {
            SourceTree sTree = (SourceTree)this.m_sourceTree.elementAt(i2);
            if (url.equals(sTree.m_url)) {
                node = sTree.m_root;
                break;
            }
            ++i2;
        }
        return node;
    }

    public Node getSourceTree(String base, String urlString, SourceLocator locator) throws TransformerException {
        try {
            Source source = this.resolveURI(base, urlString, locator);
            return this.getSourceTree(source, locator);
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), locator, ioe);
        }
    }

    public Node getSourceTree(Source source, SourceLocator locator) throws TransformerException {
        Node n2 = this.getNode(source);
        if (n2 != null) {
            return n2;
        }
        n2 = this.getDOMNode(source, locator);
        if (n2 != null) {
            this.putDocumentInCache(n2, source);
        }
        return n2;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public XMLReader getXMLReader(Source inputSource, SourceLocator locator) throws TransformerException {
        try {
            XMLReader reader;
            XMLReader xMLReader = reader = inputSource instanceof SAXSource ? ((SAXSource)inputSource).getXMLReader() : null;
            if (reader == null) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex2) {
                    throw new SAXException(ex2);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
                if (reader == null) {
                    reader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException sAXException) {}
            return reader;
        }
        catch (SAXException se) {
            throw new TransformerException(se.getMessage(), locator, se);
        }
    }

    public void putDocumentInCache(Node n2, Source source) {
        Node cachedNode = this.getNode(source);
        if (cachedNode != null) {
            if (!cachedNode.equals(n2)) {
                throw new RuntimeException("Programmer's Error!  putDocumentInCache found reparse of doc: " + source.getSystemId());
            }
            return;
        }
        if (source.getSystemId() != null) {
            this.m_sourceTree.addElement(new SourceTree(n2, source.getSystemId()));
        }
    }

    public void reset() {
        this.m_sourceTree = new Vector();
    }

    public Source resolveURI(String base, String urlString, SourceLocator locator) throws TransformerException, IOException {
        Source source = null;
        if (this.m_uriResolver != null) {
            source = this.m_uriResolver.resolve(urlString, base);
        }
        if (source == null) {
            String uri = SystemIDResolver.getAbsoluteURI(urlString, base);
            source = new StreamSource(uri);
        }
        return source;
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_uriResolver = resolver;
    }
}

