/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils.synthetic.reflection;

import java.lang.reflect.Modifier;
import org.apache.xml.utils.synthetic.Class;
import org.apache.xml.utils.synthetic.SynthesisException;
import org.apache.xml.utils.synthetic.reflection.Constructor;
import org.apache.xml.utils.synthetic.reflection.Member;
import org.apache.xml.utils.synthetic.reflection.Method;

public abstract class EntryPoint
implements Member {
    protected Object realep;
    private Class declaringclass = null;
    protected Class returntype = null;
    private String[] parameternames = new String[0];
    private Class[] parametertypes = new Class[0];
    private Class[] exceptiontypes = new Class[0];
    private int modifiers;
    protected String name = null;
    private StringBuffer body = null;
    private String language = null;
    java.lang.Class[] realE;
    java.lang.Class[] realP;

    protected EntryPoint(Object ep2) throws IllegalArgumentException {
        this(ep2, null);
    }

    protected EntryPoint(Object ep2, Class declaringclass) throws IllegalArgumentException {
        this.realep = ep2;
        this.declaringclass = declaringclass;
        if (ep2 instanceof java.lang.reflect.Method) {
            java.lang.reflect.Method m2 = (java.lang.reflect.Method)ep2;
            if (declaringclass == null) {
                declaringclass = Class.forClass(m2.getDeclaringClass());
            }
            this.name = m2.getName();
            this.modifiers = m2.getModifiers();
            this.returntype = Class.forClass(m2.getReturnType());
            this.realP = m2.getParameterTypes();
            this.realE = m2.getExceptionTypes();
        } else if (ep2 instanceof java.lang.reflect.Constructor) {
            java.lang.reflect.Constructor c10 = (java.lang.reflect.Constructor)ep2;
            if (declaringclass == null) {
                declaringclass = Class.forClass(c10.getDeclaringClass());
            }
            this.name = declaringclass.getShortName();
            this.modifiers = c10.getModifiers();
            this.returntype = declaringclass;
            this.realP = c10.getParameterTypes();
            this.realE = c10.getExceptionTypes();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public EntryPoint(Class declaringclass) {
        this.declaringclass = declaringclass;
    }

    public void addExceptionType(Class exception) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        Class[] e10 = new Class[this.exceptiontypes.length + 1];
        System.arraycopy(this.exceptiontypes, 0, e10, 0, this.exceptiontypes.length);
        e10[this.exceptiontypes.length] = exception;
        this.exceptiontypes = e10;
    }

    public void addParameter(Class type, String name) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        Class[] types = new Class[this.parametertypes.length + 1];
        System.arraycopy(this.parametertypes, 0, types, 0, this.parametertypes.length);
        types[this.parametertypes.length] = type;
        this.parametertypes = types;
        String[] names = new String[this.parameternames.length + 1];
        System.arraycopy(this.parameternames, 0, names, 0, this.parameternames.length);
        names[this.parameternames.length] = name;
        this.parameternames = names;
    }

    public boolean equals(Object obj) {
        EntryPoint otherep = null;
        if (obj instanceof EntryPoint) {
            otherep = (EntryPoint)obj;
        } else if (obj instanceof java.lang.reflect.Constructor || obj instanceof java.lang.reflect.Method) {
            otherep = (EntryPoint)obj;
        }
        return otherep != null && (this instanceof Constructor && otherep instanceof Constructor || this instanceof Method && otherep instanceof Method && this.getName().equals(otherep.getName())) && otherep.getDeclaringClass().equals(this.declaringclass) && otherep.getParameterTypes().equals(this.parametertypes);
    }

    public StringBuffer getBody() {
        if (this.body == null) {
            this.body = new StringBuffer();
        }
        return this.body;
    }

    public Class getDeclaringClass() {
        return this.declaringclass;
    }

    public Class[] getExceptionTypes() {
        if (this.realep != null && this.exceptiontypes == null) {
            this.exceptiontypes = new Class[this.realE.length];
            int i2 = 0;
            while (i2 < this.realE.length) {
                this.exceptiontypes[i2] = Class.forClass(this.realE[i2]);
                ++i2;
            }
            this.realE = null;
        }
        return this.exceptiontypes;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        if (this instanceof Constructor) {
            return this.declaringclass.getShortName();
        }
        return this.name;
    }

    public String[] getParameterNames() {
        return this.parameternames;
    }

    public Class[] getParameterTypes() {
        if (this.realep != null && this.parametertypes == null) {
            this.parametertypes = new Class[this.realP.length];
            int i2 = 0;
            while (i2 < this.realP.length) {
                this.parametertypes[i2] = Class.forClass(this.realP[i2]);
                ++i2;
            }
            this.realP = null;
        }
        return this.parametertypes;
    }

    public Class getReturnType() {
        return this.returntype;
    }

    public abstract int hashCode();

    public void setBody(String language, StringBuffer body) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.language = language;
        this.body = body;
    }

    public void setDeclaringClass(Class declaringClass) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.declaringclass = declaringClass;
    }

    public void setModifiers(int modifiers) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.modifiers = modifiers;
    }

    public void setName(String name) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.name = name;
    }

    public String toSource(String basetab) {
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append(basetab).append(Modifier.toString(this.getModifiers()));
        if (this instanceof Method) {
            if (this.returntype != null) {
                sb.append(" ").append(this.getReturnType().getJavaName());
            } else {
                sb.append(" void");
            }
        }
        sb.append(" ").append(this.getName()).append("(");
        Class[] types = this.getParameterTypes();
        if (types != null & types.length > 0) {
            sb.append(types[0].getJavaName());
            if (this.parameternames != null) {
                sb.append(' ').append(this.parameternames[0]);
            }
            i2 = 1;
            while (i2 < types.length) {
                sb.append(',').append(types[i2].getJavaName());
                if (this.parameternames != null) {
                    sb.append(' ').append(this.parameternames[i2]);
                }
                ++i2;
            }
        }
        sb.append(')');
        types = this.getExceptionTypes();
        if (types != null & types.length > 0) {
            sb.append(" throws ").append(types[0].getJavaName());
            i2 = 1;
            while (i2 < types.length) {
                sb.append(',').append(types[i2].getJavaName());
                ++i2;
            }
        }
        if (this.body == null) {
            sb.append("; // No method body available\n");
        } else {
            sb.append("\n" + basetab + "{\n");
            if (this.language == null || "java".equals(this.language)) {
                sb.append(String.valueOf(basetab) + "// ***** Should prettyprint this code...\n");
                sb.append(String.valueOf(basetab) + this.body + "\n");
            } else {
                sb.append(String.valueOf(basetab) + "// ***** Generate BSF invocation!?\n");
            }
            sb.append(String.valueOf(basetab) + "}\n");
        }
        return sb.toString();
    }

    public String toString() {
        int i2;
        StringBuffer sb = new StringBuffer(Modifier.toString(this.getModifiers()));
        if (this instanceof Method) {
            sb.append(' ').append(this.getReturnType()).append(this.getDeclaringClass().getName()).append('.').append(this.getName());
        } else {
            sb.append(this.getDeclaringClass().getName());
        }
        sb.append('(');
        Class[] p2 = this.getParameterTypes();
        if (p2 != null && p2.length > 0) {
            sb.append(p2[0].getName());
            i2 = 1;
            while (i2 < p2.length) {
                sb.append(',').append(p2[i2].getName());
                ++i2;
            }
        }
        sb.append(')');
        if (this instanceof Method && (p2 = this.getExceptionTypes()) != null && p2.length > 0) {
            sb.append(" throws ").append(p2[0].getName());
            i2 = 1;
            while (i2 < p2.length) {
                sb.append(',').append(p2[i2].getName());
                ++i2;
            }
        }
        return sb.toString();
    }
}

