/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.NameSpace;
import org.apache.xml.utils.PrefixResolver;
import org.w3c.dom.Element;

public class QName
implements Serializable {
    protected String _localName;
    protected String _namespaceURI;
    protected String _prefix;
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    private int m_hashCode;

    public QName() {
    }

    public QName(String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("Argument 'localName' is null");
        }
        this._namespaceURI = null;
        this._localName = localName;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String namespaceURI, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("Argument 'localName' is null");
        }
        this._namespaceURI = namespaceURI;
        this._localName = localName;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String namespaceURI, String prefix, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("Argument 'localName' is null");
        }
        this._namespaceURI = namespaceURI;
        this._prefix = prefix;
        this._localName = localName;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String qname, Stack namespaces) {
        String namespace = null;
        String prefix = null;
        int indexOfNSSep = qname.indexOf(58);
        if (indexOfNSSep > 0) {
            prefix = qname.substring(0, indexOfNSSep);
            if (prefix.equals("xml")) {
                namespace = S_XMLNAMESPACEURI;
            } else {
                if (prefix.equals("xmlns")) {
                    return;
                }
                int depth = namespaces.size();
                int i2 = depth - 1;
                while (i2 >= 0) {
                    NameSpace ns = (NameSpace)namespaces.elementAt(i2);
                    while (ns != null) {
                        if (ns.m_prefix != null && prefix.equals(ns.m_prefix)) {
                            namespace = ns.m_uri;
                            i2 = -1;
                            break;
                        }
                        ns = ns.m_next;
                    }
                    --i2;
                }
            }
            if (namespace == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{prefix}));
            }
        }
        this._localName = indexOfNSSep < 0 ? qname : qname.substring(indexOfNSSep + 1);
        this._namespaceURI = namespace;
        this._prefix = prefix;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String qname, PrefixResolver resolver) {
        this._namespaceURI = null;
        int indexOfNSSep = qname.indexOf(58);
        if (indexOfNSSep > 0) {
            String prefix = qname.substring(0, indexOfNSSep);
            this._namespaceURI = prefix.equals("xml") ? S_XMLNAMESPACEURI : resolver.getNamespaceForPrefix(prefix);
            if (this._namespaceURI == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{prefix}));
            }
        }
        this._localName = indexOfNSSep < 0 ? qname : qname.substring(indexOfNSSep + 1);
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String qname, Element namespaceContext, PrefixResolver resolver) {
        this._namespaceURI = null;
        int indexOfNSSep = qname.indexOf(58);
        if (indexOfNSSep > 0 && namespaceContext != null) {
            String prefix;
            this._prefix = prefix = qname.substring(0, indexOfNSSep);
            this._namespaceURI = prefix.equals("xml") ? S_XMLNAMESPACEURI : resolver.getNamespaceForPrefix(prefix, namespaceContext);
            if (this._namespaceURI == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{prefix}));
            }
        }
        this._localName = indexOfNSSep < 0 ? qname : qname.substring(indexOfNSSep + 1);
        this.m_hashCode = this.toString().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QName)) return false;
        QName qname = (QName)object;
        String thisnamespace = this.getNamespaceURI();
        String thatnamespace = qname.getNamespaceURI();
        if (!this.getLocalName().equals(qname.getLocalName())) return false;
        if (thisnamespace == null || thatnamespace == null) {
            if (thisnamespace != null) return false;
            if (thatnamespace == null) return true;
            return false;
        }
        boolean bl2 = thisnamespace.equals(thatnamespace);
        if (bl2) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(String ns, String localPart) {
        String thisnamespace = this.getNamespaceURI();
        if (!this.getLocalName().equals(localPart)) return false;
        if (thisnamespace == null || ns == null) {
            if (thisnamespace != null) return false;
            if (ns == null) return true;
            return false;
        }
        boolean bl2 = thisnamespace.equals(ns);
        if (bl2) return true;
        return false;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getLocalPart() {
        return this.getLocalName();
    }

    public static String getLocalPart(String qname) {
        int index = qname.indexOf(58);
        return index < 0 ? qname : qname.substring(index + 1);
    }

    public String getNamespace() {
        return this.getNamespaceURI();
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public static String getPrefixFromXMLNSDecl(String attRawName) {
        int index = attRawName.indexOf(58);
        return index >= 0 ? attRawName.substring(index + 1) : "";
    }

    public static String getPrefixPart(String qname) {
        int index = qname.indexOf(58);
        return index >= 0 ? qname.substring(0, index) : "";
    }

    public static QName getQNameFromString(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, "{}", false);
        String s1 = tokenizer.nextToken();
        String s2 = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
        QName qname = s2 == null ? new QName(null, s1) : new QName(s1, s2);
        return qname;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public static boolean isXMLNSDecl(String attRawName) {
        return attRawName.startsWith("xmlns") && (attRawName.equals("xmlns") || attRawName.startsWith("xmlns:"));
    }

    public String toNamespacedString() {
        return this._namespaceURI != null ? "{" + this._namespaceURI + "}" + this._localName : this._localName;
    }

    public String toString() {
        return this._prefix != null ? String.valueOf(this._prefix) + ":" + this._localName : (this._namespaceURI != null ? "{" + this._namespaceURI + "}" + this._localName : this._localName);
    }
}

