/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Enumeration;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.QueuedEvents;
import org.apache.xalan.transformer.QueuedStartDocument;
import org.apache.xalan.transformer.QueuedStartElement;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xalan.transformer.TransformState;
import org.apache.xalan.transformer.TransformerClient;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.MutableAttrListImpl;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ResultTreeHandler
extends QueuedEvents
implements ContentHandler,
LexicalHandler,
TransformState {
    private static final boolean DEBUG = false;
    boolean m_nsContextPushed = false;
    private NamespaceSupport m_nsSupport = new NamespaceSupport();
    private TransformerImpl m_transformer;
    private ContentHandler m_contentHandler;
    private LexicalHandler m_lexicalHandler;
    private StylesheetRoot m_stylesheetRoot = null;
    private int m_uniqueNSValue = 0;
    private static final String S_NAMESPACEPREFIX = "ns";
    public ClonerToResultTree m_cloner;
    private TraceManager m_tracer;
    private static final int EVT_SETDOCUMENTLOCATOR = 1;
    private static final int EVT_STARTDOCUMENT = 2;
    private static final int EVT_ENDDOCUMENT = 3;
    private static final int EVT_STARTPREFIXMAPPING = 4;
    private static final int EVT_ENDPREFIXMAPPING = 5;
    private static final int EVT_STARTELEMENT = 6;
    private static final int EVT_ENDELEMENT = 7;
    private static final int EVT_CHARACTERS = 8;
    private static final int EVT_IGNORABLEWHITESPACE = 9;
    private static final int EVT_PROCESSINGINSTRUCTION = 10;
    private static final int EVT_SKIPPEDENTITY = 11;
    private static final int EVT_COMMENT = 12;
    private static final int EVT_ENTITYREF = 13;
    private static final int EVT_STARTENTITY = 14;
    private static final int EVT_ENDENTITY = 15;
    private static final int EVT_STARTDTD = 16;
    private static final int EVT_ENDDTD = 17;
    private static final int EVT_STARTCDATA = 22;
    private static final int EVT_ENDCDATA = 23;
    private static final int EVT_NODE = 24;

    public ResultTreeHandler() {
    }

    public ResultTreeHandler(TransformerImpl transformer, ContentHandler realHandler) {
        this.init(transformer, realHandler);
    }

    public void addAttribute(String uri, String localName, String rawName, String type, String value) throws TransformerException {
        QueuedStartElement qe = this.getQueuedElem();
        if (!qe.nsDeclsHaveBeenAdded()) {
            this.addNSDeclsToAttrs();
        }
        if (uri == null) {
            uri = "";
        }
        try {
            if (!rawName.equals("xmlns")) {
                this.ensurePrefixIsDeclared(uri, rawName);
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        if (!this.isDefinedNSDecl(rawName, value)) {
            qe.addAttribute(uri, localName, rawName, type, value);
        }
    }

    public void addAttribute(Attr attr) throws TransformerException {
        if (this.isDefinedNSDecl(attr)) {
            return;
        }
        DOMHelper helper = this.m_transformer.getXPathContext().getDOMHelper();
        String ns = helper.getNamespaceOfNode(attr);
        if (ns == null) {
            ns = "";
        }
        this.addAttribute(ns, helper.getLocalNameOfNode(attr), attr.getNodeName(), "CDATA", attr.getValue());
    }

    public void addAttributes(Node src) throws TransformerException {
        NamedNodeMap nnm = src.getAttributes();
        int nAttrs = nnm.getLength();
        int i2 = 0;
        while (i2 < nAttrs) {
            Attr node = (Attr)nnm.item(i2);
            this.addAttribute(node);
            ++i2;
        }
    }

    protected void addNSDeclsToAttrs() {
        Enumeration prefixes = this.m_nsSupport.getDeclaredPrefixes();
        QueuedStartElement qe = this.getQueuedElem();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            boolean isDefault = prefix.length() == 0;
            String name = isDefault ? "xmlns" : "xmlns:" + prefix;
            String uri = this.m_nsSupport.getURI(prefix);
            if (uri == null) {
                uri = "";
            }
            qe.addAttribute("http://www.w3.org/2000/xmlns/", prefix, name, "CDATA", uri);
        }
        qe.setNSDeclsHaveBeenAdded(true);
    }

    public void characters(char[] ch2, int start, int length) throws SAXException {
        this.flushPending(8);
        this.m_contentHandler.characters(ch2, start, length);
        if (this.m_tracer != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 5, ch2, start, length);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    private void checkForSerializerSwitch(String ns, String localName) throws SAXException {
        try {
            QueuedStartDocument qdab = this.getQueuedDocAtBottom();
            if (qdab.isPending) {
                SerializerSwitcher.switchSerializerIfHTML(this.m_transformer, ns, localName);
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void cloneToResultTree(Node node, boolean shouldCloneAttributes) throws SAXException {
        try {
            this.m_cloner.cloneToResultTree(node, shouldCloneAttributes);
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void comment(String data) throws SAXException {
        this.flushPending(12);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.comment(data.toCharArray(), 0, data.length());
        }
        if (this.m_tracer != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 8, data);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void comment(char[] ch2, int start, int length) throws SAXException {
        this.flushPending(12);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.comment(ch2, start, length);
        }
        if (this.m_tracer != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 8, new String(ch2, start, length));
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void endCDATA() throws SAXException {
        this.flushPending(23);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        this.flushPending(17);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        this.flushPending(3);
        QueuedStartDocument qsd = this.getQueuedDocAtBottom();
        if (!qsd.isEnded) {
            this.m_contentHandler.endDocument();
            if (this.m_tracer != null) {
                GenerateEvent ge = new GenerateEvent(this.m_transformer, 2, null);
                this.m_tracer.fireGenerateEvent(ge);
            }
            qsd.setPending(false);
        }
    }

    public void endElement(String ns, String localName, String name) throws SAXException {
        this.flushPending(7);
        this.m_contentHandler.endElement(ns, localName, name);
        if (this.m_tracer != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 4, name);
            this.m_tracer.fireGenerateEvent(ge);
        }
        this.sendEndPrefixMappings();
        this.popEvent();
        this.m_nsSupport.popContext();
    }

    public void endEntity(String name) throws SAXException {
        this.flushPending(15);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endEntity(name);
        }
        if (this.m_tracer != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 9, name);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    void ensurePrefixIsDeclared(String ns, String rawName) throws SAXException {
        if (ns != null && ns.length() > 0) {
            String foundURI;
            String prefix;
            int index = rawName.indexOf(":");
            String string = prefix = index < 0 ? "" : rawName.substring(0, index);
            if (!(prefix == null || (foundURI = this.m_nsSupport.getURI(prefix)) != null && foundURI.equals(ns))) {
                this.startPrefixMapping(prefix, ns, false);
            }
        }
    }

    public void entityReference(String name) throws SAXException {
        this.flushPending(13);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startEntity(name);
            this.m_lexicalHandler.endEntity(name);
        }
        if (this.m_tracer != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 9, name);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void flushPending() throws SAXException {
        this.flushPending(24);
    }

    public void flushPending(int type) throws SAXException {
        QueuedStartElement qe = this.getQueuedElem();
        QueuedStartDocument qdab = this.getQueuedDocAtBottom();
        if (type != 4 && qdab.isPending) {
            qdab.flush(this);
        }
        if (qe != null && qe.isPending) {
            if (!qe.nsDeclsHaveBeenAdded()) {
                this.addNSDeclsToAttrs();
            }
            this.sendStartPrefixMappings();
            qe.flush();
            this.m_nsContextPushed = false;
        }
    }

    public ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public NodeIterator getContextNodeList() {
        QueuedStartElement qe = this.getQueuedElem();
        if (qe != null && qe.isPending) {
            return qe.getContextNodeList();
        }
        return this.m_transformer.getContextNodeList();
    }

    public ElemTemplateElement getCurrentElement() {
        QueuedStartElement qe = this.getQueuedElem();
        if (qe != null && qe.isPending) {
            return qe.getCurrentElement();
        }
        return this.m_transformer.getCurrentElement();
    }

    public Node getCurrentNode() {
        QueuedStartElement qe = this.getQueuedElem();
        if (qe != null && qe.isPending) {
            return qe.getCurrentNode();
        }
        return this.m_transformer.getCurrentNode();
    }

    public ElemTemplate getCurrentTemplate() {
        QueuedStartElement qe = this.getQueuedElem();
        if (qe != null && qe.isPending) {
            return qe.getCurrentTemplate();
        }
        return this.m_transformer.getCurrentTemplate();
    }

    public Node getMatchedNode() {
        QueuedStartElement qe = this.getQueuedElem();
        if (qe != null && qe.isPending) {
            return qe.getMatchedNode();
        }
        return this.m_transformer.getMatchedNode();
    }

    public ElemTemplate getMatchedTemplate() {
        QueuedStartElement qe = this.getQueuedElem();
        if (qe != null && qe.isPending) {
            return qe.getMatchedTemplate();
        }
        return this.m_transformer.getMatchedTemplate();
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.m_nsSupport;
    }

    public String getNewUniqueNSPrefix() {
        return S_NAMESPACEPREFIX + String.valueOf(this.getUniqueNSValue());
    }

    public MutableAttrListImpl getPendingAttributes() {
        return this.getQueuedElem().getAttrs();
    }

    public String getPrefix(String namespace) {
        Enumeration enumeration = this.m_nsSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String prefix = (String)enumeration.nextElement();
            if (!this.m_nsSupport.getURI(prefix).equals(namespace)) continue;
            return prefix;
        }
        return null;
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public String getURI(String prefix) {
        return this.m_nsSupport.getURI(prefix);
    }

    public int getUniqueNSValue() {
        return this.m_uniqueNSValue++;
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        QueuedStartDocument qsd = this.getQueuedDoc();
        if (qsd != null && qsd.isPending && XMLCharacterRecognizer.isWhiteSpace(ch2, start, length)) {
            return;
        }
        this.flushPending(9);
        this.m_contentHandler.ignorableWhitespace(ch2, start, length);
        if (this.m_tracer != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 6, ch2, start, length);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void init(TransformerImpl transformer, ContentHandler realHandler) {
        this.m_transformer = transformer;
        this.m_startElement.setTransformer(this.m_transformer);
        this.m_startDoc.setTransformer(this.m_transformer);
        TraceManager tracer = transformer.getTraceManager();
        this.m_tracer = tracer != null && tracer.hasTraceListeners() ? tracer : null;
        this.m_startElement.setTraceManager(this.m_tracer);
        this.m_startDoc.setTraceManager(this.m_tracer);
        this.m_contentHandler = realHandler;
        this.m_startElement.setContentHandler(this.m_contentHandler);
        this.m_startDoc.setContentHandler(this.m_contentHandler);
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.m_startElement.setIsTransformClient(this.m_contentHandler instanceof TransformerClient);
        this.m_cloner = new ClonerToResultTree(transformer, this);
        if (this.m_transformer != null) {
            this.m_stylesheetRoot = this.m_transformer.getStylesheet();
        }
        this.pushDocumentEvent();
    }

    public boolean isDefinedNSDecl(String rawName, String value) {
        if (rawName.equals("xmlns") || rawName.startsWith("xmlns:")) {
            int index = rawName.indexOf(":");
            String prefix = index < 0 ? "" : rawName.substring(0, index);
            String definedURI = this.m_nsSupport.getURI(prefix);
            if (definedURI != null) {
                return definedURI.equals(value);
            }
            return false;
        }
        return false;
    }

    public boolean isDefinedNSDecl(Attr attr) {
        int index;
        String prefix;
        String uri;
        String rawName = attr.getNodeName();
        return (rawName.equals("xmlns") || rawName.startsWith("xmlns:")) && (uri = this.getURI(prefix = (index = rawName.indexOf(":")) < 0 ? "" : rawName.substring(0, index))) != null && uri.equals(attr.getValue());
    }

    public boolean isElementPending() {
        QueuedStartElement qse = this.getQueuedElem();
        return qse != null ? qse.isPending : false;
    }

    public void outputResultTreeFragment(XObject obj, XPathContext support) throws SAXException {
        DocumentFragment docFrag = obj.rtree(support);
        TreeWalker tw = new TreeWalker(this, support.getDOMHelper());
        Node n2 = docFrag.getFirstChild();
        while (n2 != null) {
            this.flushPending(24);
            tw.traverse(n2);
            n2 = n2.getNextSibling();
        }
    }

    public void processNSDecls(Node src) throws TransformerException {
        try {
            Node parent;
            short type = src.getNodeType();
            if ((type == 1 || type == 5) && (parent = src.getParentNode()) != null) {
                this.processNSDecls(parent);
            }
            if (type == 1) {
                NamedNodeMap nnm = src.getAttributes();
                int nAttrs = nnm.getLength();
                int i2 = 0;
                while (i2 < nAttrs) {
                    Node attr = nnm.item(i2);
                    String aname = attr.getNodeName();
                    if (QName.isXMLNSDecl(aname)) {
                        String prefix = QName.getPrefixFromXMLNSDecl(aname);
                        String desturi = this.getURI(prefix);
                        String srcURI = attr.getNodeValue();
                        if (!srcURI.equalsIgnoreCase(desturi)) {
                            this.startPrefixMapping(prefix, srcURI, false);
                        }
                    }
                    ++i2;
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushPending(10);
        this.m_contentHandler.processingInstruction(target, data);
        if (this.m_tracer != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 7, target, data);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    protected void sendEndPrefixMappings() throws SAXException {
        Enumeration prefixes = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler handler = this.m_contentHandler;
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            handler.endPrefixMapping(prefix);
        }
    }

    protected void sendStartPrefixMappings() throws SAXException {
        Enumeration prefixes = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler handler = this.m_contentHandler;
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            handler.startPrefixMapping(prefix, this.m_nsSupport.getURI(prefix));
        }
    }

    public void setContentHandler(ContentHandler ch2) {
        this.m_contentHandler = ch2;
        this.m_startElement.setIsTransformClient(this.m_contentHandler instanceof TransformerClient);
        this.m_startElement.setContentHandler(this.m_contentHandler);
        this.m_startDoc.setContentHandler(this.m_contentHandler);
        this.reInitEvents();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.flushPending(22);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startCDATA();
        }
    }

    public void startDTD(String s1, String s2, String s3) throws SAXException {
        this.flushPending(16);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startDTD(s1, s2, s3);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        QueuedStartElement qse = this.getQueuedElem();
        this.checkForSerializerSwitch(ns, localName);
        this.flushPending(6);
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
        }
        this.ensurePrefixIsDeclared(ns, name);
        this.pushElementEvent(ns, localName, name, atts);
    }

    public void startEntity(String name) throws SAXException {
        this.flushPending(14);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startEntity(name);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.startPrefixMapping(prefix, uri, true);
    }

    public void startPrefixMapping(String prefix, String uri, boolean shouldFlush) throws SAXException {
        String existingURI;
        if (shouldFlush) {
            this.flushPending(4);
        }
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (prefix == null) {
            prefix = "";
        }
        if ((existingURI = this.m_nsSupport.getURI(prefix)) == null) {
            existingURI = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (!existingURI.equals(uri)) {
            this.m_nsSupport.declarePrefix(prefix, uri);
        }
    }
}

