/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.text.CollationKey;
import java.text.NumberFormat;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.NodeSortKey;
import org.apache.xml.utils.NodeVector;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSorter {
    XPathContext m_execContext;
    Vector m_keys;
    NumberFormat m_formatter = NumberFormat.getNumberInstance();

    public NodeSorter(XPathContext p2) {
        this.m_execContext = p2;
    }

    int compare(NodeCompareElem n1, NodeCompareElem n2, int kIndex, XPathContext support) throws TransformerException {
        int result = 0;
        NodeSortKey k2 = (NodeSortKey)this.m_keys.elementAt(kIndex);
        if (k2.m_treatAsNumbers) {
            double diff;
            double n2Num;
            double n1Num;
            if (kIndex == 0) {
                n1Num = (Double)n1.m_key1Value;
                n2Num = (Double)n2.m_key1Value;
            } else if (kIndex == 1) {
                n1Num = (Double)n1.m_key2Value;
                n2Num = (Double)n2.m_key2Value;
            } else {
                XObject r1 = k2.m_selectPat.execute(this.m_execContext, n1.m_node, k2.m_namespaceContext);
                XObject r2 = k2.m_selectPat.execute(this.m_execContext, n2.m_node, k2.m_namespaceContext);
                double d10 = r1.num();
                n1Num = Double.isNaN(d10) ? 0.0 : d10;
                d10 = r2.num();
                double d11 = n2Num = Double.isNaN(d10) ? 0.0 : d10;
            }
            result = n1Num == n2Num && kIndex + 1 < this.m_keys.size() ? this.compare(n1, n2, kIndex + 1, support) : ((diff = n1Num - n2Num) < 0.0 ? (k2.m_descending ? 1 : -1) : (diff > 0.0 ? (k2.m_descending ? -1 : 1) : 0));
        } else {
            String tempN2;
            String tempN1;
            CollationKey n2String;
            CollationKey n1String;
            if (kIndex == 0) {
                n1String = (CollationKey)n1.m_key1Value;
                n2String = (CollationKey)n2.m_key1Value;
            } else if (kIndex == 1) {
                n1String = (CollationKey)n1.m_key2Value;
                n2String = (CollationKey)n2.m_key2Value;
            } else {
                XObject r1 = k2.m_selectPat.execute(this.m_execContext, n1.m_node, k2.m_namespaceContext);
                XObject r2 = k2.m_selectPat.execute(this.m_execContext, n2.m_node, k2.m_namespaceContext);
                n1String = k2.m_col.getCollationKey(r1.str());
                n2String = k2.m_col.getCollationKey(r2.str());
            }
            result = n1String.compareTo(n2String);
            if (k2.m_caseOrderUpper && (tempN1 = n1String.getSourceString().toLowerCase()).equals(tempN2 = n2String.getSourceString().toLowerCase())) {
                int n3 = result = result == 0 ? 0 : -result;
            }
            if (k2.m_descending) {
                result = -result;
            }
        }
        if (result == 0 && kIndex + 1 < this.m_keys.size()) {
            result = this.compare(n1, n2, kIndex + 1, support);
        }
        if (result == 0) {
            result = support.getDOMHelper().isNodeAfter(n1.m_node, n2.m_node) ? -1 : 1;
        }
        return result;
    }

    void mergesort(Vector a, Vector b10, int l2, int r2, XPathContext support) throws TransformerException {
        if (r2 - l2 > 0) {
            int m2 = (r2 + l2) / 2;
            this.mergesort(a, b10, l2, m2, support);
            this.mergesort(a, b10, m2 + 1, r2, support);
            int i2 = m2;
            while (i2 >= l2) {
                if (i2 >= b10.size()) {
                    b10.insertElementAt(a.elementAt(i2), i2);
                } else {
                    b10.setElementAt(a.elementAt(i2), i2);
                }
                --i2;
            }
            i2 = l2;
            int j2 = m2 + 1;
            while (j2 <= r2) {
                if (r2 + m2 + 1 - j2 >= b10.size()) {
                    b10.insertElementAt(a.elementAt(j2), r2 + m2 + 1 - j2);
                } else {
                    b10.setElementAt(a.elementAt(j2), r2 + m2 + 1 - j2);
                }
                ++j2;
            }
            j2 = r2;
            int k2 = l2;
            while (k2 <= r2) {
                int compVal = i2 == j2 ? -1 : this.compare((NodeCompareElem)b10.elementAt(i2), (NodeCompareElem)b10.elementAt(j2), 0, support);
                if (compVal < 0) {
                    a.setElementAt(b10.elementAt(i2), k2);
                    ++i2;
                } else if (compVal > 0) {
                    a.setElementAt(b10.elementAt(j2), k2);
                    --j2;
                }
                ++k2;
            }
        }
    }

    public void sort(NodeVector v2, Vector keys, XPathContext support) throws TransformerException {
        this.m_keys = keys;
        int n2 = v2.size();
        Vector<NodeCompareElem> nodes = new Vector<NodeCompareElem>();
        int i2 = 0;
        while (i2 < n2) {
            NodeCompareElem elem = new NodeCompareElem(v2.elementAt(i2));
            nodes.addElement(elem);
            ++i2;
        }
        Vector scratchVector = new Vector();
        this.mergesort(nodes, scratchVector, 0, n2 - 1, support);
        int i3 = 0;
        while (i3 < n2) {
            v2.setElementAt(((NodeCompareElem)nodes.elementAt((int)i3)).m_node, i3);
            ++i3;
        }
    }

    private void swap(Vector v2, int i2, int j2) {
        Node node = (Node)v2.elementAt(i2);
        v2.setElementAt(v2.elementAt(j2), i2);
        v2.setElementAt(node, j2);
    }

    class NodeCompareElem {
        Node m_node;
        int maxkey = 2;
        Object m_key1Value;
        Object m_key2Value;

        NodeCompareElem(Node node) throws TransformerException {
            boolean tryNextKey = true;
            this.m_node = node;
            if (!NodeSorter.this.m_keys.isEmpty()) {
                NodeIterator ni;
                double d10;
                NodeSortKey k1 = (NodeSortKey)NodeSorter.this.m_keys.elementAt(0);
                XObject r2 = k1.m_selectPat.execute(NodeSorter.this.m_execContext, node, k1.m_namespaceContext);
                if (r2 == null) {
                    tryNextKey = false;
                }
                this.m_key1Value = k1.m_treatAsNumbers ? new Double(Double.isNaN(d10 = r2.num()) ? 0.0 : d10) : k1.m_col.getCollationKey(r2.str());
                if (r2.getType() == 4 && (ni = (NodeIterator)r2.object()) instanceof ContextNodeList) {
                    boolean bl2 = tryNextKey = ((ContextNodeList)((Object)ni)).getCurrentNode() != null;
                }
                if (NodeSorter.this.m_keys.size() > 1) {
                    NodeSortKey k2 = (NodeSortKey)NodeSorter.this.m_keys.elementAt(1);
                    if (!tryNextKey) {
                        this.m_key2Value = k2.m_treatAsNumbers ? new Double(0.0) : k2.m_col.getCollationKey("");
                    } else {
                        XObject r22 = k2.m_selectPat.execute(NodeSorter.this.m_execContext, node, k2.m_namespaceContext);
                        this.m_key2Value = k2.m_treatAsNumbers ? new Double(Double.isNaN(d10 = r22.num()) ? 0.0 : d10) : k2.m_col.getCollationKey(r22.str());
                    }
                }
            }
        }
    }
}

