/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemUse;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElemElement
extends ElemUse {
    protected AVT m_name_avt = null;
    protected AVT m_namespace_avt = null;

    void constructNode(String nodeName, String prefix, String nodeNamespace, TransformerImpl transformer, Node sourceNode, QName mode) throws TransformerException {
        try {
            boolean shouldAddAttrs;
            ResultTreeHandler rhandler = transformer.getResultTreeHandler();
            if (nodeName != null) {
                this.executeNSDecls(transformer);
                if (prefix != null) {
                    rhandler.startPrefixMapping(prefix, nodeNamespace, true);
                }
                rhandler.startElement(nodeNamespace, QName.getLocalPart(nodeName), nodeName, null);
            }
            boolean bl2 = shouldAddAttrs = nodeName != null;
            if (shouldAddAttrs) {
                super.execute(transformer, sourceNode, mode);
            }
            transformer.executeChildTemplates((ElemTemplateElement)this, sourceNode, mode, shouldAddAttrs);
            if (nodeName != null) {
                rhandler.endElement(nodeNamespace, QName.getLocalPart(nodeName), nodeName);
                this.unexecuteNSDecls(transformer);
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public void execute(TransformerImpl transformer, Node sourceNode, QName mode) throws TransformerException {
        ResultTreeHandler rhandler = transformer.getResultTreeHandler();
        XPathContext xctxt = transformer.getXPathContext();
        String nodeName = this.m_name_avt.evaluate(xctxt, sourceNode, this);
        int indexOfNSSep = nodeName.indexOf(58);
        String prefix = null;
        String nodeNamespace = null;
        if (nodeName.length() == 0) {
            nodeName = null;
        }
        if (nodeName != null) {
            prefix = indexOfNSSep > 0 ? nodeName.substring(0, indexOfNSSep) : "";
            try {
                nodeNamespace = this.getNamespaceForPrefix(prefix);
                if (nodeNamespace == null && indexOfNSSep <= 0) {
                    nodeNamespace = "";
                }
                if (!this.validateNodeName(nodeName)) {
                    transformer.getMsgMgr().warn(this, 24, new Object[]{nodeName});
                    nodeName = null;
                }
            }
            catch (Exception exception) {
                transformer.getMsgMgr().warn(this, 22, new Object[]{prefix});
                nodeName = null;
            }
        } else if (nodeName == null) {
            transformer.getMsgMgr().warn(this, 24, new Object[]{nodeName});
            nodeName = null;
        } else if (nodeName.length() == 0 || !this.isValidNCName(nodeName)) {
            transformer.getMsgMgr().warn(this, 22, new Object[]{nodeName});
            nodeName = null;
        }
        if (nodeName != null) {
            if (this.m_namespace_avt != null) {
                nodeNamespace = this.m_namespace_avt.evaluate(xctxt, sourceNode, this);
                if (nodeNamespace == null) {
                    nodeNamespace = "";
                }
                if ((prefix = this.resolvePrefix(rhandler, prefix, nodeNamespace)) == null) {
                    prefix = "";
                }
                if (prefix.length() > 0) {
                    nodeName = String.valueOf(prefix) + ":" + QName.getLocalPart(nodeName);
                }
            } else if (prefix != null && nodeNamespace == null) {
                transformer.getMsgMgr().warn(this, 22, new Object[]{prefix});
                nodeName = null;
            }
        }
        this.constructNode(nodeName, prefix, nodeNamespace, transformer, sourceNode, mode);
    }

    public AVT getName() {
        return this.m_name_avt;
    }

    public AVT getNamespace() {
        return this.m_namespace_avt;
    }

    public String getNodeName() {
        return "element";
    }

    public int getXSLToken() {
        return 46;
    }

    protected String resolvePrefix(ResultTreeHandler rhandler, String prefix, String nodeNamespace) throws TransformerException {
        return prefix;
    }

    public void setName(AVT v2) {
        this.m_name_avt = v2;
    }

    public void setNamespace(AVT v2) {
        this.m_namespace_avt = v2;
    }

    protected boolean validateNodeName(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        int indexOfNSSep = nodeName.indexOf(58);
        int len = nodeName.length();
        if (len == 0) {
            return false;
        }
        if (indexOfNSSep + 1 == len) {
            return false;
        }
        if (indexOfNSSep == 0) {
            return false;
        }
        String localName = QName.getLocalPart(nodeName);
        if (this.isValidNCName(localName)) {
            String prefix = QName.getPrefixPart(nodeName);
            if (prefix.length() == 0) {
                return true;
            }
            if (this.isValidNCName(prefix)) {
                return true;
            }
        }
        return false;
    }
}

