/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import javax.xml.transform.TransformerException;
import org.apache.xalan.stree.Child;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.ElementImpl;
import org.apache.xalan.stree.SaxEventDispatch;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.XPathContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Parent
extends Child {
    protected int m_posInChildList;
    protected int m_childCount = 0;
    boolean m_isComplete = false;
    Child m_last;
    Child m_first;

    public Parent(DocumentImpl doc) {
        super(doc);
    }

    public Node appendChild(Node newChild) throws DOMException {
        block6: {
            TransformerImpl transformer;
            SourceTreeHandler sh;
            Child child = (Child)newChild;
            DocumentImpl doc = this.m_doc;
            child.m_parent = this;
            ++this.m_childCount;
            if (child.m_uid == 0) {
                child.m_uid = ++this.m_doc.m_docOrderCount;
            }
            child.m_level = (short)(this.m_level + 1);
            if (this.m_first == null) {
                this.m_first = child;
            } else {
                child.m_prev = this.m_last;
                this.m_last.m_next = child;
            }
            this.m_last = child;
            if (child.getNodeType() != 1 || (sh = doc.getSourceTreeHandler()) == null || !sh.m_shouldCheckWhitespace || (transformer = sh.getTransformerImpl()) == null) break block6;
            StylesheetRoot stylesheet = transformer.getStylesheet();
            try {
                WhiteSpaceInfo info;
                ElementImpl elem = (ElementImpl)child;
                if (doc.m_xpathContext == null) {
                    doc.m_xpathContext = new XPathContext(doc);
                }
                boolean shouldStrip = (info = stylesheet.getWhiteSpaceInfo(doc.m_xpathContext, elem)) == null ? sh.getShouldStripWhitespace() : info.getShouldStripSpace();
                sh.setShouldStripWhitespace(shouldStrip);
            }
            catch (TransformerException transformerException) {}
        }
        return newChild;
    }

    public void dispatchCharactersEvent(ContentHandler ch2) throws SAXException {
        Node child = this.getFirstChild();
        while (child != null) {
            short t2 = child.getNodeType();
            if (t2 != 8 && t2 != 7) {
                ((SaxEventDispatch)((Object)child)).dispatchCharactersEvent(ch2);
            }
            child = child.getNextSibling();
        }
    }

    public Child getChild(int i2) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (i2 < 0) {
            return null;
        }
        if (i2 >= this.m_childCount && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (i2 >= this.m_childCount) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        if (i2 < this.m_childCount) {
            Child child = this.m_first;
            int pos = 0;
            while (child != null) {
                if (pos == i2) {
                    return child;
                }
                child = child.m_next;
                ++pos;
            }
        }
        return null;
    }

    public int getChildCount() {
        if (!this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_childCount;
    }

    public int getChildUID(int pos) {
        Child child = this.getChild(pos);
        return child != null ? child.getUid() : -1;
    }

    public Node getFirstChild() {
        if (this.m_first != null) {
            return this.m_first;
        }
        if (!this.m_isComplete) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (this.m_first == null) continue;
                        Child child = this.m_first;
                        Object var3_3 = null;
                        return child;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_first;
    }

    public Node getLastChild() {
        try {
            return this.getChild(this.getChildCount() - 1);
        }
        catch (Exception e10) {
            throw new WrappedRuntimeException(e10);
        }
    }

    public boolean hasChildNodes() {
        if (this.m_childCount != 0) {
            return true;
        }
        if (!this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (this.m_childCount == 0) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_childCount != 0;
    }

    public boolean isComplete() {
        if (!this.m_isComplete && this.m_doc.m_exceptionThrown != null) {
            this.throwParseError(this.m_doc.m_exceptionThrown);
        }
        return this.m_isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.m_isComplete = isComplete;
    }

    protected void throwParseError(Exception e10) {
        this.m_isComplete = true;
        super.throwParseError(e10);
    }
}

