/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.util.Hashtable;
import org.apache.xalan.lib.sql.ConnectionPool;

public class XConnectionPoolManager {
    static Hashtable m_poolTable = null;
    static boolean m_isInit = false;

    public XConnectionPoolManager() {
        this.init();
    }

    public synchronized ConnectionPool getPool(String name) {
        return (ConnectionPool)m_poolTable.get(name);
    }

    public synchronized void init() {
        if (m_isInit) {
            return;
        }
        m_poolTable = new Hashtable();
        m_isInit = true;
    }

    public synchronized void registerPool(String name, ConnectionPool pool) {
        if (m_poolTable.containsKey(name)) {
            throw new IllegalArgumentException("Pool already exists");
        }
        m_poolTable.put(name, pool);
    }

    public synchronized void removePool(String name) {
        ConnectionPool pool = this.getPool(name);
        if (pool != null) {
            pool.disablePool();
            if (!pool.hasActiveConnections()) {
                m_poolTable.remove(name);
            }
        }
    }
}

