/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.DefaultConnectionPool;
import org.apache.xalan.lib.sql.ExtensionError;
import org.apache.xalan.lib.sql.QueryParameter;
import org.apache.xalan.lib.sql.SQLExtensionError;
import org.apache.xalan.lib.sql.XConnectionPoolManager;
import org.apache.xalan.lib.sql.XStatement;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XConnection {
    private static final boolean DEBUG = false;
    public Connection m_connection = null;
    private ConnectionPool m_ConnectionPool = null;
    private String m_ConnectionPoolName;
    private boolean m_IsDefaultPool = false;
    private boolean m_DefaultPoolingEnabled = false;
    private XConnectionPoolManager m_PoolMgr = new XConnectionPoolManager();
    public Vector m_ParameterList = new Vector();

    public XConnection(String ConnPoolName) {
        this.connect(ConnPoolName);
    }

    public XConnection(String driver, String dbURL) {
        this.connect(driver, dbURL);
    }

    public XConnection(String driver, String dbURL, String user, String password) {
        this.connect(driver, dbURL, user, password);
    }

    public XConnection(String driver, String dbURL, Element protocolElem) {
        this.connect(driver, dbURL, protocolElem);
    }

    public XConnection(NodeList list) {
        this.connect(list);
    }

    public void addParameter(String value) {
        this.addParameterWithType(value, null);
    }

    public void addParameterFromElement(Element e10) {
        NamedNodeMap attrs = e10.getAttributes();
        Node Type2 = attrs.getNamedItem("type");
        Node n1 = e10.getFirstChild();
        if (n1 != null) {
            String value = n1.getNodeValue();
            if (value == null) {
                value = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(value, Type2.getNodeValue()));
        }
    }

    public void addParameterFromElement(NodeList nl) {
        int count = nl.getLength();
        int x2 = 0;
        while (x2 < count) {
            this.addParameters((Element)nl.item(x2));
            ++x2;
        }
    }

    public void addParameterWithType(String value, String Type2) {
        this.m_ParameterList.addElement(new QueryParameter(value, Type2));
    }

    private void addParameters(Element elem) {
        Node n2 = elem.getFirstChild();
        if (n2 == null) {
            return;
        }
        do {
            if (n2.getNodeType() != 1) continue;
            NamedNodeMap attrs = n2.getAttributes();
            Node Type2 = attrs.getNamedItem("type");
            String TypeStr = Type2 == null ? "string" : Type2.getNodeValue();
            Node n1 = n2.getFirstChild();
            if (n1 == null) continue;
            String value = n1.getNodeValue();
            if (value == null) {
                value = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(value, TypeStr));
        } while ((n2 = n2.getNextSibling()) != null);
    }

    public void close() throws SQLException {
        if (this.m_connection != null) {
            if (this.m_ConnectionPool != null) {
                this.m_ConnectionPool.releaseConnection(this.m_connection);
            } else {
                this.m_connection.close();
            }
        }
        this.m_connection = null;
    }

    public NodeIterator connect(String ConnPoolName) {
        try {
            if (this.m_ConnectionPool != null && this.m_IsDefaultPool) {
                this.m_PoolMgr.removePool(this.m_ConnectionPoolName);
            }
            this.m_ConnectionPool = this.m_PoolMgr.getPool(ConnPoolName);
            this.m_ConnectionPoolName = ConnPoolName;
            this.m_connection = this.m_ConnectionPool.getConnection();
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        return null;
    }

    public NodeIterator connect(String driver, String dbURL) {
        try {
            this.init(driver, dbURL, new Properties());
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        catch (Exception e11) {
            ExtensionError err = new ExtensionError(e11);
            return err;
        }
        return null;
    }

    public NodeIterator connect(String driver, String dbURL, String user, String password) {
        try {
            Properties prop = new Properties();
            ((Hashtable)prop).put("user", user);
            ((Hashtable)prop).put("password", password);
            this.init(driver, dbURL, prop);
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        catch (Exception e11) {
            ExtensionError err = new ExtensionError(e11);
            return err;
        }
        return null;
    }

    public NodeIterator connect(String driver, String dbURL, Element protocolElem) {
        try {
            Properties prop = new Properties();
            NamedNodeMap atts = protocolElem.getAttributes();
            int i2 = 0;
            while (i2 < atts.getLength()) {
                ((Hashtable)prop).put(atts.item(i2).getNodeName(), atts.item(i2).getNodeValue());
                ++i2;
            }
            this.init(driver, dbURL, prop);
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        catch (Exception e11) {
            ExtensionError err = new ExtensionError(e11);
            return err;
        }
        return null;
    }

    public NodeIterator connect(Element protocolElem) {
        try {
            this.initFromElement(protocolElem);
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        catch (Exception e11) {
            ExtensionError err = new ExtensionError(e11);
            return err;
        }
        return null;
    }

    public NodeIterator connect(NodeList list) {
        try {
            this.initFromElement((Element)list.item(0));
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        catch (Exception e11) {
            ExtensionError err = new ExtensionError(e11);
            return err;
        }
        return null;
    }

    public void disableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = false;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (!this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.disablePool();
    }

    public void enableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = true;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (!this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.enablePool();
    }

    protected void finalize() {
    }

    private void init(String driver, String dbURL, Properties prop) throws SQLException {
        String passwd;
        String user = prop.getProperty("user");
        if (user == null) {
            user = "";
        }
        if ((passwd = prop.getProperty("password")) == null) {
            passwd = "";
        }
        String poolName = String.valueOf(driver) + dbURL + user + passwd;
        ConnectionPool cpool = this.m_PoolMgr.getPool(poolName);
        if (this.m_ConnectionPool != null && this.m_IsDefaultPool && cpool != this.m_ConnectionPool) {
            this.m_PoolMgr.removePool(this.m_ConnectionPoolName);
        }
        if (cpool == null) {
            DefaultConnectionPool defpool = new DefaultConnectionPool();
            defpool.setDriver(driver);
            defpool.setURL(dbURL);
            defpool.setProtocol(prop);
            if (this.m_DefaultPoolingEnabled) {
                defpool.enablePool();
            }
            this.m_PoolMgr.registerPool(poolName, defpool);
            this.m_ConnectionPool = defpool;
            this.m_ConnectionPoolName = poolName;
        } else {
            this.m_ConnectionPool = cpool;
            this.m_ConnectionPoolName = poolName;
        }
        this.m_ConnectionPool.testConnection();
        this.m_connection = this.m_ConnectionPool.getConnection();
    }

    private void initFromElement(Element e10) throws SQLException {
        Properties prop = new Properties();
        String driver = "";
        String dbURL = "";
        Node n2 = e10.getFirstChild();
        if (n2 == null) {
            return;
        }
        do {
            Node n1;
            String s2;
            Node n12;
            String nName;
            if ((nName = n2.getNodeName()).equalsIgnoreCase("dbdriver")) {
                driver = "";
                n12 = n2.getFirstChild();
                if (n12 != null) {
                    driver = n12.getNodeValue();
                }
            }
            if (nName.equalsIgnoreCase("dburl")) {
                dbURL = "";
                n12 = n2.getFirstChild();
                if (n12 != null) {
                    dbURL = n12.getNodeValue();
                }
            }
            if (nName.equalsIgnoreCase("password")) {
                s2 = "";
                n1 = n2.getFirstChild();
                if (n1 != null) {
                    s2 = n1.getNodeValue();
                }
                ((Hashtable)prop).put("password", s2);
            }
            if (nName.equalsIgnoreCase("user")) {
                s2 = "";
                n1 = n2.getFirstChild();
                if (n1 != null) {
                    s2 = n1.getNodeValue();
                }
                ((Hashtable)prop).put("user", s2);
            }
            if (!nName.equalsIgnoreCase("protocol")) continue;
            String Name2 = "";
            NamedNodeMap attrs = n2.getAttributes();
            Node n13 = attrs.getNamedItem("name");
            if (n13 == null) continue;
            String s3 = "";
            Name2 = n13.getNodeValue();
            Node n22 = n2.getFirstChild();
            if (n22 != null) {
                s3 = n22.getNodeValue();
            }
            ((Hashtable)prop).put(Name2, s3);
        } while ((n2 = n2.getNextSibling()) != null);
        this.init(driver, dbURL, prop);
    }

    public NodeIterator pquery(String queryString) {
        try {
            return new XStatement(this, queryString, this.m_ParameterList);
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        catch (Exception e11) {
            ExtensionError err = new ExtensionError(e11);
            return err;
        }
    }

    public NodeIterator pquery(String queryString, String typeInfo) {
        try {
            int indx = 0;
            QueryParameter param = null;
            StringTokenizer plist = new StringTokenizer(typeInfo);
            while (plist.hasMoreTokens()) {
                String value = plist.nextToken();
                param = (QueryParameter)this.m_ParameterList.elementAt(indx);
                if (param == null) continue;
                param.setType(value);
            }
            return new XStatement(this, queryString, this.m_ParameterList);
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        catch (Exception e11) {
            ExtensionError err = new ExtensionError(e11);
            return err;
        }
    }

    public NodeIterator query(String queryString) {
        try {
            return new XStatement(this, queryString);
        }
        catch (SQLException e10) {
            SQLExtensionError err = new SQLExtensionError(e10);
            return err;
        }
        catch (Exception e11) {
            ExtensionError err = new ExtensionError(e11);
            return err;
        }
    }
}

