/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.xalan.lib.sql.StreamableNode;
import org.apache.xalan.lib.sql.XStatement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumnAttribute
extends StreamableNode
implements Attr {
    Element m_owner;
    ResultSetMetaData m_metadata;
    String m_name;
    int m_type;
    int m_columnIndex;
    ColumnAttribute m_columnAttr;
    static final String S_ISTRUE = "true";
    static final String S_ISFALSE = "false";
    public static final int CATALOGUE_NAME = 0;
    public static final int DISPLAY_SIZE = 1;
    public static final int COLUMN_LABEL = 2;
    public static final int COLUMN_NAME = 3;
    public static final int COLUMN_TYPE = 4;
    public static final int COLUMN_TYPENAME = 5;
    public static final int PRECISION = 6;
    public static final int SCALE = 7;
    public static final int SCHEMA_NAME = 8;
    public static final int TABLE_NAME = 9;
    public static final int CASESENSITIVE = 10;
    public static final int DEFINATELYWRITABLE = 11;
    public static final int ISNULLABLE = 12;
    public static final int ISSIGNED = 13;
    public static final int ISWRITEABLE = 14;
    public static final int ISSEARCHABLE = 15;
    public static final int NUMBER_ATTRIBUTES = 16;
    public static final String S_CATALOGUE_NAME = "catalogue-name";
    public static final String S_DISPLAY_SIZE = "column-display-size";
    public static final String S_COLUMN_LABEL = "column-label";
    public static final String S_COLUMN_NAME = "column-name";
    public static final String S_COLUMN_TYPE = "column-type";
    public static final String S_COLUMN_TYPENAME = "column-type-name";
    public static final String S_PRECISION = "precision";
    public static final String S_SCALE = "scale";
    public static final String S_SCHEMA_NAME = "schema-name";
    public static final String S_TABLE_NAME = "table-name";
    public static final String S_CASESENSITIVE = "case-sensitive";
    public static final String S_DEFINATELYWRITABLE = "definitely-writable";
    public static final String S_ISNULLABLE = "nullable";
    public static final String S_ISSIGNED = "signed";
    public static final String S_ISWRITEABLE = "writable";
    public static final String S_ISSEARCHABLE = "searchable";
    static Hashtable m_namelookup = new Hashtable();

    static {
        m_namelookup.put(S_CATALOGUE_NAME, new Integer(0));
        m_namelookup.put(S_DISPLAY_SIZE, new Integer(1));
        m_namelookup.put(S_COLUMN_LABEL, new Integer(2));
        m_namelookup.put(S_COLUMN_NAME, new Integer(3));
        m_namelookup.put(S_COLUMN_TYPE, new Integer(4));
        m_namelookup.put(S_COLUMN_TYPENAME, new Integer(5));
        m_namelookup.put(S_PRECISION, new Integer(6));
        m_namelookup.put(S_SCALE, new Integer(7));
        m_namelookup.put(S_SCHEMA_NAME, new Integer(8));
        m_namelookup.put(S_TABLE_NAME, new Integer(9));
        m_namelookup.put(S_CASESENSITIVE, new Integer(10));
        m_namelookup.put(S_DEFINATELYWRITABLE, new Integer(11));
        m_namelookup.put(S_ISNULLABLE, new Integer(12));
        m_namelookup.put(S_ISSIGNED, new Integer(13));
        m_namelookup.put(S_ISWRITEABLE, new Integer(14));
        m_namelookup.put(S_ISSEARCHABLE, new Integer(15));
    }

    public ColumnAttribute(XStatement statement, Element owner, int columnIndex, int type, ResultSetMetaData metadata) {
        super(statement);
        this.m_owner = owner;
        this.m_metadata = metadata;
        this.m_columnIndex = columnIndex;
        this.m_type = type;
    }

    static String getAttrNameFromPos(int pos) {
        switch (pos) {
            case 0: {
                return S_CATALOGUE_NAME;
            }
            case 1: {
                return S_DISPLAY_SIZE;
            }
            case 2: {
                return S_COLUMN_LABEL;
            }
            case 3: {
                return S_COLUMN_NAME;
            }
            case 4: {
                return S_COLUMN_TYPE;
            }
            case 5: {
                return S_COLUMN_TYPENAME;
            }
            case 6: {
                return S_PRECISION;
            }
            case 7: {
                return S_SCALE;
            }
            case 8: {
                return S_SCHEMA_NAME;
            }
            case 9: {
                return S_TABLE_NAME;
            }
            case 10: {
                return S_CASESENSITIVE;
            }
            case 11: {
                return S_DEFINATELYWRITABLE;
            }
            case 12: {
                return S_ISNULLABLE;
            }
            case 13: {
                return S_ISSIGNED;
            }
            case 14: {
                return S_ISWRITEABLE;
            }
            case 15: {
                return S_ISSEARCHABLE;
            }
        }
        return null;
    }

    static int getAttrPosFromName(String name) {
        Integer intObj = (Integer)m_namelookup.get(name);
        if (intObj != null) {
            return intObj;
        }
        return -1;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNodeName() {
        return this.m_name;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public Element getOwnerElement() {
        return this.m_owner;
    }

    public Node getParentNode() {
        return null;
    }

    public boolean getSpecified() {
        return true;
    }

    public String getValue() {
        int i2 = this.m_columnIndex + 1;
        try {
            switch (this.m_type) {
                case 0: {
                    return this.m_metadata.getCatalogName(i2);
                }
                case 1: {
                    return Integer.toString(this.m_metadata.getColumnDisplaySize(i2));
                }
                case 2: {
                    return this.m_metadata.getColumnLabel(i2);
                }
                case 3: {
                    return this.m_metadata.getColumnName(i2);
                }
                case 4: {
                    return Integer.toString(this.m_metadata.getColumnType(i2));
                }
                case 5: {
                    return this.m_metadata.getColumnTypeName(i2);
                }
                case 6: {
                    return Integer.toString(this.m_metadata.getPrecision(i2));
                }
                case 7: {
                    return Integer.toString(this.m_metadata.getScale(i2));
                }
                case 8: {
                    return this.m_metadata.getSchemaName(i2);
                }
                case 9: {
                    return this.m_metadata.getTableName(i2);
                }
                case 10: {
                    return this.m_metadata.isCaseSensitive(i2) ? S_ISTRUE : S_ISFALSE;
                }
                case 11: {
                    return this.m_metadata.isDefinitelyWritable(i2) ? S_ISTRUE : S_ISFALSE;
                }
                case 12: {
                    return Integer.toString(this.m_metadata.isNullable(i2));
                }
                case 13: {
                    return this.m_metadata.isSigned(i2) ? S_ISTRUE : S_ISFALSE;
                }
                case 14: {
                    return this.m_metadata.isWritable(i2) ? S_ISTRUE : S_ISFALSE;
                }
                case 15: {
                    return this.m_metadata.isSearchable(i2) ? S_ISTRUE : S_ISFALSE;
                }
            }
            return "";
        }
        catch (SQLException sQLException) {
            return "SQL ERROR!";
        }
    }

    public boolean setName(String name) {
        this.m_name = name;
        int i2 = ColumnAttribute.getAttrPosFromName(name);
        return i2 >= 0;
    }

    public void setValue(String value) throws DOMException {
        this.error(80);
    }
}

