/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.PageData;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.PageDataImpl;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XmlOutputter {
    private StringBuffer sb = new StringBuffer();
    private AttributesImpl rootAttrs = new AttributesImpl();
    private int jspRootLevel = 0;
    public static final String JSP_NAMESPACE = "http://java.sun.com/JSP/Page";
    public static final String JSP_VERSION = "1.2";

    XmlOutputter() {
        this.rootAttrs.addAttribute("", "xmlns:jsp", "xmlns:jsp", "CDATA", JSP_NAMESPACE);
        this.rootAttrs.addAttribute("", "version", "version", "CDATA", JSP_VERSION);
    }

    void addRootAttrs(Attributes attrs) {
        ++this.jspRootLevel;
        int attrsLength = attrs.getLength();
        int i2 = 0;
        while (i2 < attrsLength) {
            String qName = attrs.getQName(i2);
            if (!attrs.getQName(i2).startsWith("xmlns:jsp") || this.jspRootLevel <= 1) {
                this.rootAttrs.addAttribute(attrs.getURI(i2), attrs.getLocalName(i2), attrs.getQName(i2), attrs.getType(i2), attrs.getValue(i2));
            }
            ++i2;
        }
    }

    void addRootNamespaces(String prefix, String uri) {
        this.rootAttrs.addAttribute("", "xmlns", "xmlns:" + prefix, "CDATA", uri);
    }

    void append(String tag) {
        this.sb.append("</").append(tag).append(">\n");
    }

    void append(String tag, Hashtable table) {
        if (table == null) {
            return;
        }
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = ((String[])table.get(name))[0];
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "name", "name", "CDATA", name);
            attrs.addAttribute("", "value", "value", "CDATA", value);
            this.append(tag, (Attributes)attrs, this.sb);
            this.append(tag);
        }
    }

    void append(String tag, Attributes attrs) {
        this.append(tag, attrs, this.sb);
    }

    void append(String tag, Attributes attrs, StringBuffer buff) {
        buff.append("<").append(tag);
        if (attrs == null || attrs.getLength() < 1) {
            buff.append(">");
        } else {
            buff.append("\n");
            int attrsLength = attrs.getLength();
            int i2 = 0;
            while (i2 < attrsLength) {
                String name = attrs.getQName(i2);
                String value = attrs.getValue(i2);
                buff.append("  ").append(name).append("=\"");
                buff.append(JspUtil.getExprInXml(value)).append("\"\n");
                ++i2;
            }
            buff.append(">\n");
        }
    }

    void append(String tag, Attributes attrs, char[] text) {
        this.append(tag, attrs);
        this.append(text);
        this.sb.append("</").append(tag).append(">\n");
    }

    void append(char[] text) {
        this.sb.append("<![CDATA[\n");
        this.sb.append(text);
        this.sb.append("]]>\n");
    }

    PageData getPageData() {
        StringBuffer buff = new StringBuffer();
        AttributesImpl attrs = new AttributesImpl();
        this.append("jsp:root", (Attributes)this.rootAttrs, buff);
        buff.append(this.sb.toString());
        buff.append("</jsp:root>");
        ByteArrayInputStream is = new ByteArrayInputStream(buff.toString().getBytes());
        PageDataImpl pageData = new PageDataImpl(is);
        return pageData;
    }

    void rootEnd() {
        --this.jspRootLevel;
        if (this.jspRootLevel == 0) {
            this.append("jsp:root");
        }
    }
}

