/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.net.URL;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.logging.Logger;

public class JspCompiler
extends Compiler
implements Mangler {
    String javaFileName;
    String classFileName;
    String realClassName;
    String jsp;
    String outputDir;
    boolean outDated;
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "JspCompiler");

    public JspCompiler(JspCompilationContext ctxt) throws JasperException {
        super(ctxt);
        this.jsp = ctxt.getJspFile();
        this.outputDir = ctxt.getOutputDir();
        this.outDated = false;
        this.setMangler(this);
    }

    private final String getBaseClassName() {
        String className = this.jsp.endsWith(".jsp") ? this.jsp.substring(0, this.jsp.length() - 4) : this.jsp;
        StringBuffer modifiedClassName = new StringBuffer();
        int i2 = 0;
        while (i2 < className.length()) {
            if (Character.isLetterOrDigit(className.charAt(i2))) {
                modifiedClassName.append(className.substring(i2, i2 + 1));
            } else {
                modifiedClassName.append(JspCompiler.mangleChar(className.charAt(i2)));
            }
            ++i2;
        }
        modifiedClassName.append("_jsp");
        return modifiedClassName.toString();
    }

    public final String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        this.classFileName = String.valueOf(this.getClassName()) + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = String.valueOf(this.outputDir) + File.separatorChar + this.classFileName;
        }
        return this.classFileName;
    }

    public final String getClassName() {
        if (this.realClassName == null) {
            this.realClassName = this.getBaseClassName();
        }
        return this.realClassName;
    }

    public final String getJavaFileName() {
        if (this.javaFileName != null) {
            return this.javaFileName;
        }
        this.javaFileName = String.valueOf(this.getClassName()) + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = String.valueOf(this.outputDir) + File.separatorChar + this.javaFileName;
        }
        return this.javaFileName;
    }

    public boolean isOutDated() {
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(this.jsp);
            if (jspUrl == null) {
                return true;
            }
            jspRealLastModified = jspUrl.openConnection().getLastModified();
        }
        catch (Exception e10) {
            e10.printStackTrace();
            return true;
        }
        File classFile = new File(this.getClassFileName());
        this.outDated = classFile.exists() ? classFile.lastModified() < jspRealLastModified : true;
        return this.outDated;
    }

    private static final String mangleChar(char ch2) {
        if (ch2 == File.separatorChar) {
            ch2 = (char)47;
        }
        String s2 = Integer.toHexString(ch2);
        int nzeros = 5 - s2.length();
        char[] result = new char[6];
        result[0] = 95;
        int i2 = 1;
        while (i2 <= nzeros) {
            result[i2] = 48;
            ++i2;
        }
        int i3 = nzeros + 1;
        int j2 = 0;
        while (i3 < 6) {
            result[i3] = s2.charAt(j2);
            ++i3;
            ++j2;
        }
        return new String(result);
    }
}

