/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.ClassDeclarationPhase;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.xml.sax.Attributes;

public class BeanGenerator
extends GeneratorBase
implements ServiceMethodPhase,
ClassDeclarationPhase {
    Attributes attrs;
    BeanRepository beanInfo;
    boolean genSession;
    boolean beanRT = false;
    Mark start;
    boolean isXml;
    static /* synthetic */ Class class$org$apache$jasper$compiler$ClassDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$ServiceMethodPhase;

    public BeanGenerator(Mark start, Attributes attrs, BeanRepository beanInfo, boolean genSession, boolean isXml) {
        this.attrs = attrs;
        this.beanInfo = beanInfo;
        this.genSession = genSession;
        this.start = start;
        this.isXml = isXml;
    }

    public void checkSyntax(ServletWriter writer, Class phase) throws JasperException {
        String name;
        String varname = name = this.getAttribute("id");
        String serfile = name;
        String scope = this.getAttribute("scope");
        String clsname = this.getAttribute("class");
        String type = this.getAttribute("type");
        String beanName = this.getAttribute("beanName");
        if (name == null) {
            String m2 = Constants.getString("jsp.error.usebean.missing.attribute");
            throw new CompileException(this.start, m2);
        }
        if (clsname == null && type == null) {
            String m3 = Constants.getString("jsp.error.usebean.missing.type", new Object[]{name});
            throw new CompileException(this.start, m3);
        }
        if (this.beanInfo.checkVariable(name)) {
            String m4 = Constants.getString("jsp.error.usebean.duplicate", new Object[]{name});
            throw new CompileException(this.start, m4);
        }
        if (scope != null && scope.equalsIgnoreCase("session") && !this.genSession) {
            String m5 = Constants.getString("jsp.error.usebean.prohibited.as.session", new Object[]{name});
            throw new CompileException(this.start, m5);
        }
        if (clsname != null && beanName != null) {
            String m6 = Constants.getString("jsp.error.usebean.not.both", new Object[]{name});
            throw new CompileException(this.start, m6);
        }
        if (clsname == null) {
            clsname = type;
        }
        if (scope == null || scope.equals("page")) {
            this.beanInfo.addPageBean(name, clsname);
        } else if (scope.equals("request")) {
            this.beanInfo.addRequestBean(name, clsname);
        } else if (scope.equals("session")) {
            this.beanInfo.addSessionBean(name, clsname);
        } else if (scope.equals("application")) {
            this.beanInfo.addApplicationBean(name, clsname);
        } else {
            String m7 = Constants.getString("jsp.error.usebean.invalid.scope", new Object[]{name, scope});
            throw new CompileException(this.start, m7);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void createBean(ServletWriter writer, String varname, String clsname, String beanName, String name, String type, String scope) {
        if (clsname != null || beanName != null) {
            writer.println("if ( " + varname + " == null ) {");
            writer.pushIndent();
            writer.println("_jspx_special" + name + " = true;");
            this.generateBeanCreate(writer, varname, clsname, beanName, type);
            writer.println("pageContext.setAttribute(" + writer.quoteString(name) + ", " + varname + ", " + scope + ");");
            writer.popIndent();
            writer.println("}");
        } else {
            writer.println("if (" + varname + "  == null) ");
            writer.println(" throw new java.lang.InstantiationException (\"bean " + varname + "  not found within scope \"); ");
        }
    }

    private void declareBean(ServletWriter writer, String type, String varname) {
        writer.println(String.valueOf(type) + " " + varname + " = null;");
        writer.println("boolean _jspx_special" + varname + "  = false;");
    }

    public void generate(ServletWriter writer, Class phase) throws JasperException {
        if ((class$org$apache$jasper$compiler$ClassDeclarationPhase != null ? class$org$apache$jasper$compiler$ClassDeclarationPhase : (class$org$apache$jasper$compiler$ClassDeclarationPhase = BeanGenerator.class$("org.apache.jasper.compiler.ClassDeclarationPhase"))).equals(phase)) {
            this.checkSyntax(writer, phase);
        } else if ((class$org$apache$jasper$compiler$ServiceMethodPhase != null ? class$org$apache$jasper$compiler$ServiceMethodPhase : (class$org$apache$jasper$compiler$ServiceMethodPhase = BeanGenerator.class$("org.apache.jasper.compiler.ServiceMethodPhase"))).equals(phase)) {
            this.generateMethod(writer, phase);
        }
    }

    protected void generateBeanCreate(ServletWriter writer, String varname, String clsname, String beanName, String type) {
        String convert;
        String string = convert = clsname == null ? type : clsname;
        if (beanName != null) {
            clsname = beanName;
        }
        writer.println("try {");
        writer.pushIndent();
        if (!this.beanRT) {
            writer.println(String.valueOf(varname) + " = (" + convert + ") java.beans.Beans.instantiate(this.getClass().getClassLoader(), " + writer.quoteString(clsname) + ");");
        } else {
            writer.println(String.valueOf(varname) + " = (" + convert + ") java.beans.Beans.instantiate(this.getClass().getClassLoader(), " + clsname + ");");
        }
        writer.popIndent();
        writer.println("} catch (Exception exc) {");
        writer.pushIndent();
        writer.println(" throw new ServletException (\" Cannot create bean of class \"+\"" + clsname + "\", exc);");
        writer.popIndent();
        writer.println("}");
    }

    private void generateInit(ServletWriter writer, String name) {
        writer.println("if(_jspx_special" + name + " == true) {");
    }

    public void generateMethod(ServletWriter writer, Class phase) throws JasperException {
        String name;
        String varname = name = this.getAttribute("id");
        String serfile = name;
        String scope = this.getAttribute("scope");
        String clsname = this.getAttribute("class");
        String type = this.getAttribute("type");
        String beanName = this.getAttribute("beanName");
        if (type == null) {
            type = clsname;
        }
        if (beanName != null && JspUtil.isExpression(beanName, this.isXml)) {
            beanName = JspUtil.getExpr(beanName, this.isXml);
            this.beanRT = true;
        }
        if (scope == null || scope.equals("page")) {
            this.declareBean(writer, type, varname);
            this.lock(writer, "pageContext");
            this.locateBean(writer, type, varname, name, "PageContext.PAGE_SCOPE");
            this.createBean(writer, varname, clsname, beanName, name, type, "PageContext.PAGE_SCOPE");
            this.unlock(writer);
            this.generateInit(writer, varname);
        } else if (scope.equals("request")) {
            this.declareBean(writer, type, varname);
            this.lock(writer, "request");
            this.locateBean(writer, type, varname, name, "PageContext.REQUEST_SCOPE");
            this.createBean(writer, varname, clsname, beanName, name, type, "PageContext.REQUEST_SCOPE");
            this.unlock(writer);
            this.generateInit(writer, varname);
        } else if (scope.equals("session")) {
            this.declareBean(writer, type, varname);
            this.lock(writer, "session");
            this.locateBean(writer, type, varname, name, "PageContext.SESSION_SCOPE");
            this.createBean(writer, varname, clsname, beanName, name, type, "PageContext.SESSION_SCOPE");
            this.unlock(writer);
            this.generateInit(writer, varname);
        } else if (scope.equals("application")) {
            this.declareBean(writer, type, varname);
            this.lock(writer, "application");
            this.locateBean(writer, type, varname, name, "PageContext.APPLICATION_SCOPE");
            this.createBean(writer, varname, clsname, beanName, name, type, "PageContext.APPLICATION_SCOPE");
            this.unlock(writer);
            this.generateInit(writer, varname);
        }
    }

    public String getAttribute(String name) {
        return this.attrs != null ? this.attrs.getValue(name) : null;
    }

    private void locateBean(ServletWriter writer, String type, String varname, String name, String scope) {
        writer.println(String.valueOf(varname) + "= (" + type + ")");
        writer.println("pageContext.getAttribute(" + writer.quoteString(name) + "," + scope + ");");
    }

    private void lock(ServletWriter writer, String scope) {
        writer.println(" synchronized (" + scope + ") {");
        writer.pushIndent();
    }

    private void unlock(ServletWriter writer) {
        writer.popIndent();
        writer.println(" } ");
    }
}

