/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.parser.AttributesEx;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlWritable;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private ElementNode ownerElement;

    AttributeSet(ElementNode ownerElement) {
        this.list = new Vector(5);
        this.ownerElement = ownerElement;
    }

    AttributeSet(AttributeSet original, boolean deep) {
        int size = original.getLength();
        this.list = new Vector(size);
        int i2 = 0;
        while (i2 < size) {
            Node node = original.item(i2);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attr = (AttributeNode)node;
            node = attr.cloneAttributeNode(deep);
            this.list.addElement(node);
            ++i2;
        }
    }

    AttributeSet(Attributes source) throws DOMException {
        int len = source.getLength();
        AttributesEx ex2 = null;
        this.list = new Vector(len);
        if (source instanceof AttributesEx) {
            ex2 = (AttributesEx)source;
        }
        int i2 = 0;
        while (i2 < len) {
            String uri;
            String qName = source.getQName(i2);
            if ("xmlns".equals(qName) || "xmlns".equals(XmlNames.getPrefix(qName))) {
                uri = "http://www.w3.org/2000/xmlns/";
            } else {
                uri = source.getURI(i2);
                if (uri.equals("")) {
                    uri = null;
                }
            }
            AttributeNode attrNode = new AttributeNode(uri, qName, source.getValue(i2), ex2 == null ? true : ex2.isSpecified(i2), ex2 == null ? null : ex2.getDefault(i2));
            this.list.addElement(attrNode);
            ++i2;
        }
        this.list.trimToSize();
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public void setReadonly() {
        this.readonly = true;
        int i2 = 0;
        while (i2 < this.list.size()) {
            ((AttributeNode)this.list.elementAt(i2)).setReadonly(true);
            ++i2;
        }
    }

    public boolean isReadonly() {
        if (this.readonly) {
            return true;
        }
        int i2 = 0;
        while (i2 < this.list.size()) {
            if (((AttributeNode)this.list.elementAt(i2)).isReadonly()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    void setOwnerElement(ElementNode e10) {
        if (e10 != null && this.ownerElement != null) {
            throw new IllegalStateException(e10.getMessage("A-004"));
        }
        this.ownerElement = e10;
        int length = this.list.size();
        int i2 = 0;
        while (i2 < length) {
            AttributeNode node = (AttributeNode)this.list.elementAt(i2);
            node.setOwnerElement(null);
            node.setOwnerElement(e10);
            ++i2;
        }
    }

    String getValue(String name) {
        Attr attr = (Attr)this.getNamedItem(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Node getNamedItem(String name) {
        int length = this.list.size();
        int i2 = 0;
        while (i2 < length) {
            Node value = this.item(i2);
            if (value.getNodeName().equals(name)) {
                return value;
            }
            ++i2;
        }
        return null;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        int i2 = 0;
        while (i2 < this.list.size()) {
            String iNamespaceURI;
            Node value = this.item(i2);
            String iLocalName = value.getLocalName();
            if (iLocalName != null && iLocalName.equals(localName) && (iNamespaceURI = value.getNamespaceURI()) != null && iNamespaceURI.equals(namespaceURI)) {
                return value;
            }
            ++i2;
        }
        return null;
    }

    public int getLength() {
        return this.list.size();
    }

    public Node item(int index) {
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(index);
    }

    public Node removeNamedItem(String name) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int i2 = 0;
        while (i2 < this.list.size()) {
            Node value = (Node)this.list.elementAt(i2);
            if (value.getNodeName().equals(name)) {
                AttributeNode att = (AttributeNode)value;
                String defaultValue = att.getDefaultValue();
                if (defaultValue != null) {
                    att.setValue(defaultValue);
                    att.setSpecified(false);
                } else {
                    this.list.removeElementAt(i2);
                }
                return value;
            }
            ++i2;
        }
        throw new DomEx(8);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int i2 = 0;
        while (i2 < this.list.size()) {
            String iNamespaceURI;
            Node value = (Node)this.list.elementAt(i2);
            String iLocalName = value.getLocalName();
            if (iLocalName != null && iLocalName.equals(localName) && (iNamespaceURI = value.getNamespaceURI()) != null && iNamespaceURI.equals(namespaceURI)) {
                AttributeNode attr = (AttributeNode)value;
                String defaultValue = attr.getDefaultValue();
                if (defaultValue != null) {
                    attr.setValue(defaultValue);
                    attr.setSpecified(false);
                } else {
                    this.list.removeElementAt(i2);
                }
                return value;
            }
            ++i2;
        }
        throw new DomEx(8);
    }

    public Node setNamedItem(Node value) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(value instanceof AttributeNode) || value.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode att = (AttributeNode)value;
        if (att.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        int length = this.list.size();
        int i2 = 0;
        while (i2 < length) {
            AttributeNode oldAtt = (AttributeNode)this.item(i2);
            if (oldAtt.getNodeName().equals(value.getNodeName())) {
                if (oldAtt.isReadonly()) {
                    throw new DomEx(7);
                }
                att.setOwnerElement(this.ownerElement);
                this.list.setElementAt(att, i2);
                oldAtt.setOwnerElement(null);
                return oldAtt;
            }
            ++i2;
        }
        att.setOwnerElement(this.ownerElement);
        this.list.addElement(value);
        return null;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(arg instanceof AttributeNode) || arg.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attr = (AttributeNode)arg;
        if (attr.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        int length = this.list.size();
        int i2 = 0;
        while (i2 < length) {
            AttributeNode oldNode = (AttributeNode)this.item(i2);
            String localName = oldNode.getLocalName();
            String namespaceURI = oldNode.getNamespaceURI();
            if (attr.getLocalName().equals(localName) && attr.getNamespaceURI().equals(namespaceURI)) {
                if (oldNode.isReadonly()) {
                    throw new DomEx(7);
                }
                attr.setOwnerElement(this.ownerElement);
                this.list.setElementAt(attr, i2);
                oldNode.setOwnerElement(null);
                return oldNode;
            }
            ++i2;
        }
        attr.setOwnerElement(this.ownerElement);
        this.list.addElement(attr);
        return null;
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        int length = this.list.size();
        int i2 = 0;
        while (i2 < length) {
            AttributeNode tmp = (AttributeNode)this.list.elementAt(i2);
            if (tmp.getSpecified()) {
                out.write(32);
                tmp.writeXml(context);
            }
            ++i2;
        }
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
    }

    public String toString() {
        try {
            CharArrayWriter w2 = new CharArrayWriter();
            XmlWriteContext x2 = new XmlWriteContext(w2);
            this.writeXml(x2);
            return w2.toString();
        }
        catch (IOException e10) {
            return super.toString();
        }
    }
}

