/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.catalina.util.xml.AddChild;
import org.apache.catalina.util.xml.MethodParam;
import org.apache.catalina.util.xml.MethodSetter;
import org.apache.catalina.util.xml.ObjectCreate;
import org.apache.catalina.util.xml.PathMatch;
import org.apache.catalina.util.xml.PopStack;
import org.apache.catalina.util.xml.SaxContext;
import org.apache.catalina.util.xml.SetParent;
import org.apache.catalina.util.xml.SetProperties;
import org.apache.catalina.util.xml.XmlAction;
import org.apache.catalina.util.xml.XmlMatch;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlMapper
extends HandlerBase
implements SaxContext {
    Locator locator;
    private Hashtable fileDTDs = new Hashtable();
    private Hashtable resDTDs = new Hashtable();
    Stack oStack = new Stack();
    Object root;
    Object[] attributeStack;
    String[] tagStack;
    int oSp;
    int sp;
    String body;
    int debug = 0;
    boolean validating = false;
    String publicId = null;
    Rule[] rules = new Rule[256];
    Rule[] matching = new Rule[256];
    int ruleCount = 0;

    public XmlMapper() {
        this.attributeStack = new Object[256];
        this.tagStack = new String[256];
        this.initDefaultRules();
    }

    public XmlAction addChild(String parentM, String argType) {
        return new AddChild(parentM, argType);
    }

    public void addRule(String path, XmlAction action) {
        this.rules[this.ruleCount] = new Rule(new PathMatch(path), action);
        ++this.ruleCount;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.body = String.valueOf(this.body) + new String(buf, offset, len);
    }

    public void endDocument() throws SAXException {
        if (this.sp != 0) {
            System.out.println("The XML document is probably broken. " + this.sp);
        }
        this.publicId = null;
    }

    public void endElement(String tag) throws SAXException {
        try {
            this.matchEnd(this);
            if (this.sp > 1) {
                this.tagStack[this.sp] = null;
                this.attributeStack[this.sp] = null;
            }
            --this.sp;
        }
        catch (Exception ex2) {
            throw new SAXException(this.positionToString(), ex2);
        }
    }

    public void error(SAXParseException e10) throws SAXException {
        if (this.validating) {
            this.fatalError(e10);
        }
    }

    public AttributeList getAttributeList(int pos) {
        return (AttributeList)this.attributeStack[pos];
    }

    public String getBody() {
        return this.body;
    }

    public int getDebug() {
        return this.debug;
    }

    public Stack getObjectStack() {
        return this.oStack;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public Object getRoot() {
        return this.root;
    }

    public String getTag(int pos) {
        return this.tagStack[pos];
    }

    public int getTagCount() {
        return this.sp;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    private void initDefaultRules() {
        this.addRule("xmlmapper:debug", new XmlAction(){

            public void start(SaxContext ctx) {
                int top = ctx.getTagCount() - 1;
                AttributeList attributes = ctx.getAttributeList(top);
                String levelS = attributes.getValue("level");
                XmlMapper mapper = (XmlMapper)ctx;
                if (levelS != null) {
                    mapper.setDebug(new Integer(levelS));
                }
            }
        });
        this.addRule("xmlmapper:taskdef", new XmlAction(){

            public void start(SaxContext ctx) {
                block7: {
                    XmlMapper mapper = (XmlMapper)ctx;
                    int top = ctx.getTagCount() - 1;
                    AttributeList attributes = ctx.getAttributeList(top);
                    String match = attributes.getValue("match");
                    if (match == null) {
                        return;
                    }
                    String obj = attributes.getValue("object-create");
                    String objA = attributes.getValue("object-create-attrib");
                    if (obj != null || objA != null) {
                        mapper.addRule(match, new ObjectCreate(obj, objA));
                    }
                    if ((obj = attributes.getValue("set-properties")) != null) {
                        mapper.addRule(match, new SetProperties());
                    }
                    if ((obj = attributes.getValue("set-parent")) != null) {
                        mapper.addRule(match, new SetParent(obj));
                    }
                    obj = attributes.getValue("add-child");
                    objA = attributes.getValue("child-type");
                    if (obj != null) {
                        mapper.addRule(match, new AddChild(obj, objA));
                    }
                    if ((obj = attributes.getValue("action")) == null) break block7;
                    try {
                        Class<?> c10 = Class.forName(obj);
                        Object o2 = c10.newInstance();
                        mapper.addRule(match, (XmlAction)o2);
                    }
                    catch (Exception exception) {
                        System.out.println("Can't add action " + obj);
                    }
                }
            }
        });
    }

    public void log(String msg) {
        System.out.println("XmlMapper: " + msg);
    }

    private int match(SaxContext ctx, Rule[] matching) {
        int matchCount = 0;
        int i2 = 0;
        while (i2 < this.ruleCount) {
            if (this.rules[i2].match.match(ctx) && this.rules[i2].action != null) {
                matching[matchCount] = this.rules[i2];
                ++matchCount;
            }
            ++i2;
        }
        return matchCount;
    }

    void matchEnd(SaxContext ctx) throws Exception {
        int matchCount = this.match(ctx, this.matching);
        int i2 = 0;
        while (i2 < matchCount) {
            this.matching[i2].action.end(ctx);
            ++i2;
        }
        int i3 = 0;
        while (i3 < matchCount) {
            this.matching[i3].action.cleanup(ctx);
            ++i3;
        }
    }

    void matchStart(SaxContext ctx) throws Exception {
        int matchCount = this.match(ctx, this.matching);
        int i2 = 0;
        while (i2 < matchCount) {
            this.matching[i2].action.start(ctx);
            ++i2;
        }
    }

    public XmlAction methodParam(int ord) {
        return new MethodParam(ord, null);
    }

    public XmlAction methodParam(int ord, String attrib) {
        return new MethodParam(ord, attrib);
    }

    public XmlAction methodSetter(String method, int paramC) {
        return new MethodSetter(method, paramC);
    }

    public XmlAction methodSetter(String method, int paramC, String[] paramTypes) {
        return new MethodSetter(method, paramC, paramTypes);
    }

    public void notationDecl(String name, String publicId, String systemId) {
        if (this.debug >= 1) {
            System.out.println("Notation: " + name + " " + publicId + " " + systemId);
        }
    }

    public XmlAction objectCreate(String classN) {
        return new ObjectCreate(classN);
    }

    public XmlAction objectCreate(String classN, String attrib) {
        return new ObjectCreate(classN, attrib);
    }

    public XmlAction popStack() {
        return new PopStack();
    }

    private String positionToString() {
        StringBuffer sb = new StringBuffer();
        if (this.locator != null) {
            sb.append("Line ").append(this.locator.getLineNumber()).append(" ");
        }
        sb.append("/");
        int i2 = 0;
        while (i2 < this.sp) {
            sb.append(this.tagStack[i2]).append("/");
            ++i2;
        }
        sb.append(" ");
        AttributeList attributes = (AttributeList)this.attributeStack[this.sp - 1];
        if (attributes != null) {
            int i3 = 0;
            while (i3 < attributes.getLength()) {
                sb.append(attributes.getName(i3)).append("=").append(attributes.getValue(i3));
                sb.append(" ");
                ++i3;
            }
        }
        return sb.toString();
    }

    public void processingInstruction(String name, String instruction) throws SAXException {
    }

    public Object readXml(File xmlFile, Object root) throws Exception {
        if (root != null) {
            Stack st = this.getObjectStack();
            this.root = root;
            st.push(root);
        }
        try {
            SAXParser parser = null;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(this.validating);
            parser = factory.newSAXParser();
            parser.parse(xmlFile, (HandlerBase)this);
            return root;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            String msg = "Can't open config file: " + xmlFile.getAbsolutePath() + " due to: " + ioe;
            throw new Exception(msg);
        }
        catch (SAXParseException spe) {
            System.out.println("PARSE error at line " + spe.getLineNumber() + " column " + spe.getColumnNumber() + " of " + xmlFile.getAbsolutePath());
            System.out.println(spe.toString());
            throw spe;
        }
        catch (SAXException se) {
            System.out.println("ERROR reading " + xmlFile);
            System.out.println("At " + se.getMessage());
            System.out.println();
            Exception ex1 = se.getException();
            if (ex1 != null) {
                throw ex1;
            }
            throw se;
        }
    }

    public Object readXml(InputStream xmlFile, Object root) throws Exception {
        if (root != null) {
            Stack st = this.getObjectStack();
            this.root = root;
            st.push(root);
        }
        SAXParser parser = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(this.validating);
            parser = factory.newSAXParser();
            parser.parse(xmlFile, (HandlerBase)this);
            return root;
        }
        catch (IOException ioe) {
            String msg = "Can't open config file: " + xmlFile + " due to: " + ioe;
            throw new Exception(msg);
        }
        catch (SAXParseException spe) {
            System.out.println("PARSE error at line " + spe.getLineNumber() + " column " + spe.getColumnNumber());
            System.out.println(spe.toString());
            throw spe;
        }
        catch (SAXException se) {
            System.out.println("ERROR reading " + xmlFile);
            System.out.println("At " + se.getMessage());
            System.out.println();
            Exception ex1 = se.getException();
            throw ex1;
        }
    }

    public void registerDTDFile(String publicId, String dtdFile) {
        this.fileDTDs.put(publicId, dtdFile);
    }

    public void registerDTDRes(String publicId, String dtdRes) {
        this.resDTDs.put(publicId, dtdRes);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        File dtdF;
        if (this.debug >= 1) {
            System.out.println("Resolve: " + publicId + " " + systemId);
        }
        this.publicId = publicId;
        String dtd = (String)this.fileDTDs.get(publicId);
        if (dtd != null && (dtdF = new File(dtd)).exists()) {
            try {
                return new InputSource(new FileInputStream(dtdF));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if ((dtd = (String)this.resDTDs.get(publicId)) != null) {
            InputStream is = this.getClass().getResourceAsStream(dtd);
            if (is != null) {
                return new InputSource(is);
            }
            System.out.println("XXX resource not found !!! " + dtd);
            System.out.println(this.getClass().getClassLoader().getClass().getName());
        }
        this.log("Can't find resource for entity: " + publicId + " --> " + systemId + " \"" + dtd + "\"");
        return null;
    }

    public void setDebug(int level) {
        if (level != 0) {
            this.log("Debug level: " + level);
        }
        this.debug = level;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.debug > 0) {
            this.log("Set locator : " + locator);
        }
        this.locator = locator;
    }

    public XmlAction setParent(String childM) {
        return new SetParent(childM);
    }

    public XmlAction setParent(String childM, String argType) {
        return new SetParent(childM, argType);
    }

    public XmlAction setProperties() {
        return new SetProperties();
    }

    public void setRoot(Object o2) {
        this.root = o2;
    }

    public void setValidating(boolean validating) {
        if (this.debug >= 1) {
            this.log("Validating = " + validating);
        }
        this.validating = validating;
    }

    public void startDocument() throws SAXException {
        this.sp = 0;
    }

    public void startElement(String tag, AttributeList attributes) throws SAXException {
        try {
            this.attributeStack[this.sp] = attributes;
            this.tagStack[this.sp] = tag;
            ++this.sp;
            this.matchStart(this);
            this.body = "";
        }
        catch (Exception ex2) {
            throw new SAXException(this.positionToString(), ex2);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        if (this.debug >= 1) {
            System.out.println("Unparsed: " + name + " " + publicId + " " + systemId + " " + notationName);
        }
    }

    class Rule {
        XmlMatch match;
        XmlAction action;

        Rule(XmlMatch match, XmlAction action) {
            this.match = match;
            this.action = action;
        }
    }
}

