/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.xml;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import org.apache.catalina.util.xml.SaxContext;
import org.apache.catalina.util.xml.XmlAction;
import org.xml.sax.AttributeList;

class SetProperties
extends XmlAction {
    static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    static void setProperty(SaxContext ctx, Object o2, String name, String value) {
        block23: {
            if (ctx.getDebug() > 1) {
                ctx.log("setProperty(" + o2.getClass() + " " + name + "=" + value + ")");
            }
            String setter = "set" + SetProperties.capitalize(name);
            try {
                Method[] methods = o2.getClass().getMethods();
                Method setPropertyMethod = null;
                int i2 = 0;
                while (i2 < methods.length) {
                    Class<?>[] paramT = methods[i2].getParameterTypes();
                    if (setter.equals(methods[i2].getName()) && paramT.length == 1 && "java.lang.String".equals(paramT[0].getName())) {
                        methods[i2].invoke(o2, value);
                        return;
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 < methods.length) {
                    boolean ok = true;
                    if (setter.equals(methods[i3].getName()) && methods[i3].getParameterTypes().length == 1) {
                        Class<?> paramType = methods[i3].getParameterTypes()[0];
                        Object[] params = new Object[1];
                        if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                            try {
                                params[0] = new Integer(value);
                            }
                            catch (NumberFormatException numberFormatException) {
                                ok = false;
                            }
                        } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                            params[0] = new Boolean(value);
                        } else {
                            ctx.log("Unknown type " + paramType.getName());
                        }
                        if (ok) {
                            methods[i3].invoke(o2, params);
                            return;
                        }
                    }
                    if ("setProperty".equals(methods[i3].getName())) {
                        setPropertyMethod = methods[i3];
                    }
                    ++i3;
                }
                if (setPropertyMethod != null) {
                    Object[] params = new Object[]{name, value};
                    setPropertyMethod.invoke(o2, params);
                }
            }
            catch (SecurityException ex1) {
                if (ctx.getDebug() > 0) {
                    ctx.log("SecurityException for " + o2.getClass() + " " + name + "=" + value + ")");
                }
                if (ctx.getDebug() > 1) {
                    ex1.printStackTrace();
                }
            }
            catch (IllegalAccessException iae) {
                if (ctx.getDebug() > 0) {
                    ctx.log("IllegalAccessException for " + o2.getClass() + " " + name + "=" + value + ")");
                }
                if (ctx.getDebug() > 1) {
                    iae.printStackTrace();
                }
            }
            catch (InvocationTargetException ie) {
                if (ctx.getDebug() > 0) {
                    ctx.log("InvocationTargetException for " + o2.getClass() + " " + name + "=" + value + ")");
                }
                if (ctx.getDebug() <= 1) break block23;
                ie.printStackTrace();
            }
        }
    }

    public void start(SaxContext ctx) {
        Stack st = ctx.getObjectStack();
        Object elem = st.peek();
        int top = ctx.getTagCount() - 1;
        AttributeList attributes = ctx.getAttributeList(top);
        int i2 = 0;
        while (i2 < attributes.getLength()) {
            String type = attributes.getType(i2);
            String name = attributes.getName(i2);
            String value = attributes.getValue(i2);
            SetProperties.setProperty(ctx, elem, name, value);
            ++i2;
        }
    }
}

